

set -x

version=v1r14

#-------------------------------------------------------------
# Setup a temporary directory
#-------------------------------------------------------------

#-------------------------------------------------------------
# Install a local RPM database
#-------------------------------------------------------------

tempdir=/tmp/CMT

rm -rf ${tempdir}

database=${tempdir}/rpm-database

mkdir -p ${database}

rpm --dbpath ${database} --initdb
rpm --dbpath ${database} -Uvh virtual.rpm

rpm --dbpath ${database} -e CMT

#-------------------------------------------------------------
# Install from the bin RPM
#-------------------------------------------------------------

tempdir1=$1

if test "${tempdir1}" = ""; then
  tempdir1=/tmp/CMT1
  rm -rf ${tempdir1}
  mkdir -p ${tempdir1}
fi

rpm --quiet --dbpath ${database} -Uvh --relocate /CMT=${tempdir1}/CMT \
  ../rpm/CMT-${version}-1.i386.rpm

source ${tempdir1}/CMT/${version}/mgr/setup.sh

cmt version




