//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#ifndef __cmt_language_h__
#define __cmt_language_h__

#include "cmt_parser.h"
#include "cmt_fragment.h"

class Language
{
public:
  typedef cmt_vector<Language> LanguageVector;
  static void action (const CmtSystem::cmt_string_vector& words,
		      Use* use);
  static Language& find (const cmt_string& name);
  static Language& find_with_suffix (const cmt_string& suffix);
  static Language& add (const cmt_string& name);
  static void show (const cmt_string& name);
  static void show_all ();
  static void show_names ();
  static void setup_all_fragments ();
  static void clear_all ();
  static LanguageVector& languages ();
  static Language& null ();

public:
  Language ();
  ~Language ();
  void clear ();
  void show (PrintMode mode = Csh, ostream& out = cout); // Csh is default for ArgParser::mode
  //  void show ();
  void setup_fragments ();
  bool operator == (const cmt_string& name) const;
  bool operator == (const Language& other) const;
  bool operator != (const Language& other) const;
  bool native_dependencies ();
  const cmt_string& dependencies_options () const;
  const cmt_string& dependencies_options_expanded ();

  cmt_string m_name;
  cmt_string fragment_name;
  cmt_string linker;
  cmt_string output_suffix;
  bool prototypes;
  cmt_string preprocessor_command;
  CmtSystem::cmt_string_vector suffixes;
  CmtSystem::cmt_string_vector extra_output_suffixes;
  UseRef m_use;

  FragmentHandle application;
  FragmentHandle library;

private:
  void setup_native_dependencies ();

  bool m_native_dependencies;
  cmt_string m_dependencies_options;
  cmt_string m_dependencies_options_expanded;
  bool m_native_dependencies_set;
};

#endif
