//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#ifndef __cmt_sequence_h__
#define __cmt_sequence_h__

#include "cmt_awk.h"

/**
 *  This very simplified sequence interpreter is meant for 
 *  internal use only, for driving demo or test scenarios.
 *   This is run as follows:
 *
 *      > cd ../demo
 *      > cmt run_sequence xxx.cmt
 *
 *   where xxx.cmt is a text file containing descriptions of sequence steps:
 *
 *   sequence_step :
 *       package-creation
 *     | file-description
 *     | package-access
 *     | cmt-action
 *     | comment
 *
 *   package-creation :
 *       "%%package" <package-name> requirements-file
 *
 *          This creates a package from the current location, at version v1
 *         structuration style is considered.
 *          Requirements file follows the statement.
 *
 *   requirements-file :
 *       file-contents
 *
 *   file-description :
 *       "%%file" <file-path> file-contents
 *
 *           Create a files relatively to the last created package.
 *
 *   package-access :
 *       "%%cdpackage" <package-name>
 *
 *           Move to the cmt directory of the specified package
 *
 *   cmt-action :
 *       "%%cmt" <arguments>
 *
 *           Perform the specified cmt action.
 *
 *   file-contents :
 *       line ...
 *
 *   comment :
 *       %%% ...
 *
 */
class SequenceRunner : public FAwk
{
public:

  SequenceRunner ();
  void begin ();
  void filter (const cmt_string& line);
  void end ();

private:
  bool started;
  bool running;
  cmt_string style;
  cmt_string vdir;
  cmt_string package;
  cmt_string version;
  cmt_string filename;
  cmt_string buffer;
  cmt_string pwd;
};


#endif

