#-----------------------------------------------------------
# Copyright Christian Arnault LAL-Orsay CNRS
# arnault@lal.in2p3.fr
# Modified by Grigory Rybkin
# See the complete license in cmt_license.txt "http://www.cecill.info". 
#-----------------------------------------------------------

setenv CMTBIN `uname`-`uname -m | tr -d ' '`

if ( $?CMTCONFIG == 0 ) then
  setenv CMTCONFIG `${CMTROOT}/mgr/cmt_system.sh`
endif

if ( $?0 == 0 ) then
if ( $?tcsh == 1 ) then
  source ${CMTROOT}/src/setup.tcsh
else if ( `basename "$shell"` == "tcsh" ) then
  source ${CMTROOT}/src/setup.tcsh
endif
endif

set newpath=()
foreach p (${path})
  if ( "${p}" !~ "*/CMT/*" ) then
    if ( ${#newpath} != 0 ) then
      set newpath=(${newpath} ${p})
    else
      set newpath=(${p})
    endif
  endif
end

set path=(${newpath} "${CMTROOT}/${CMTBIN}")
alias cmt '${CMTROOT}/${CMTBIN}/cmt.exe'
unset newpath

if ( $?CLASSPATH == 0 ) then
  setenv CLASSPATH ${CMTROOT}/java/cmt.jar
else if ( "${CLASSPATH}" == "" ) then
  setenv CLASSPATH ${CMTROOT}/java/cmt.jar
else if ( "${CLASSPATH}" !~ "*/CMT/*" ) then
  setenv CLASSPATH ${CLASSPATH}:${CMTROOT}/java/cmt.jar
else
  set newpath=
  foreach p ( `echo ${CLASSPATH} | tr ':' ' '` )
    if ( "${p}" !~ "*/CMT/*" ) then
      if ( "${newpath}" != "" ) then
        set newpath=${newpath}:${p}
      else
        set newpath=${p}
      endif
    endif
  end

  if ( "${newpath}" != "" ) then
    setenv CLASSPATH ${newpath}:${CMTROOT}/java/cmt.jar
  else
    setenv CLASSPATH ${CMTROOT}/java/cmt.jar
  endif
  unset newpath
endif

alias jcmt '(java cmt_parser)'

# Set MAKEFLAGS, if unset (similar to NPROC with Plan 9 mk utility)
if ( $?MAKEFLAGS == 0 ) then
  setenv MAKEFLAGS -j`getconf _NPROCESSORS_ONLN` || unsetenv MAKEFLAGS
  if ( $?MAKEFLAGS == 1 ) then
    setenv MAKEFLAGS "${MAKEFLAGS} QUICK=1"
  else
    setenv MAKEFLAGS "QUICK=1"
  endif
endif
