
# Determine the Linux distribution and version that is being run.
#

export LC_ALL=C
# Check for GNU/Linux distributions
if [ -f /etc/SuSE-release ]; then
    DISTRIBUTION="suse"
    VERSION=`sed  -n '/VERSION/{s#[^0-9]##gp;q}' /etc/SuSE-release`
elif [ -f /etc/UnitedLinux-release ]; then
    DISTRIBUTION="united"
    VERSION=`cat /etc/UnitedLinux-release`
elif [ -f /etc/debian_version ]; then
    DISTRIBUTION="debian"
    VERSION=`cat /etc/debian_version`
    if [ ${VERSION} = "testing/unstable" ]; then
        # The debian testing/unstable version must be translated into
        # a numeric version number, but no number makes sense so just
        # remove the version all together.
        VERSION=""
    fi
elif [ -f /etc/redhat-release ]; then
    read a </etc/redhat-release
    case "$a" in
	Red*Hat*Enterprise*Linux*)
	    DISTRIBUTION=rhel
	    ;;
	Red*Hat*Linux*)
	    DISTRIBUTION=rh
	    ;;
	CERN*E*Linux*)
	    DISTRIBUTION=cel
	    ;;
 	Scientific*Linux*CERN*)
	    DISTRIBUTION=slc
	    ;;
	Scientific*Linux*)
	    DISTRIBUTION=sl
	    ;;
	Fedora*)
	    DISTRIBUTION=fedora
	    ;;
	*)
	    DISTRIBUTION=slc
	    ;;
    esac
    VERSION=""
    release=
    for w in `echo $a`; do
	case "$w" in
	    release)
		release=y
		;;
	    *)
		if [ "$release" ]; then
		    VERSION=$w
		    release=
		fi
		;;
	esac
    done
#     while [ -n "$a" ]; do
# 	t="${a#?}"		# all but first char of $a
# 	c=${a%"${t}"}		# first char of $a
# 	a="${t}"		# remove first char from $a
# 	case "$c" in
# 	    [0-9])
# 	    VERSION="${VERSION}${c}"
# 	    ;;
# 	esac
#     done
    case "$VERSION" in
	70|71|72)
	    VERSION=73
	    ;;
    esac
    [ "$VERSION" ] || VERSION='00'
else
    DISTRIBUTION="unknown"
    VERSION='00'
fi

echo ${DISTRIBUTION}-${VERSION}
