#-----------------------------------------------------------
# Copyright Christian Arnault LAL-Orsay CNRS
# arnault@lal.in2p3.fr
# Modified by Grigory Rybkin
# See the complete license in cmt_license.txt "http://www.cecill.info". 
#-----------------------------------------------------------

CMTBIN=`uname`-`uname -m | tr -d ' '`; export CMTBIN

if test "${CMTCONFIG}" = "" ; then
  CMTCONFIG=`${CMTROOT}/mgr/cmt_system.sh`; export CMTCONFIG
fi

if [ -n "$-" ] && [ "${-#*i}" != "$-" ]; then
if [ -n "${ZSH_NAME-}" ]; then
  . ${CMTROOT}/src/setup.zsh
elif [ -n "${BASH-}" ]; then
  . ${CMTROOT}/src/setup.bash
fi
fi

if [ "${PATH%/CMT/*}" = "${PATH}" ]; then
  PATH=${PATH}:${CMTROOT}/${CMTBIN}; export PATH
else
  newpath=
  for p in `echo ${PATH} | tr ':' ' '`; do
    if [ "${p%/CMT/*}" = "${p}" ]; then
      if [ -n "${newpath}" ]; then
        newpath=${newpath}:${p}
      else
        newpath=${p}
      fi
    fi
  done

  PATH=${newpath}:${CMTROOT}/${CMTBIN}; export PATH
  unset newpath
fi

alias cmt='${CMTROOT}/${CMTBIN}/cmt.exe'; export cmt

if [ -z "${CLASSPATH-}" ]; then
  CLASSPATH=${CMTROOT}/java/cmt.jar; export CLASSPATH
elif [ "${CLASSPATH%/CMT/*}" = "${CLASSPATH}" ]; then
  CLASSPATH=${CLASSPATH}:${CMTROOT}/java/cmt.jar; export CLASSPATH
else
  newpath=
  for p in `echo ${CLASSPATH-} | tr ':' ' '`; do
    if [ "${p%/CMT/*}" = "${p}" ]; then
      if [ -n "${newpath}" ]; then
        newpath=${newpath}:${p}
      else
        newpath=${p}
      fi
    fi
  done

  if [ -n "${newpath}" ]; then
    CLASSPATH=${newpath}:${CMTROOT}/java/cmt.jar; export CLASSPATH
  else
    CLASSPATH=${CMTROOT}/java/cmt.jar; export CLASSPATH
  fi
  unset newpath
fi

alias jcmt='(java cmt_parser)'; export jcmt

# Set MAKEFLAGS, if unset (similar to NPROC with Plan 9 mk utility)
if [ -z ${MAKEFLAGS+CMT} ]; then
  MAKEFLAGS=-j`getconf _NPROCESSORS_ONLN 2>/dev/null` && export MAKEFLAGS || unset MAKEFLAGS
  if [ -n "${MAKEFLAGS:-}" ]; then
    MAKEFLAGS="${MAKEFLAGS} QUICK=1"
  else
    MAKEFLAGS="QUICK=1"
  fi
  export MAKEFLAGS
fi
