//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#include "cmt_database.h"
#include "cmt_vector.h"

Database& Database::instance ()
{
  static Database db;

  return (db);
}

void Database::clear ()
{
  Branch::clear_all ();
  Constituent::clear_all ();
  Fragment::clear_all ();
  Group::clear_all ();
  Language::clear_all ();
  Package::clear_all ();
  Pattern::clear_all ();
  PatternList::clear_all ();
  Use::clear_all ();
  Symbol::clear_all ();
  Tag::clear_all ();
  Project::clear_all ();
  CmtPathPattern::clear_all ();
}

Branch::BranchVector& Database::branches ()
{
  static Database& db = instance ();

  return (db.m_branches);
}

Constituent::ConstituentVector& Database::constituents ()
{
  static Database& db = instance ();

  return (db.m_constituents);
}

Fragment::FragmentVector& Database::fragments ()
{
  static Database& db = instance ();

  return (db.m_fragments);
}

Group::GroupVector& Database::groups ()
{
  static Database& db = instance ();

  return (db.m_groups);
}

Language::LanguageVector& Database::languages ()
{
  static Database& db = instance ();

  return (db.m_languages);
}

Package::PackageVector& Database::packages ()
{
  static Database& db = instance ();

  return (db.m_packages);
}

Package::PackageMap& Database::package_map ()
{
  static Database& db = instance ();

  return (db.m_package_map);
}

Pattern::PatternVector& Database::patterns ()
{
  static Database& db = instance ();

  return (db.m_patterns);
}

PatternList::PatternListMap& Database::pattern_list_map ()
{
  static Database& db = instance ();

  return (db.m_pattern_list_map);
}

PatternList::PatternListVector& Database::pattern_lists ()
{
  static Database& db = instance ();

  return (db.m_pattern_lists);
}

Use::UseVector& Database::all_uses ()
{
  static Database& db = instance ();

  return (db.m_all_uses);
}

Use::UsePtrVector& Database::uses ()
{
  static Database& db = instance ();

  return (db.m_uses);
}

Symbol::SymbolVector& Database::symbols ()
{
  static Database& db = instance ();

  return (db.m_symbols);
}

Symbol::SymbolMap& Database::symbol_map ()
{
  static Database& db = instance ();

  return (db.m_symbol_map);
}

Tag::TagVector& Database::all_tags ()
{
  static Database& db = instance ();

  return (db.m_all_tags);
}

Tag::TagPtrVector& Database::tags ()
{
  static Database& db = instance ();

  return (db.m_tags);
}

Tag::TagMap& Database::tag_map ()
{
  static Database& db = instance ();

  return (db.m_tag_map);
}

Project::ProjectVector& Database::projects ()
{
  static Database& db = instance ();

  return (db.m_projects);
}

Project::ProjectPtrVector& Database::ordered_projects ()
{
  static Database& db = instance ();

  return (db.m_ordered_projects);
}

CmtPathPattern::CmtPathPatternVector& Database::cmtpath_patterns ()
{
  static Database& db = instance ();

  return (db.m_cmtpath_patterns);
}

Database::Database ()
{
}

