//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// Modified by garonne@lal.in2p3.fr
// Modified by Grigory Rybkin
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#ifndef __cmt_std_h__
#define __cmt_std_h__

#ifndef WIN32
#ifndef __linux__
#ifndef __CYGWIN__
#ifndef __APPLE__
#define OLD_HEADERS 1
#endif
#endif
#endif
#endif

#ifdef OLD_HEADERS

#ifdef WIN32
#include <ios.h>
#include <iomanip.h>
#endif
#include <iostream.h>
#include <fstream.h>
#include <sstream.h>

#define ios_base ios

#define int_type int

#else

#include <iomanip>
#include <iostream>
#include <fstream>
#include <sstream>

#define cout std::cout
#define cerr std::cerr
#define endl std::endl
#define ofstream std::ofstream
#define ifstream std::ifstream
#define ostringstream std::ostringstream
#define istream std::istream
#define ostream std::ostream
#define ios std::ios
#define ios_base std::ios_base
#define streambuf std::streambuf
#define setw std::setw

#endif

#ifdef sun
#ifndef _BOOL
#undef NEED_BOOL
#define NEED_BOOL
#endif
#endif

#ifdef NEED_BOOL
typedef enum { false, true } bool;
#endif

#endif
