#-----------------------------------------------------------
# Copyright Christian Arnault LAL-Orsay CNRS
# arnault@lal.in2p3.fr
# Modified by Grigory Rybkin
# See the complete license in cmt_license.txt "http://www.cecill.info". 
#-----------------------------------------------------------

# Remove spaces, if any
_m="`uname -m`"
_nm=
while [ -n "$_m" ]; do
  _t="${_m#?}"
  _a="${_m%${_t}}"
  if [ "${_a}" != " " ]; then
    _nm="${_nm}${_a}"
  fi
  _m="$_t"
done
CMTBIN=`uname`-"$_nm"; export CMTBIN
unset _m _nm _t _a

if test "${CMTCONFIG}" = "" ; then
  CMTCONFIG=`${CMTROOT}/mgr/cmt_system.sh`; export CMTCONFIG
fi

if [ -n "$-" ] && [ "${-#*i}" != "$-" ]; then
if [ -n "${ZSH_NAME-}" ]; then
  . ${CMTROOT}/src/setup.zsh
elif [ -n "${BASH-}" ]; then
  . ${CMTROOT}/src/setup.bash
fi
fi

cmt_clean_path()
{
# Remove CMT entries, if any
  _np=
  _p="$1"
  while [ -n "$_p" ]; do
    __p="${_p#:}"
    while [ "$__p" != "$_p" ]; do
      _p="${__p}"
      __p="${_p#:}"
    done
    _e="${_p%%:*}"
    _p="${_p#${_e}}"
    if [ "${_e%/CMT/*}" = "${_e}" ] && [ -n "${_e}" ]; then
      if [ -n "${_np}" ]; then
        _np="${_np}:${_e}"
      else
        _np="${_e}"
      fi
    fi
  done
  echo "$_np"
  unset _np _p __p _e
}

if [ "${PATH%/CMT/*}" = "${PATH}" ]; then
  PATH=${PATH}:${CMTROOT}/${CMTBIN}; export PATH
else
  newpath=`cmt_clean_path "${PATH}"`
  PATH=${newpath}:${CMTROOT}/${CMTBIN}; export PATH
  unset newpath
fi

alias cmt='${CMTROOT}/${CMTBIN}/cmt.exe'

if [ -z "${CLASSPATH-}" ]; then
  CLASSPATH=${CMTROOT}/java/cmt.jar; export CLASSPATH
elif [ "${CLASSPATH%/CMT/*}" = "${CLASSPATH}" ]; then
  CLASSPATH=${CLASSPATH}:${CMTROOT}/java/cmt.jar; export CLASSPATH
else
  newpath=`cmt_clean_path "${CLASSPATH}"`
  if [ -n "${newpath}" ]; then
    CLASSPATH=${newpath}:${CMTROOT}/java/cmt.jar; export CLASSPATH
  else
    CLASSPATH=${CMTROOT}/java/cmt.jar; export CLASSPATH
  fi
  unset newpath
fi

alias jcmt='(java cmt_parser)'

unset -f cmt_clean_path

# Set MAKEFLAGS, if unset (similar to NPROC with Plan 9 mk utility)
if [ -z ${MAKEFLAGS+CMT} ]; then
  MAKEFLAGS=-j`getconf _NPROCESSORS_ONLN 2>/dev/null` && export MAKEFLAGS || unset MAKEFLAGS
  if [ -n "${MAKEFLAGS:-}" ]; then
    MAKEFLAGS="${MAKEFLAGS} QUICK=1"
  else
    MAKEFLAGS="QUICK=1"
  fi
  export MAKEFLAGS
fi
