#-----------------------------------------------------------
# Copyright Christian Arnault LAL-Orsay CNRS
# arnault@lal.in2p3.fr
# Modified by garonne@lal.in2p3.fr
# Modified by Grigory Rybkin
# See the complete license in cmt_license.txt "http://www.cecill.info". 
#-----------------------------------------------------------

[ -z "${ARGC-}" ] && return

function cmt_macros { reply=(`cmt -quiet show macro_names`)}; \
   function cmt_actions { reply=(`cmt -quiet show action_names`)}; \
   function cmt_aliases { reply=(`cmt -quiet show alias_names`)}; \
   function cmt_sets { reply=(`cmt -quiet show set_names`)}; \
   function cmt_constituents { reply=(`cmt -quiet show constituent_names`) }; \
   function cmt_fragments { reply=(`cmt -quiet show fragments | sed 's#.*/fragments/##'`)}; \
   function cmt_default_path { d=`dirname ${CMTROOT}`; reply=(`dirname ${d}`) }; \
   function cmt_patterns { reply=(`cmt -quiet show pattern_names`) }; \
   function cmt_make { reply=(`cmt -quiet show constituent_names` `cmt -quiet show groups` check all binclean help) }; \
   compctl -x 'p[1]' -k "(broadcast,build,check,check_files,checkout,co,cleanup,config,create,create_project,expand,filter,help,lock,relocate,remove,run,setup,show,system,unlock,version ${CVSROOT:+,cvstags,cvsbranches,cvssubpackages,cvssubprojects})" - \
   'c[-1,make]' -K cmt_make - \
   'w[1,broadcast] S[-]' -k '(-begin=,-select=,-exclude=,-local,-global,-depth=)' - \
   'w[1,broadcast],w[1,run]' -c - \
   's[build],c[-1,build]' -k '(CMT_pacman, constituent_makefile,constituents_makefile,dependencies,library_links,make_setup,msdev,os9_makefile,prototype,readme,tag_makefile,temporary_name,triggers,win_makefile)' - \
   'w[1,build] c[-1,constituent_makefile]' -K cmt_constituents - \
   'w[1,build] c[-1,triggers]' -K cmt_constituents - \
   'c[-1,check]' -k '(configuration,files,version)' - \
   'C[-1,*files],C[-2,*files]' -f - \
   'w[1,create] p[2]' -X '> give package name' - \
   'w[1,create] p[3]' -X '> give version tag' - \
   'w[1,create] p[4]' -X '> give a path if not created from current path' - \
   'c[-1,expand]' -k '(model)' - \
   'w[1,remove] p[2]' -X '> library_links or give package name' - \
   'w[1,remove] p[3]' -X '> give version tag' - \
   'w[1,remove] p[4]' -X '> give a path if not located from the current path ' - \
   's[show],c[-1,show]' -k '(action,action_names,action_value,actions,alias,alias_names,alias_value,aliases,all_tags,applied_patterns,author,branches,clients,cmtpath_patterns,constituent,constituent_names,constituents,container,cycles,fragment,fragments,groups,include_dirs,language,languages,macro,macro_names,macro_value,macros,manager,packages,path,pattern,patterns,projects,project_author,pwd,set,set_names,set_value,sets,strategies,tags,use_paths,uses,versions)' - \
   'w[1,show] c[-1,constituent]' -K cmt_constituents - \
   'w[1,show] c[-1,fragment]' -K cmt_fragments - \
   'w[1,show] c[-1,action]' -K cmt_actions - \
   'w[1,show] c[-1,action_value]' -K cmt_actions - \
   'w[1,show] c[-1,alias]' -K cmt_aliases - \
   'w[1,show] c[-1,alias_value]' -K cmt_aliases - \
   'w[1,show] c[-1,macro]' -K cmt_macros - \
   'w[1,show] c[-1,macro_value]' -K cmt_macros - \
   'w[1,show] c[-1,pattern]' -K cmt_patterns - \
   'w[1,show] c[-1,set]' -K cmt_sets - \
   'w[1,show] c[-1,set_value]' -K cmt_sets - \
   'w[1,co] s[-],w[1,checkout] s[-]' -k '(l R r C i vd d o requirements no_config rs -help)' - \
   'c[-1,-r]' -X 'give a CVS tag' - \
   'C[-1,(-vd|-d)]' -/ -X 'give a directory name' - \
   'c[-1,-o]' -X 'give an offset in the CVS repository' - \
   'c[-1,-requirements]' -f - \
   'c[-1,co],c[-1,checkout]' -X 'give package name' - \
   --  + cmt.exe
