//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// Modified by garonne@lal.in2p3.fr
// Modified by Grigory Rybkin
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#ifndef __cmt_parser_h__
#define __cmt_parser_h__

/*
  Generation of shell scripts :
  We consider for the moment only csh and sh
  */
typedef enum
{
  Csh,
  Sh,
  Bat,
  Make,
  Requirements,
  Xml
} PrintMode;

typedef enum
{
  mgr_style,
  cmt_style,
  //  no_version_style,
  none_style
} CmtDirStyle;

typedef enum
{
  default_structuring_style,
  with_version_directory,
  without_version_directory
} CmtStructuringStyle;

typedef enum
{
  default_filtering_mode,
  block_private_uses,
  reach_private_uses
} CmtScopeFilteringMode;

/*
  Commands correspond to keywords in the requirements file.
  */
typedef enum
{
  CommandNone,
  CommandAction,
  CommandAlias,
  CommandApplication,
  CommandApplyPattern,
  CommandApplyTag,
  CommandAuthor,
  CommandBranches,
  CommandBuildStrategy,
  CommandCleanupScript,
  CommandCmtPathPattern,
  CommandDocument,
  CommandEndPrivate,
  CommandEndPublic,
  CommandIgnorePattern,
  CommandIncludeDirs,
  CommandIncludePath,
  CommandLanguage,
  CommandLibrary,
  CommandMacro,
  CommandMacroPrepend,
  CommandMacroAppend,
  CommandMacroRemove,
  CommandMacroRemoveRegexp,
  CommandMacroRemoveAll,
  CommandMacroRemoveAllRegexp,
  CommandMakeFragment,
  CommandManager,
  CommandPackage,
  CommandPath,
  CommandPathAppend,
  CommandPathPrepend,
  CommandPathRemove,
  CommandPathRemoveRegexp,
  CommandPattern,
  CommandPrivate,
  CommandProject,
  CommandProjectAuthor,
  CommandPublic,
  CommandSet,
  CommandSetAppend,
  CommandSetPrepend,
  CommandSetRemove,
  CommandSetRemoveRegexp,
  CommandSetupScript,
  CommandSetupStrategy,
  CommandStructureStrategy,
  CommandTag,
  CommandTagExclude,
  CommandUse,
  CommandVersion,
  CommandVersionStrategy,
  Commands
} CommandType;

/*
  The scope is modified while the requirements file is read
  when the keywords public or private are met.
  It is also set to public when a used requirements file is read.
  */

typedef enum
{
  DeveloperMode,
  UserMode
} AccessMode;

typedef enum
{
  ScopeUnspecified,
  ScopePublic,
  ScopePrivate
} ScopeType;

typedef enum
{
  Unspecified = -1,
  Off = 0,
  On = 1
} State;

typedef enum
{
  PriorityLowest   = 0,
  PriorityDefault  = 1,
  PriorityVersion  = 2,
  PriorityUname    = 3,
  PrioritySite     = 4,
  PriorityUserTag  = 5,
  PriorityTag      = 6,
  PriorityConfig   = 7,
  PriorityArgument = 8
} Priority;

typedef enum
{
  SetupScript,
  CleanupScript
} ScriptType;

//
// Build strategy is a mix of various options
//  + predefined values should be multiples of 2^n
//  + effective value is an OR of these options
//  + all options should be specified inthis enum as pairs
//    of <option> - no<option>. One of them being preset to zero
//    (which represents the default) the other being set to a unique 2^n value.
//
typedef enum
{
  Prototypes     = 0x1,
  NoPrototypes   = Prototypes << 1,
  DefaultPrototypesStrategy = Prototypes, 
  PrototypesMask = Prototypes | NoPrototypes,

  WithInstallArea    = NoPrototypes << 1,
  WithoutInstallArea = WithInstallArea << 1,
  DefaultInstallAreaStrategy = WithoutInstallArea, 
  InstallAreaMask    = WithInstallArea | WithoutInstallArea,

  BuildStrategyMask  = PrototypesMask | InstallAreaMask,

  DefaultBuildStrategy = DefaultPrototypesStrategy | DefaultInstallAreaStrategy
} BuildStrategy;

typedef enum
{
  SetupConfig = 0x1,
  SetupNoConfig = SetupConfig << 1,
  SetupConfigMask = SetupConfig | SetupNoConfig,

  SetupRoot = SetupNoConfig << 1,
  SetupNoRoot = SetupRoot << 1,
  SetupRootMask = SetupRoot | SetupNoRoot,

  SetupCleanup = SetupNoRoot << 1,
  SetupNoCleanup = SetupCleanup << 1,
  SetupCleanupMask = SetupCleanup | SetupNoCleanup,

  SetupStrategyMask = SetupConfigMask | SetupRootMask | SetupCleanupMask,

  DefaultSetupStrategy = SetupConfig | SetupRoot | SetupCleanup
} SetupStrategy;

typedef enum
{
  WithVersionDirectory = 0x1,
  WithoutVersionDirectory   = WithVersionDirectory << 1,
  DefaultVersionDirectoryStrategy = WithVersionDirectory, 
  VersionDirectoryMask = WithVersionDirectory | WithoutVersionDirectory,

  StructureStrategyMask  = VersionDirectoryMask,

  DefaultStructureStrategy = DefaultVersionDirectoryStrategy
} StructureStrategy;

typedef enum
{
  Application,
  Library,
  Document
} ConstituentType;

/*
  Command line action
  */
typedef enum
{
  action_none,
  action_awk,
  action_broadcast,

  action_build,

  action_build_constituent_makefile,
  action_build_constituent_config,
  action_build_constituents_makefile,
  action_build_constituents_config,
  action_build_broadcast_config,
  action_build_dependencies,
  action_build_library_links,
  action_build_make_setup,
  action_build_msdev,
  action_build_CMT_pacman,
  // Visual Studio.net Support                  
  action_build_vsnet,                           
  action_build_os9_makefile,
  action_build_prototype,
  action_build_readme,
  action_build_tag_makefile,
  action_build_temporary_name,
  action_build_triggers,
  action_build_windefs,

  action_check,

  action_check_configuration,
  action_check_files,
  action_check_version,
  action_checkout,
  action_cleanup,
  action_config,
  action_create,
  action_create_project,
  action_cvsbranches,
  action_cvssubpackages,
  action_cvssubprojects,
  action_cvstags,
  action_do,
  action_expand_model,
  action_filter,
  action_help,
  action_load,
  action_lock,
  action_relocate,
  action_remove,
  action_remove_library_links,
  action_run,
  action_run_sequence,

  action_set_version,
  action_set_versions,

  action_setup,

  action_show,

  action_show_action,
  action_show_action_value,
  action_show_action_names,
  action_show_actions,
  action_show_alias,
  action_show_alias_value,
  action_show_alias_names,
  action_show_aliases,
  action_show_all_tags,
  action_show_applied_patterns,
  action_show_author,
  action_show_branches,
  action_show_clients,
  action_show_cmtpath_patterns,
  action_show_constituent,
  action_show_constituent_names,
  action_show_constituents,
  action_show_container,
  action_show_cycles,
  action_show_fragment,
  action_show_fragments,
  action_show_groups,
  action_show_include_dirs,
  action_show_language,
  action_show_languages,
  action_show_macro,
  action_show_macro_value,
  action_show_macro_names,
  action_show_macros,
  action_show_manager,
  action_show_packages,
  action_show_path,
  action_show_pattern,
  action_show_pattern_names,
  action_show_patterns,
  action_show_projects,
  action_show_project_author,
  action_show_setup,
  action_show_pwd,
  action_show_set,
  action_show_set_names,
  action_show_set_value,
  action_show_sets,
  action_show_strategies,
  action_show_tags,
  action_show_use_paths,
  action_show_uses,
  action_show_version,
  action_show_versions,

  action_system,
  action_unlock,
  action_version
} ActionType;

#define SLASH '/'

class Use;
typedef Use* UseRef;

#include "cmt_std.h"
#include "cmt_string.h"
#include "cmt_vector.h"
#include "cmt.h"

#endif
