//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#ifndef __cmt_script_h__
#define __cmt_script_h__

#include "cmt_parser.h"
#include "cmt_system.h"

class Script
{
public:
  typedef cmt_vector<Script> ScriptVector;

  static void action (const CmtSystem::cmt_string_vector& words,
                      ScriptType type,
                      Use* use);
  static Script* find (const cmt_string& name, Use* use);
  static Script* add (const cmt_string& name, ScriptType type, Use* use);
  static void all_print_clean (PrintMode mode);
  static void all_print (PrintMode mode);
  static void clear_all ();

public:
  Script ();
  ~Script ();
  int print (PrintMode mode, const Use* use);

  cmt_string name;
  ScriptType type;
};

#endif
