#-----------------------------------------------------------
# Copyright Christian Arnault LAL-Orsay CNRS
# arnault@lal.in2p3.fr
# Modified by Grigory Rybkin
# See the complete license in cmt_license.txt "http://www.cecill.info". 
#-----------------------------------------------------------

unsetenv CMTBIN
unsetenv CMTCONFIG

if ( $?CMTROOT == 1 ) then
if ( $?0 == 0 ) then
if ( $?tcsh == 1 ) then
  source ${CMTROOT}/src/cleanup.tcsh
else if ( "${shell:t}" == "tcsh" ) then
  source ${CMTROOT}/src/cleanup.tcsh
endif
endif
endif

unsetenv CMTROOT

# Remove CMT entries, if any
set newpath=()
foreach p (${path:q})
  if ( "${p}" !~ "*/CMT/*" ) then
    if ( ${#newpath} != 0 ) then
      set newpath=(${newpath:q} ${p:q})
    else
      set newpath=(${p:q})
    endif
  endif
end

set path=(${newpath:q})
unset newpath

unalias cmt

if ( $?CLASSPATH == 1 ) then
if ( "${CLASSPATH}" =~ "*/CMT/*" ) then
# Remove CMT entries
  set _p="${CLASSPATH}"
  while ( "$_p" =~ "*:*" )
  set _p="${_p:s/:/ /}"
  end

  set newpath=
  foreach p (${_p})
    if ( "${p}" !~ "*/CMT/*" ) then
      if ( "${newpath}" != "" ) then
        set newpath=${newpath}:${p}
      else
        set newpath=${p}
      endif
    endif
  end

  if ( "${newpath}" != "" ) then
    setenv CLASSPATH ${newpath}
  else
    unsetenv CLASSPATH
  endif
  unset _p newpath
endif
endif

unalias jcmt

# Unset MAKEFLAGS, if looks set by CMT
if ( $?MAKEFLAGS == 1 ) then
if ( "$MAKEFLAGS" =~ "*QUICK=1" ) then
  unsetenv MAKEFLAGS
endif
endif
