#-----------------------------------------------------------
# Copyright Christian Arnault LAL-Orsay CNRS
# arnault@lal.in2p3.fr
# Modified by Grigory Rybkin
# See the complete license in cmt_license.txt "http://www.cecill.info". 
#-----------------------------------------------------------

[ -z ${CMTBIN+CMT} ] || unset CMTBIN
[ -z ${CMTCONFIG+CMT} ] || unset CMTCONFIG

if [ "${CMTROOT+CMT}" = CMT ]; then
if [ -n "$-" ] && [ "${-#*i}" != "$-" ]; then
if [ -n "${ZSH_NAME-}" ]; then
  . ${CMTROOT}/src/cleanup.zsh
elif [ -n "${BASH-}" ]; then
  . ${CMTROOT}/src/cleanup.bash
fi
fi
fi

[ -z ${CMTROOT+CMT} ] || unset CMTROOT

cmt_clean_path()
{
# Remove CMT entries, if any
  _np=
  _p="$1"
  while [ -n "$_p" ]; do
    __p="${_p#:}"
    while [ "$__p" != "$_p" ]; do
      _p="${__p}"
      __p="${_p#:}"
    done
    _e="${_p%%:*}"
    _p="${_p#${_e}}"
    if [ "${_e%/CMT/*}" = "${_e}" ] && [ -n "${_e}" ]; then
      if [ -n "${_np}" ]; then
        _np="${_np}:${_e}"
      else
        _np="${_e}"
      fi
    fi
  done
  echo "$_np"
  unset _np _p __p _e
}

if [ "${PATH%/CMT/*}" != "${PATH}" ]; then
  newpath=`cmt_clean_path "${PATH}"`
  PATH=${newpath}
  unset newpath
fi

if alias cmt >/dev/null 2>&1; then
  unalias cmt
fi

if [ -n "${CLASSPATH-}" ]; then
if [ "${CLASSPATH%/CMT/*}" != "${CLASSPATH}" ]; then
  newpath=`cmt_clean_path "${CLASSPATH}"`
  if [ -n "${newpath}" ]; then
    CLASSPATH=${newpath}
  else
    unset CLASSPATH
  fi
  unset newpath
fi
fi

if alias jcmt >/dev/null 2>&1; then
  unalias jcmt
fi

unset -f cmt_clean_path

# Unset MAKEFLAGS, if looks set by CMT
if [ "${MAKEFLAGS+CMT}" = CMT ]; then
if [ "${MAKEFLAGS%QUICK=1}" != "${MAKEFLAGS}" ]; then
  unset MAKEFLAGS
fi
fi
