
;;-----------------------------------------------------------
;; Copyright Christian Arnault LAL-Orsay CNRS
;; arnault@lal.in2p3.fr
;; See the complete license in cmt_license.txt "http://www.cecill.info". 
;;-----------------------------------------------------------

;;----------------------------------
;; Local organization
;;
(defvar my-xemacs-dir
  (expand-file-name "~/.xemacs")
"The directory where all the XEmacs configuration (and more) goes."
  )

(setq load-path
      (append
       (list my-xemacs-dir)
       load-path
       ))


;;----------------------------------
;; Local key binding
;;
;; The local prefix for globally available commands: C-b
;; (just like C-x and C-c for xemacs' defaults)
(global-unset-key '[(control b)])

(defun my-coding-keys (map)
  "Sets the key bindings which shall be available in all programming
languages. Argument MAP is the local keymap (e.g. cmt-mode-map)."
  (define-key map '[(control b) (\;)]         'my-comment-region-or-line)
  (define-key map '[(control b) (\:)]         'my-uncomment-region-or-line)
  )

;;----------------------------------
;; Comment in and out
;;
(defun my-comment-region-or-line ()
  (interactive)
  (let ((beg 0)
	(end 0))
    (if (region-exists-p)
	(setq beg (region-beginning)
	      end (region-end))
      (save-excursion
	(beginning-of-line)
	(setq beg (point))
	(forward-line)
	(setq end (point))))
    (comment-region beg end)))

(defun my-uncomment-region-or-line ()
  (interactive)
  (let ((beg 0)
	(end 0))
    (if (region-exists-p)
	(setq beg (region-beginning)
	      end (region-end))
      (save-excursion
	(beginning-of-line)
	(setq beg (point))
	(forward-line)
	(setq end (point))))
    (comment-region beg end -1)))


;;----------------------------------
;; Load CMT mode
;;
(autoload 'cmt-mode "cmt-mode" "CMT requirements file editing mode." t)

(setq auto-mode-alist
      (append (list (cons "requirements$" 'cmt-mode))
	  auto-mode-alist))

(add-hook 'cmt-mode-hook
          '(lambda ()
	     (turn-on-font-lock)
	     (my-coding-keys cmt-mode-map)
	     ))
