//-----------------------------------------------------------
// Copyright Christian Arnault LAL-Orsay CNRS
// arnault@lal.in2p3.fr
// Modified by Grigory Rybkin
// See the complete license in cmt_license.txt "http://www.cecill.info". 
//-----------------------------------------------------------

#ifndef __cmt_deps_builder_h__
#define __cmt_deps_builder_h__

#include "cmt.h"
#include "cmt_system.h"
#include "cmt_use.h"

class DepsBuilder
{
public:

  class HeaderFilter
  {
  public:

    HeaderFilter ()
      : m_use (0), m_filter (0) { }

    HeaderFilter (const Use* use, cmt_regexp* filter, const cmt_string& stamp)
      : m_use (use), m_filter (filter), m_stamp (stamp) { }

    ~HeaderFilter ()
      { }

    inline const Use* use () const
      { return m_use; }

    inline bool use_stamp (const cmt_string& header, cmt_string& stamp) const
      { return m_filter->match (header) ? stamp = m_stamp, true : false ; }

    void clear ()
      {
        m_use = 0;
        if (m_filter) 
	  {
	    m_filter->clear ();
	    delete m_filter;
	  }
        m_filter = 0;
        m_stamp = cmt_string (); 
      }

  private:

    const Use* m_use;
    cmt_regexp* m_filter;
    cmt_string m_stamp;
  };

  typedef cmt_vector<HeaderFilter> HeaderFilters;

  void clear ();
  void add (const cmt_string& path, const cmt_string& substitution);
  void add_includes (const Use& use);
  void add_header_filter (const Use* use, cmt_regexp* filter, const cmt_string& stamp);
  void add_header_filter (const HeaderFilter& hf);
  CmtSystem::cmt_string_vector& run (const cmt_string& file_name,
				     const cmt_string& constituent_name);

  DepsBuilder ();
  ~DepsBuilder ();

private:

  DepsBuilder (const DepsBuilder&);
  DepsBuilder& operator = (const DepsBuilder&);

  CmtSystem::cmt_string_vector m_include_paths;
  CmtSystem::cmt_string_vector m_substitutions;
  HeaderFilters m_header_filters;
  CmtSystem::cmt_string_vector m_deps;
  CmtSystem::cmt_string_vector m_all_deps;

};

#endif
