//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// $Id: G4MultipleScattering71.cc,v 1.5 2008/07/16 11:27:41 vnivanch Exp $
// GEANT4 tag $Name: geant4-09-02 $
//
// -----------------------------------------------------------------------------
// 16/05/01 value of cparm changed , L.Urban
// 18/05/01 V.Ivanchenko Clean up against Linux ANSI compilation
// 07/08/01 new methods Store/Retrieve PhysicsTable (mma)
// 23-08-01 new angle and z distribution,energy dependence reduced,
//          Store,Retrieve methods commented out temporarily, L.Urban
// 27-08-01 in BuildPhysicsTable:aParticleType.GetParticleName()=="mu+" (mma)
// 28-08-01 GetContinuousStepLimit and AlongStepDoIt moved from .icc file (mma)
// 03-09-01 value of data member factlim changed, L.Urban
// 10-09-01 small change in GetContinuousStepLimit, L.Urban
// 11-09-01 G4MultipleScatteringx put as default G4MultipleScattering
//          store/retrieve physics table reactivated (mma)
// 13-09-01 corr. in ComputeTransportCrossSection, L.Urban
// 14-09-01 protection in GetContinuousStepLimit, L.Urban
// 17-09-01 migration of Materials to pure STL (mma)
// 27-09-01 value of data member factlim changed, L.Urban
// 31-10-01 big fixed in PostStepDoIt,L.Urban
// 17-04-02 NEW angle distribution + boundary algorithm modified, L.Urban
// 22-04-02 boundary algorithm modified -> important improvement in timing (L.Urban)
// 24-04-02 some minor changes in boundary algorithm, L.Urban
// 06-05-02 bug fixed in GetContinuousStepLimit, L.Urban
// 24-05-02 changes in angle distribution and boundary algorithm, L.Urban
// 11-06-02 bug fixed in ComputeTransportCrossSection, L.Urban
// 12-08-02 bug fixed in PostStepDoIt (lateral displacement), L.Urban
// 15-08-02 new angle distribution, L.Urban
// 26-09-02 angle distribution + boundary algorithm modified, L.Urban
// 15-10-02 temporary fix for proton scattering
// 30-10-02 modified angle distribution,mods in boundary algorithm,
//          changes in data members, L.Urban
// 11-12-02 precision problem in ComputeTransportCrossSection
//          for small Tkin/for heavy particles cured from L.Urban
// 20-01-03 Migrade to cut per region (V.Ivanchenko)
// 05-02-03 changes in data members, new sampling for geom.
//          path length, step dependence reduced with new
//          method
// 28-03-03 Move to model design (V.Ivanchenko)
// 08-08-03 STD substitute standard  (V.Ivanchenko)
// 23-04-04 value of data member dtrl changed from 0.15 to 0.05 (L.Urban)
// 17-08-04 name of facxsi changed to factail (L.Urban)
// 08-11-04 Migration to new interface of Store/Retrieve tables (V.Ivantchenko)
// 07-02-05 correction in order to have a working Setsamplez function (L.Urban)
// 15-04-05 optimize internal interface (V.Ivanchenko)
// 03-10-05 Process is freezed with the name 71 (V.Ivanchenko)
// -----------------------------------------------------------------------------
//
//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......
//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

#include "G4MultipleScattering71.hh"
#include "G4LossTableManager.hh"
#include "G4MscModel71.hh"

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

using namespace std;

G4MultipleScattering71::G4MultipleScattering71(const G4String& processName)
  : G4VMultipleScattering(processName),
    totBins(120),
    facrange(0.199),
    dtrl(0.05),
    NuclCorrPar (0.0615),
    FactPar(0.40),
    factail(1.0),
    cf(1.001),
    stepnolastmsc(-1000000),
    nsmallstep(5),
    samplez(true),
    boundary(true),
    isInitialized(false)
{
  lowKineticEnergy = 0.1*keV;
  highKineticEnergy= 100.*TeV;

  tlimit           = 1.e10*mm;
  tlimitmin        = 1.e-7*mm;

  SetBinning(totBins);
  SetMinKinEnergy(lowKineticEnergy);
  SetMaxKinEnergy(highKineticEnergy);
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

G4MultipleScattering71::~G4MultipleScattering71()
{}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

void G4MultipleScattering71::InitialiseProcess(const G4ParticleDefinition* particle)
{
  if(isInitialized) return;

  if (particle->GetParticleType() == "nucleus") {
    boundary = false;
    SetLateralDisplasmentFlag(false);
    SetBuildLambdaTable(false);
    Setsamplez(false) ;
  } else {
    SetLateralDisplasmentFlag(true);
    SetBuildLambdaTable(true);
  }
  G4MscModel71* em = new G4MscModel71(dtrl,NuclCorrPar,FactPar,factail,samplez);
  em->SetLateralDisplasmentFlag(LateralDisplasmentFlag());
  em->SetLowEnergyLimit(lowKineticEnergy);
  em->SetHighEnergyLimit(highKineticEnergy);
  AddEmModel(1, em);
  isInitialized = true;
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

G4double G4MultipleScattering71::TruePathLengthLimit(const G4Track&  track,
                                                            G4double& lambda,
                                                            G4double  currentMinimalStep)
{

  G4double tPathLength = currentMinimalStep;

  // special treatment near boundaries ?
  if (boundary) {

    G4int stepno = track.GetCurrentStepNumber() ;
    // first step
    if (stepno == 1) {
      stepnolastmsc = -1000000 ;
      tlimit = 1.e10;
    } else if (stepno > 1) {

      if (track.GetStep()->GetPreStepPoint()->GetStepStatus() == fGeomBoundary) {

        stepnolastmsc = stepno;
        //  if : diff.treatment for small/not small Z
        if (range > lambda) tlimit = facrange*range;
        else                tlimit = facrange*lambda;

        if(tlimit < tlimitmin) tlimit = tlimitmin;
        if(tPathLength > tlimit) tPathLength = tlimit;

      } else if (stepno > stepnolastmsc && stepno - stepnolastmsc < nsmallstep
              && tPathLength > tlimit) {
        tlimit *= cf;
        tPathLength = tlimit;
      }
    }
  }

  return tPathLength;
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

G4double G4MultipleScattering71::GetContinuousStepLimit(
                                          const G4Track& track,
                                                G4double,
                                                G4double currentMinimalStep,
                                                G4double&)
{
  DefineMaterial(track.GetMaterialCutsCouple());
  const G4MaterialCutsCouple* couple = CurrentMaterialCutsCouple();
  G4double e = track.GetKineticEnergy();
  model = dynamic_cast<G4MscModel71*>(SelectModel(e));
  const G4ParticleDefinition* p = track.GetDefinition();
  G4double lambda0 = GetLambda(p, e);
  range =  G4LossTableManager::Instance()->GetRangeFromRestricteDEDX(p,e,couple);
  if(range < currentMinimalStep) currentMinimalStep = range;
  truePathLength = TruePathLengthLimit(track,lambda0,currentMinimalStep);
  //  G4cout << "StepLimit: tpl= " << truePathLength << " lambda0= "
  //       << lambda0 << " range= " << currentRange
  //       << " currentMinStep= " << currentMinimalStep << G4endl;
  if (truePathLength < currentMinimalStep) valueGPILSelectionMSC = CandidateForSelection;
  geomPathLength = model->GeomPathLength(LambdaTable(),couple,
           p,e,lambda0,range,truePathLength);
  if(geomPathLength > lambda0) geomPathLength = lambda0;
  return geomPathLength;
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

void G4MultipleScattering71::PrintInfo()
{
  if(boundary) {
    G4cout << "      Boundary algorithm is active with facrange= "
           << facrange
           << G4endl;
  }
  G4cout << "        WARNING: This process is obsolete and will be soon removed" 
	 << G4endl;
  
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

