//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4OpenGLXmWindowHandlingCallbacks.cc,v 1.11 2009/05/13 10:28:00 lgarnier Exp $
// GEANT4 tag $Name:  $
//
// 
// Andrew Walkden  16th June 1997
// G4OpenGLXmWindowHandlingCallbacks : Callback functions for
//                                     (Motif) widgets to use.
//                                     in handling (Xm) windows

#ifdef G4VIS_BUILD_OPENGLXM_DRIVER
//#define RESIZE_TEST
#include "G4OpenGLXmViewer.hh"



// L. Garnier 20 May 2009
// Each resize event send 2-3-4 expose events. Sequence on MacOsX 10.5 is : 
// - Expose(s) callback for pixels top/left from resize button
// - Resize callback
// - Expose for main part of content
// - Expose(s) for new part of content
//
// BUT we want to redraw things only ONE time.
// First expose is send with size=="before resize" size and x,y !=0
// and  x+dw!=w || y+dh !=h
void G4OpenGLXmViewer::resize_callback (Widget w, 
				      XtPointer clientData, 
				      XtPointer callData) 
{
#ifdef G4DEBUG_VIS_OGL
  printf("G4OpenGLXmViewer::resize_callback \n");
#endif
  XmDrawingAreaCallbackStruct *data = (XmDrawingAreaCallbackStruct *)callData;

  XEvent                       event;

  // flush others resize events
#ifdef G4DEBUG_VIS_OGL
  while (XCheckWindowEvent(XtDisplay(w), data->window,
                           ResizeRedirectMask, &event)) {
    printf("G4OpenGLXmViewer::resize_callback ------ next RESIZE ! %d\n");
  }
#endif
#ifdef RESIZE_TEST
  G4OpenGLXmViewer* pView = (G4OpenGLXmViewer*) clientData;
  Dimension width, height;

  XtVaGetValues (w, 
		 XmNwidth, &width, 
		 XmNheight, &height, 
		 NULL);
  pView->ResizeWindow(width,height);
#endif
}


void G4OpenGLXmViewer::activate_callback (Widget w, 
				      XtPointer clientData, 
				      XtPointer callData) 
{
#ifdef G4DEBUG_VIS_OGL
  printf("G4OpenGLXmViewer::activate_callback \n");
#endif
}

void G4OpenGLXmViewer::expose_callback (Widget w, 
				      XtPointer clientData, 
				      XtPointer callData) 
{
  /* ensure last expose event in sequence */
#ifdef G4DEBUG_VIS_OGL
  printf("G4OpenGLXmViewer::expose_callback ?\n");
#endif
  XmDrawingAreaCallbackStruct *data = (XmDrawingAreaCallbackStruct *)callData;

  XEvent                       event;

  Dimension width, height;
  G4OpenGLXmViewer* pView = (G4OpenGLXmViewer*) clientData;

  XtVaGetValues (w, 
		 XmNwidth, &width, 
		 XmNheight, &height, 
		 NULL);
  
  XSetWindowAttributes xswa;
  xswa.bit_gravity = ForgetGravity ;
  XChangeWindowAttributes(XtDisplay(w), XtWindow(w),
                          CWBitGravity, &xswa);
  
    // look for next 
    //    while (XCheckTypedWindowEvent(XtDisplay(w), XtWindow(w), ResizeRequest, &event)) {
    //    printf("G4OpenGLXmViewer::expose_callback --- event type :%d\n",event.type);
    //    printf("G4OpenGLXmViewer::expose_callback --- resize %d\n",event.type);
    //  }
    
  // Several expose events are send for each area to be redraw.
  // Because we want to optimise redrawing, we only need to redraw once.
    if (((XExposeEvent *) data->event)->count != 0) {
#ifdef G4DEBUG_VIS_OGL
      printf("G4OpenGLXmViewer::expose_callback NOOOOO %d %d type:%d number:%d send:%d x:%d y:%d w:%d h:%d c:%d\n",width,height,
           ((XExposeEvent *) data->event)->type,
           ((XExposeEvent *) data->event)->serial,
           ((XExposeEvent *) data->event)->send_event,
           ((XExposeEvent *) data->event)->x,
           ((XExposeEvent *) data->event)->y,
           ((XExposeEvent *) data->event)->width,
           ((XExposeEvent *) data->event)->height,
           ((XExposeEvent *) data->event)->count);


#endif
      return;
    }
#ifdef G4DEBUG_VIS_OGL
    printf("G4OpenGLXmViewer::expose_callback Should redraw %d %d type:%d number:%d send:%d x:%d y:%d w:%d h:%d c:%d\n",width,height,
           ((XExposeEvent *) data->event)->type,
           ((XExposeEvent *) data->event)->serial,
           ((XExposeEvent *) data->event)->send_event,
           ((XExposeEvent *) data->event)->x,
           ((XExposeEvent *) data->event)->y,
           ((XExposeEvent *) data->event)->width,
           ((XExposeEvent *) data->event)->height,
           ((XExposeEvent *) data->event)->count);
#endif
    
#ifdef G4DEBUG_VIS_OGL
    while (XCheckMaskEvent(XtDisplay(w), ResizeRedirectMask, &event)) {
      //       printf("G4OpenGLXmViewer::expose_callback ------ next EXPOSE ! %d\n");
      //     }
      //     while (XCheckWindowEvent(XtDisplay(w), data->window,
      //                              ResizeRedirectMask, &event)) {
      printf("G4OpenGLXmViewer::expose_callback ------ next RESIZE ! \n");
    }
#endif
  
#ifdef RESIZE_TEST
    glXMakeCurrent (pView->dpy, XtWindow(pView->glxarea), pView->cx);
#ifdef G4DEBUG_VIS_OGL
  G4cout << "G4OpenGLXmViewer::expose_callback" << G4endl;
  printf("G4OpenGLXmViewer::expose_callback Call SetView()\n");
#endif
  pView->SetView ();
#ifdef G4DEBUG_VIS_OGL
  printf("G4OpenGLXmViewer::expose_callback Call SetView() END \n");
  printf("G4OpenGLXmViewer::expose_callback Call ClearView() \n");
#endif
  pView->ClearView ();
#ifdef G4DEBUG_VIS_OGL
  printf("G4OpenGLXmViewer::expose_callback Call ClearView() END \n");
  printf("G4OpenGLXmViewer::expose_callback Call DrawView() \n");
#endif
  pView->DrawView ();
#ifdef G4DEBUG_VIS_OGL
  printf("G4OpenGLXmViewer::expose_callback Call DrawView() END \n");
  G4cout << "G4OpenGLXmViewer::expose_callback END" << G4endl;
#endif
#endif
  return;
    
 
}

void G4OpenGLXmViewer::print_callback (Widget, 
				    XtPointer clientData, 
				    XtPointer) 
{
  G4OpenGLXViewer* pView = (G4OpenGLXmViewer*) clientData;
  pView->printEPS();
}

void G4OpenGLXmViewer::set_print_colour_callback (Widget w,
						XtPointer clientData,
						XtPointer) 
{
  G4OpenGLXmViewer* pView = (G4OpenGLXmViewer*)clientData;
  
  G4int choice = get_int_userData (w);
  
  pView->fPrintColour=(G4bool)choice;
  G4cout << "Print colour set to " << pView->fPrintColour;
  
}

void G4OpenGLXmViewer::set_print_style_callback (Widget w,
					       XtPointer clientData,
					       XtPointer) 
{
  G4OpenGLXmViewer* pView = (G4OpenGLXmViewer*)clientData;
  
  G4int choice = get_int_userData (w);
  
  pView->fVectoredPs=(G4bool)choice;
  G4cout << "`Produce vectored PostScript ?' set to : " << pView->fPrintColour;
  
}

#endif
