//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4UIWt.cc,v 1.18 2008/10/02 08:50:39 lgarnier Exp $
// GEANT4 tag $Name:  $
//
// L. Garnier

//#define GEANT4_WT_DEBUG

//#define G4UI_BUILD_WT_SESSION

#ifdef G4UI_BUILD_WT_SESSION

#include "G4Types.hh"

#include <string.h>

#include "G4Wt.hh"
#include "G4UImanager.hh"
#include "G4StateManager.hh"
#include "G4UIcommandTree.hh"
#include "G4UIcommandStatus.hh"



// Undef the qt SLOT if already define 
// #ifdef SLOT
// # undef SLOT
// # undef signals
// # undef slots
// #endif


//#include <Wt/WApplication>
//  #include <Wt/WCssStyleSheet>
//    #include <Wt/WCssDecorationStyle>
//      #include <Wt/WWidget>

#include <Wt/WApplication>
#include "Wt/Wwidget"
#include "Wt/wlayout"
#include <Wt/WPushButton>
#include <Wt/WVBoxLayout>
#include <Wt/WHBoxLayout>
#include "Wt/WLabel"
#include "Wt/WBoxLayout"
#include "Wt/Ext/Splitter"
#include "Wt/wscrollbar"
#include "Wt/WComboBox"
#include "Wt/wdialog"
#include "Wt/wevent"
#include "Wt/Ext/Container"
#include "Wt/Ext/Panel"
#include "Wt/Ext/Toolbar"
#include "Wt/Ext/LineEdit"
#include "Wt/WTextEdit"
#include "Wt/WTreeTable"
#include "Wt/WTreeNode"

//#include "Wt/WSignalMapper"

//#include <Wt/wmainwindow.h>
//#if WT_VERSION >= 0x040000
#include <Wt/Ext/Menu>
//#include <Wt/wlistwidget>
#include "Wt/wtree"
// #else
// #include <Wt/waction>
// #include <Wt/wheader>
// #include <Wt/wlistview>
// #include <Wt/wpopupmenu>
// #endif

#include "G4UIWt.hh" // SOULD BE **AFTER** all Wt include because it will redefine SIGNAL/SLOT


// redefine signal/slots Qt mechanisme if necessary
#include <qobject.h>


#include <stdlib.h>

// Pourwuoi Static et non  variables de classe ?
static G4bool exitSession = true;
static G4bool exitPause = true;

/**   Build a Wt window with a menubar, output area and promt area<br> 
<pre>
   +-----------------------+
   |exit menu|             |
   |                       |
   | +-------------------+ |
   | |                   | |
   | |  Output area      | |
   | |                   | |
   | +-------------------+ |
   |      | clear |        |
   | +-------------------+ |
   | |  promt history    | |
   | +-------------------+ |
   | +-------------------+ |
   | |> promt area       | |
   | +-------------------+ |
   +-----------------------+
</pre>
*/
G4UIWt::G4UIWt (
  const Wt::WEnvironment& env
)
  :fHelpDialog(NULL)
{
  G4Wt* interactorManager = G4Wt::getInstance (env);
  G4UImanager* UI = G4UImanager::GetUIpointer();
  if(UI!=NULL) UI->SetSession(this);

  // Check if already define in external app WMainWindow
  bool found = false;
// #if WT_VERSION < 0x040000
//   // theses lines does nothing exept this one "GLWindow = new WDialog(0..."
//   // but if I comment them, it doesn't work...
//   WWidgetList  *list = WApplication::allWidgets();
//   WWidgetListIt it( *list );         // iterate over the widgets
//   WWidget * widget;
//   while ( (widget=it.current()) != 0 ) {  // for each widget...
//     ++it;
//     if ((found== false) && (widget->inherits("WMainWindow"))) {
//       found = true;
//     }
//   }
//   delete list;                      // delete the list, not the widgets
// #else
//   foreach (WWidget *widget, WApplication::allWidgets()) {
//     if ((found== false) && (widget->inherits("WMainWindow"))) {
//       found = true;
//     }
//   }
// #endif

//   if (found) {
//     G4cout        << "G4UIWt : Found an external App with a WMainWindow already defined. Aborted" << G4endl;
//     return ;
//   }
  fMainWindow = new Wt::Ext::Panel(wApp->root());
  Wt::WContainerWidget *inside = new Wt::WContainerWidget();

#ifdef G4DEBUG_INTERFACES_BASIC
  printf("G4UIWt::Initialise after main window creation\n");
#endif
// #if WT_VERSION < 0x040000
//   fMainWindow->setCaption( tr( "G4UI Session" ));
//   fMainWindow->resize(900,600); 
//   fMainWindow->move(50,100);
// #else
  fMainWindow->setTitle("G4UI Session" ); 
  fMainWindow->resize(900,600); 
  //  fMainWindow->move(WPoint(50,100));
// #endif

  Wt::Ext::Splitter *splitter = new Wt::Ext::Splitter(Wt::Vertical,inside);

  // Set layouts

  Wt::WContainerWidget* topWidget = new Wt::WContainerWidget(splitter);
  Wt::WContainerWidget* bottomWidget = new Wt::WContainerWidget(splitter);

  Wt::WBoxLayout *layoutTop = new Wt::WBoxLayout(Wt::WBoxLayout::TopToBottom,topWidget);
  Wt::WBoxLayout *layoutBottom = new Wt::WBoxLayout(Wt::WBoxLayout::TopToBottom,bottomWidget);

  // fill them

  fTextArea = new Wt::WTextEdit(topWidget);
  Wt::WPushButton *clearButton = new Wt::WPushButton(Wt::WString("clear"),topWidget);
  connect(clearButton, SIGNAL(clicked()), SLOT(ClearButtonCallback()));

// #if WT_VERSION < 0x040000

//   fCommandHistoryArea = new WListView(bottomWidget);
//   fCommandHistoryArea->setSorting (-1, FALSE);
//   fCommandHistoryArea->setSelectionMode(WListView::Single);
//   fCommandHistoryArea->addColumn("");
//   fCommandHistoryArea->header()->hide();
//   connect(fCommandHistoryArea, SIGNAL(selectionChanged()), SLOT(CommandHistoryCallback()));
// #else
  fCommandHistoryArea = new Wt::WComboBox();

  //FIXME : could be more simple
  connect(fCommandHistoryArea, SIGNAL(sactivated(Wt::WString)), SLOT(CommandHistoryCallback()));
// #endif
  fCommandLabel = new Wt::WLabel(Wt::WString(""),bottomWidget);

  fCommandArea = new Wt::Ext::LineEdit(bottomWidget);
// #if WT_VERSION < 0x040000
//   fCommandArea->setActiveWindow();
// #else
  fCommandArea->activateWindow();
// #endif
  connect(fCommandArea, SIGNAL(returnPressed()), SLOT(CommandEnteredCallback()));
// #if WT_VERSION < 0x040000
//   fCommandArea->setFocusPolicy ( WWidget::StrongFocus );
//   fCommandArea->setFocus();
// #else
//  fCommandArea->setFocusPolicy ( Wt::StrongFocus );
//  fCommandArea->setFocus(Wt::TabFocusReason);
// #endif
//  fTextArea->setReadOnly(true);


#ifdef G4DEBUG_INTERFACES_BASIC
  printf("G4UIWt::   2\n");
#endif



  layoutTop->addWidget(fTextArea);
  layoutTop->addWidget(clearButton);

// #if WT_VERSION >= 0x040000
  topWidget->setLayout(layoutTop);
// #endif

  layoutBottom->addWidget(fCommandHistoryArea);
  layoutBottom->addWidget(fCommandLabel);
  layoutBottom->addWidget(fCommandArea);
// #if WT_VERSION >= 0x040000

  bottomWidget->setLayout(layoutBottom);
  splitter->addWidget(topWidget);
  splitter->addWidget(bottomWidget);
// #endif


  fMainWindow->layout()->addWidget(inside);

// #if WT_VERSION < 0x040000

//   // Add a wuit subMenu
//   WPopupMenu *fileMenu = new WPopupMenu( fMainWindow);
//   fileMenu->insertItem( "&Wuitter",  this, SLOT(ExitSession()), CTRL+Key_W );
//   fMainWindow->menuBar()->insertItem( WString("&File"), fileMenu );

//   // Add a Help menu
//   WPopupMenu *helpMenu = new WPopupMenu( fMainWindow );
//   helpMenu->insertItem( "&Show Help",  this, SLOT(ShowHelpCallback()), CTRL+Key_H );
//   fMainWindow->menuBar()->insertItem( WString("&Help"), helpMenu );


// #else

// Create a menu with some items

  Wt::Ext::Menu *menuQ = new Wt::Ext::Menu();
  menuQ->addItem("",Wt::WString("Quit"), this, SLOT(ExitSession()));

  Wt::Ext::Menu *menuS = new Wt::Ext::Menu();
  menuS->addItem("",Wt::WString("ShowHelp"),SLOT(ShowHelpCallback()));

 // Create a tool bar

 fToolBar = new Wt::Ext::ToolBar(inside);

  // Associate the menu with a button

  Wt::Ext::Button *Q    = fToolBar->addButton("File", menuQ);
  Wt::Ext::Button *S    = fToolBar->addButton("Quit", menuQ);

  // Set the splitter size. The fTextArea sould be 2/3 on the fMainWindow
// #if WT_VERSION < 0x040000
//   WValueList<int> vals = splitter->sizes();
// #else
//   Wt::WList<int> vals = splitter->sizes();
// // #endif
//   if(vals.size()==2) {
//     vals[0] = (splitter->orientation()==Wt::Vertical ? splitter->height() : splitter->width())*3/4;
//     vals[1] = (splitter->orientation()==Wt::Vertical ? splitter->height() : splitter->width())*1/4;
//     splitter->setSizes(vals);
//   }

  if(UI!=NULL) UI->SetCoutDestination(this);  // TO KEEP
}



G4UIWt::~G4UIWt(
) 
{ 
  G4UImanager* UI = G4UImanager::GetUIpointer();  // TO KEEP
  if(UI!=NULL) {  // TO KEEP
    UI->SetSession(NULL);  // TO KEEP
    UI->SetCoutDestination(NULL);  // TO KEEP
  }
  
  if (fMainWindow!=NULL)
    delete fMainWindow;
}



/**   Start the Wt main loop
*/
G4UIsession* G4UIWt::SessionStart (
)
{

  G4Wt* interactorManager = G4Wt::getInstance ();

// #if WT_VERSION >= 0x040000
// #if WT_VERSION >= 0x040200
  fMainWindow->show();
// #else
//   fMainWindow->show();
// #endif
// #else
//   fMainWindow->show();
// #endif
  Prompt("session");
  exitSession = false;


#ifdef G4DEBUG_INTERFACES_BASIC
  printf("G4UIWt::SessionStart Start session.. ????\n");
#endif
  interactorManager->DisableSecondaryLoop (); // TO KEEP
  //FIXME : QUE FAIRE ICI ??????????????????????????

//   if ((Wt::WApplication*)interactorManager->GetMainInteractor())
//     ((Wt::WApplication*)interactorManager->GetMainInteractor())->exec();

  // on ne passe pas le dessous ? FIXME ????
  // je ne pense pas 13/06

  //   void* event; // TO KEEP
  //   while((event = interactorManager->GetEvent())!=NULL) {  // TO KEEP
  //     interactorManager->DispatchEvent(event); // TO KEEP
  //     if(exitSession==true) break; // TO KEEP
  //   } // TO KEEP

  interactorManager->EnableSecondaryLoop ();
#ifdef G4DEBUG_INTERFACES_BASIC
  printf("enable secondary loop\n");
#endif
  return this;
}


/**   Display the prompt in the prompt area
   @param aPrompt : string to display as the promt label
   //FIXME : probablement inutile puiswue le seul a afficher ww chose d'autre
   wue "session" est SecondaryLoop()
*/
void G4UIWt::Prompt (
 G4String aPrompt
)
{
  if (!aPrompt) return;

  fCommandLabel->setText((char*)aPrompt.data());
}


void G4UIWt::SessionTerminate (
)
{
  G4Wt* interactorManager = G4Wt::getInstance ();
  delete fMainWindow;
  ((Wt::WApplication*)interactorManager->GetMainInteractor())->quit(); 
}



/**
   Called by intercoms/src/G4UImanager.cc<br>
   Called by visualization/management/src/G4VisCommands.cc with "EndOfEvent" argument<br>
   It have to pause the session command terminal.<br>
   Call SecondaryLoop to wait for exit event<br>
   @param aState
   @see : G4VisCommandReviewKeptEvents::SetNewValue
*/
void G4UIWt::PauseSessionStart (
 G4String aState
)
{
  if (!aState) return;

#ifdef G4DEBUG_INTERFACES_BASIC
  printf("G4UIWt::PauseSessionStart\n");
#endif
  if(aState=="G4_pause> ") {  // TO KEEP
    SecondaryLoop ("Pause, type continue to exit this state"); // TO KEEP
  } // TO KEEP

  if(aState=="EndOfEvent") { // TO KEEP
    // Picking with feed back in event data Done here !!!
    SecondaryLoop ("End of event, type continue to exit this state"); // TO KEEP
  } // TO KEEP
}



/**
   Begin the secondary loop
   @param a_prompt : label to display as the prompt label
 */
void G4UIWt::SecondaryLoop (
 G4String aPrompt
)
{
  if (!aPrompt) return;

#ifdef G4DEBUG_INTERFACES_BASIC
  printf("G4UIWt::SecondaryLoop\n");
#endif
  G4Wt* interactorManager = G4Wt::getInstance (); // TO KEEP ?
  Prompt(aPrompt); // TO KEEP
  exitPause = false; // TO KEEP
  void* event; // TO KEEP
  while((event = interactorManager->GetEvent())!=NULL) {  // TO KEEP
    interactorManager->DispatchEvent(event); // TO KEEP
    if(exitPause==true) break; // TO KEEP
  } // TO KEEP
  Prompt("session"); // TO KEEP
}



/**
   Receive a cout from Geant4. We have to display it in the cout zone
   @param aString : label to add in the display area
   @return 0
*/
G4int G4UIWt::ReceiveG4cout (
 G4String aString
)
{
  if (!aString) return 0;
  G4Wt* interactorManager = G4Wt::getInstance ();
  if (!interactorManager) return 0;
  
// #if WT_VERSION < 0x040000
//   fTextArea->append(WString((char*)aString.data()).simplifyWhiteSpace());
//   fTextArea->verticalScrollBar()->setValue(fTextArea->verticalScrollBar()->maxValue());
// #else

// FIXME : SHOULD BE IMPROVE

#ifdef G4DEBUG_INTERFACES_BASIC
  printf("G4UIWt::ReceiveG4cout : append text is not optimized  \n");
#endif
  fTextArea->setText(fTextArea->text()+Wt::WString((char*)aString.data()));
  //  fTextArea->verticalScrollBar()->setSliderPosition(fTextArea->verticalScrollBar()->maximum());
// #endif
//  fTextArea->repaint();
  //  interactorManager->FlushAndWaitExecution();
  return 0;
}


/**
   Receive a cerr from Geant4. We have to display it in the cout zone
   @param aString : label to add in the display area
   @return 0
*/
G4int G4UIWt::ReceiveG4cerr (
 G4String aString
)
{
  if (!aString) return 0;
  G4Wt* interactorManager = G4Wt::getInstance ();
  if (!interactorManager) return 0;

// #if WT_VERSION < 0x040000
//   WColor previousColor = fTextArea->color();
//   fTextArea->setColor(Wt::red);
//   fTextArea->append(WString((char*)aString.data()).simplifyWhiteSpace());
//   fTextArea->setColor(previousColor);
//   fTextArea->verticalScrollBar()->setValue(fTextArea->verticalScrollBar()->maxValue());
// #else
//FIXME no  color change for the moment
#ifdef G4DEBUG_INTERFACES_BASIC
  printf("G4UIWt::ReceiveG4cerr : no  color change for the moment \n");
  printf("G4UIWt::ReceiveG4cerr : append text is not optimized \n");
#endif
//   Wt::WColor previousColor = fTextArea->textColor();
//   fTextArea->setTextColor(Wt::red);
  fTextArea->setText(fTextArea->text()+Wt::WString((char*)aString.data()));
  //  fTextArea->setTextColor(previousColor);
  //  fTextArea->verticalScrollBar()->setSliderPosition(fTextArea->verticalScrollBar()->maximum());
// #endif
//  fTextArea->repaint();
  //  interactorManager->FlushAndWaitExecution();
  return 0;
}



/**
   Add a new menu to the menu bar
   @param aName name of menu
   @param aLabel label to display
 */
void G4UIWt::AddMenu (
 const char* aName
,const char* aLabel
)
{
  if (aName == NULL) return;
  if (aLabel == NULL) return;

// #if WT_VERSION < 0x040000
//   WPopupMenu *fileMenu = new WPopupMenu( fMainWindow);
//   fMainWindow->menuBar()->insertItem( aLabel, fileMenu );
// #else

  Wt::Ext::Button *item = fToolBar->addButton(aLabel); 

// #endif

  AddInteractor (aName,(G4Interactor)item);
}


/**
   Add a new button to a menu
   @param aMenu : parent menu
   @param aLabel : label to display
   @param aCommand : command to execute as a callback
 */
void G4UIWt::AddButton (
 const char* aMenu
,const char* aLabel
,const char* aCommand
)
{
  if(aMenu==NULL) return; // TO KEEP
  if(aLabel==NULL) return; // TO KEEP
  if(aCommand==NULL) return; // TO KEEP

#ifdef G4DEBUG_INTERFACES_BASIC
  printf("G4UIWt::AddButton NOT YET IMPLEMENTED   FIXME\n");
#endif
// #if WT_VERSION < 0x040000
//   WPopupMenu *parent = (WPopupMenu*)GetInteractor(aMenu);
// #else
//   Wt::Ext::ButtonWMenu *parent = (WMenu*)GetInteractor(aMenu);
// // #endif

//   if(parent==NULL) return;
  
//   Wt::WSignalMapper *signalMapper = new Wt::WSignalMapper(this);
// // #if WT_VERSION < 0x030200
// //   WAction *action = new WAction(WString(aLabel),WString(aLabel),WKeySewuence::WKeySewuence (),signalMapper, SLOT(map()));
// //   action->addTo(parent);
// //  connect(action,SIGNAL(activated()),signalMapper,SLOT(map()));

// // #elif WT_VERSION < 0x040000
// //   WAction *action = new WAction(WString(aLabel),WKeySewuence::WKeySequence (),signalMapper, SLOT(map()));
// //   action->addTo(parent);
// //  connect(action,SIGNAL(activated()),signalMapper,SLOT(map()));

// // #else
//   Wt::WAction *action = parent->addAction(aLabel, signalMapper, SLOT(map()));

// // #endif
//   connect(signalMapper, SIGNAL(mapped(const Wt::WString &)),this, SLOT(ButtonCallback(const Wt::WString&)));
//   signalMapper->setMapping(action, Wt::WString(aCommand));
}




/**
   Open the help dialog in a separate window.<br>
   This will be display as a tree widget.<br>
   Implementation of <b>void G4VBasicShell::TerminalHelp(G4String newCommand)</b>

   @param newCommand : open the tree widget item on this command if is set
*/
void G4UIWt::TerminalHelp(
 G4String newCommand
)
{
  // Create the help dialog
  if (!fHelpDialog) {
// #if WT_VERSION < 0x040000
//     fHelpDialog = new WDialog(0,0,FALSE,Wt::WStyle_Title | Wt::WStyle_SysMenu | Wt::WStyle_MinMax );
// #else
    fHelpDialog = new Wt::Ext::Panel();
    fHelpDialog->setCollapsible(true);
    fHelpDialog->setAnimate(true);
    fHelpDialog->setAutoScrollBars(true);

// #endif
    Wt::WVBoxLayout *vLayout = new Wt::WVBoxLayout(fHelpDialog);
    Wt::Ext::Container *helpWidget = new Wt::Ext::Container();
    Wt::Ext::Splitter *splitter = new Wt::Ext::Splitter(Wt::Horizontal);
    Wt::Ext::Button *exitButton = new Wt::Ext::Button(Wt::WString("Exit"));
    //    exitButton->setAutoDefault(false);
    connect(exitButton, SIGNAL(clicked()), fHelpDialog,SLOT(close()));
    
    Wt::WHBoxLayout *helpLayout = new Wt::WHBoxLayout(helpWidget);
// #if WT_VERSION < 0x040000
//     helpLayout->add(new WLabel("Search :",helpWidget));
// #else

    helpLayout->addWidget(new Wt::WLabel("Search :"));
// #endif
    fHelpLine = new Wt::Ext::LineEdit();
// #if WT_VERSION < 0x040000
//     helpLayout->add(fHelpLine);
//     connect( fHelpLine, SIGNAL( returnPressed () ), this, SLOT( lookForHelpStringCallback() ) );
// #else
    helpLayout->addWidget(fHelpLine);
    connect( fHelpLine, SIGNAL( editingFinished () ), this, SLOT( lookForHelpStringCallback() ) );
// #endif

    // the help tree
// #if WT_VERSION < 0x040000
//     fHelpTreeWidget = new WListView(splitter);
// #else
    fHelpTreeWidget = new Wt::WTreeTable();
// #endif
    fHelpTreeWidget = CreateHelpTree();

    fHelpArea = new Wt::WTextEdit(splitter);
    //    fHelpArea->setReadOnly(true);

    // Set layouts

// #if WT_VERSION >= 0x040000
    if (fHelpTreeWidget)
      splitter->addWidget(fHelpTreeWidget);
    splitter->addWidget(fHelpArea);
// #endif


// #if WT_VERSION >= 0x040000
    vLayout->addWidget(helpWidget);
    vLayout->addWidget(splitter,1);
    vLayout->addWidget(exitButton);
// #else
//     vLayout->addWidget(helpWidget);
//     vLayout->addWidget(splitter,1);
//     vLayout->addWidget(exitButton);
// #endif

    // set the splitter size
// #if WT_VERSION >= 0x040000
//    Wt::WList<int> list;
// #else
//     WValueList<int> list;
// #endif
//    list.append( 400 );
//    list.append( 400 );
//    splitter->setSizes(list);

// #if WT_VERSION >= 0x040000
    fHelpDialog->setLayout(vLayout);
// #endif

  }

  ActivateCommand(newCommand);

// #if WT_VERSION < 0x040000
//   fHelpDialog->setCaption( tr( "Help on commands" ));
// #else
  fHelpDialog->setTitle("Help on commands"); 
// #endif
  fHelpDialog->resize(800,600); 
  //  fHelpDialog->move(WPoint(400,150));
  fHelpDialog->show();
  //  fHelpDialog->raise();
// #if WT_VERSION < 0x040000
//   fHelpDialog->setActiveWindow();
// #else
//  fHelpDialog->activateWindow();
// #endif
}


void G4UIWt::ActivateCommand(
 G4String newCommand
)
{
  if (!fHelpTreeWidget) {
    return;
  }
  // Look for the choosen command "newCommand"
  size_t i = newCommand.index(" ");
  G4String targetCom="";
  if( i != std::string::npos )
    {
      G4String newValue = newCommand(i+1,newCommand.length()-(i+1));
      newValue.strip(G4String::both);
      targetCom = ModifyToFullPathCommand( newValue );
    }
  if (targetCom != "") {
// #if WT_VERSION < 0x040000
//     WListViewItem* findItem = NULL;
//     WListViewItem* tmpItem = fHelpTreeWidget->firstChild();
//     while (tmpItem != 0) {
//       if (!findItem) {
//         findItem = FindTreeItem(tmpItem,WString((char*)targetCom.data()));
//       }
//       tmpItem = tmpItem->nextSibling();
//     }
// #else
    Wt::WTreeNode* findItem = NULL;
    for (int a=0;a<fHelpTreeWidget->topLevelItemCount();a++) {
      if (!findItem) {
        findItem = FindTreeItem(fHelpTreeWidget->topLevelItem(a),Wt::WString((char*)targetCom.data()));
      }
    }
// #endif
    
    if (findItem) {      
      
      //collapsed open item
// #if WT_VERSION < 0x040000

//       // FIXME : Has to be checked
//       WListViewItem* tmpItem = fHelpTreeWidget->firstChild();
//       WList<WListViewItem> openItems;
//       while ((tmpItem != 0) || (!openItems.isEmpty())) {
//         if (tmpItem->isOpen() ) {
//           tmpItem->setOpen(false);
//           openItems.append(tmpItem);
//           tmpItem = tmpItem->firstChild();
//         } else {
//           tmpItem = tmpItem->nextSibling();
//         }
//         if (tmpItem == 0) {
//           tmpItem = openItems.take(openItems.count()-1);
//         }
//       }
// #else
      Wt::WList<Wt::WTreeNode *> selected;

      selected = fHelpTreeWidget->selectedItems();
      if ( selected.count() != 0 ) {
        Wt::WTreeNode * tmp =selected.at( 0 );
        while ( tmp) {
// #if WT_VERSION < 0x040202
//    	      fHelpTreeWidget->setItemExpanded(tmp,false); 
// #else
          tmp->setExpanded(false);
// #endif
          tmp = tmp->parent();
        }
      }
// #endif
      
      // clear old selection
      fHelpTreeWidget->clearSelection();

      // set new selection
// #if WT_VERSION >= 0x040000
// #if WT_VERSION < 0x040202
//       fHelpTreeWidget->setItemSelected(findItem,true);
// #else
      findItem->setSelected(true);
// #endif      
// #else
//       findItem->setSelected(true);
// #endif
      
      // expand parent item
      while ( findItem) {
// #if WT_VERSION < 0x040000
//         findItem->setOpen(true);
// #else
// #if WT_VERSION < 0x040202
   	    fHelpTreeWidget->setItemExpanded(findItem,true); 
// #else
//         findItem->setExpanded(true);
// #endif
// #endif
        findItem = findItem->parent();
      }

      // Call the update of the right textArea
      HelpTreeClicCallback();
    }
  }
}



/**
   Create the help tree widget
   @param parent : parent of tree widget
   @return the widget containing the tree or NULL if it could not have beeen created
 */

// #if WT_VERSION < 0x040000
// WListView * G4UIWt::CreateHelpTree()
// #else
Wt::WTreeTable * G4UIWt::CreateHelpTree()
// #endif
{
  G4UImanager* UI = G4UImanager::GetUIpointer();
  if(UI==NULL) return NULL;
  G4UIcommandTree * treeTop = UI->GetTree();


  // build widget
// #if WT_VERSION < 0x040000
//   fHelpTreeWidget->setSelectionMode(WListView::Single);
//   fHelpTreeWidget->setRootIsDecorated(true);
//   fHelpTreeWidget->addColumn("Command");
//   fHelpTreeWidget->header()->setResizeEnabled(FALSE,1);
// #else
  fHelpTreeWidget->setSelectionMode(Wt::WAbstractItemView::SingleSelection);
  Wt::WStringList labels;
  labels << Wt::WString("Command");
  fHelpTreeWidget->setHeaderLabels(labels);
// #endif

  G4int treeSize = treeTop->GetTreeEntry();
// #if WT_VERSION < 0x040000
//   WListViewItem * newItem;
// #else
  Wt::WTreeNode * newItem;
// #endif
  for (int a=0;a<treeSize;a++) {
    // Creating new item

// #if WT_VERSION < 0x040000
//     newItem = new WListViewItem(fHelpTreeWidget);
//     newItem->setText(0,WString((char*)(treeTop->GetTree(a+1)->GetPathName()).data()).simplifyWhiteSpace());
// #else
    newItem = new Wt::WTreeNode(fHelpTreeWidget);
    newItem->setText(0,Wt::WString((char*)(treeTop->GetTree(a+1)->GetPathName()).data()).trimmed());
// #endif


    // look for childs
    CreateChildTree(newItem,treeTop->GetTree(a+1));
    //      items.append(newItem);
  }


// #if WT_VERSION < 0x040000
//   connect(fHelpTreeWidget, SIGNAL(selectionChanged ()),this, SLOT(HelpTreeClicCallback()));  
//   connect(fHelpTreeWidget, SIGNAL(doubleClicked (WListViewItem*)),this, SLOT(HelpTreeDoubleClicCallback()));
// #else
  connect(fHelpTreeWidget, SIGNAL(itemSelectionChanged ()),this, SLOT(HelpTreeClicCallback()));  
  connect(fHelpTreeWidget, SIGNAL(itemDoubleClicked (Wt::WTreeNode*,int)),this, SLOT(HelpTreeDoubleClicCallback()));  
// #endif

  return fHelpTreeWidget;
}



/**   Fill the Help Tree Widget
   @param aParent : parent item to fill
   @param aCommandTree : commandTree node associate with this part of the Tree
*/
// #if WT_VERSION < 0x040000
// void G4UIWt::CreateChildTree(
//  WListViewItem *aParent
// ,G4UIcommandTree *aCommandTree
// #else
void G4UIWt::CreateChildTree(
 Wt::WTreeNode *aParent
,G4UIcommandTree *aCommandTree
// #endif
)
{
  if (aParent == NULL) return;
  if (aCommandTree == NULL) return;


  // Creating new item
// #if WT_VERSION < 0x040000
//   WListViewItem * newItem;
// #else
  Wt::WTreeNode * newItem;
// #endif

  // Get the Sub directories
  for (int a=0;a<aCommandTree->GetTreeEntry();a++) {

// #if WT_VERSION < 0x040000
//       newItem = new WListViewItem(aParent);
//       newItem->setText(0,WString((char*)(aCommandTree->GetTree(a+1)->GetPathName()).data()).simplifyWhiteSpace());

// #else
    newItem = new Wt::WTreeNode(aParent);
    newItem->setText(0,WString((char*)(aCommandTree->GetTree(a+1)->GetPathName()).data()).trimmed());
// #endif

    CreateChildTree(newItem,aCommandTree->GetTree(a+1));
  }



  // Get the Commands

  for (int a=0;a<aCommandTree->GetCommandEntry();a++) {
    
    Wt::WStringList stringList;
// #if WT_VERSION < 0x040000
//     newItem = new WListViewItem(aParent);
//     newItem->setText(0,WString((char*)(aCommandTree->GetCommand(a+1)->GetCommandPath()).data()).simplifyWhiteSpace());
//     newItem->setOpen(false);

// #else
    newItem = new Wt::WTreeNode(aParent);
    newItem->setText(0,WString((char*)(aCommandTree->GetCommand(a+1)->GetCommandPath()).data()).trimmed());
// #if WT_VERSION < 0x040202
//    	fHelpTreeWidget->setItemExpanded(newItem,false); 
// #else
    newItem->setExpanded(false);
// #endif
// #endif
      
  }
}


/** Find a treeItemWidget in the help tree
    @param aCommand item's String to look for
    @return item if found, NULL if not
*/
// #if WT_VERSION < 0x040000
// WListViewItem* G4UIWt::FindTreeItem(
//  WListViewItem *aParent
// #else
Wt::WTreeNode* G4UIWt::FindTreeItem(
 Wt::WTreeNode *aParent
// #endif
,const Wt::WString& aCommand
)
{
  if (aParent == NULL) return NULL;

  if (aParent->text(0) == aCommand)
    return aParent;
  
// #if WT_VERSION < 0x040000
//   WListViewItem * tmp = NULL;
//   WListViewItem* tmpItem = aParent->firstChild();
//     while (tmpItem != 0) {
//       if (!tmp)
//         tmp = FindTreeItem(tmpItem,aCommand);
//       tmpItem = tmpItem->nextSibling();
//     }

// #else
  Wt::WTreeNode * tmp = NULL;
  for (int a=0;a<aParent->childCount();a++) {
    if (!tmp)
      tmp = FindTreeItem(aParent->child(a),aCommand);
  }
// #endif
  return tmp;
}


/**   Build the command list parameters in a WString<br>
   Reimplement partialy the G4UIparameter.cc
   @param aCommand : command to list parameters
   @see G4UIparameter::List()
   @see G4UIcommand::List()
   @return the command list parameters, or "" if nothing
*/
Wt::WString G4UIWt::GetCommandList (
 const G4UIcommand *aCommand
)
{

  Wt::WString txt ="";
  if (aCommand == NULL)
    return txt;

  G4String commandPath = aCommand->GetCommandPath();
  G4String rangeString = aCommand->GetRange();
  G4int n_guidanceEntry = aCommand->GetGuidanceEntries();
  G4int n_parameterEntry = aCommand->GetParameterEntries();
  
  if ((commandPath == "") && 
      (rangeString == "") &&
      (n_guidanceEntry == 0) &&
      (n_parameterEntry == 0)) {
    return txt;
  }

  if((commandPath.length()-1)!='/') {
    txt += "Command " + Wt::WString((char*)(commandPath).data()) + "\n";
  }
  txt += "Guidance :\n";
  
  for( G4int i_thGuidance=0; i_thGuidance < n_guidanceEntry; i_thGuidance++ ) {
    txt += Wt::WString((char*)(aCommand->GetGuidanceLine(i_thGuidance)).data()) + "\n";
  }
  if( ! rangeString.isNull() ) {
    txt += " Range of parameters : " + Wt::WString((char*)(rangeString).data()) + "\n";
  }
  if( n_parameterEntry > 0 ) {
    G4UIparameter *param;
    
    // Re-implementation of G4UIparameter.cc
    
    for( G4int i_thParameter=0; i_thParameter<n_parameterEntry; i_thParameter++ ) {
      param = aCommand->GetParameter(i_thParameter);
      txt += "\nParameter : " + Wt::WString((char*)(param->GetParameterName()).data()) + "\n";
      if( ! param->GetParameterGuidance().isNull() )
        txt += Wt::WString((char*)(param->GetParameterGuidance()).data())+ "\n" ;
      txt += " Parameter type  : " + Wt::WString(WChar(param->GetParameterType())) + "\n";
      if(param->IsOmittable()){
        txt += " Omittable       : True\n";
      } else {
        txt += " Omittable       : False\n";
      }
      if( param->GetCurrentAsDefault() ) {
        txt += " Default value   : taken from the current value\n";
      } else if( ! param->GetDefaultValue().isNull() ) {
        txt += " Default value   : " + Wt::WString((char*)(param->GetDefaultValue()).data())+ "\n";
      }
      if( ! param->GetParameterRange().isNull() ) {
        txt += " Parameter range : " + Wt::WString((char*)(param->GetParameterRange()).data())+ "\n";
      }
      if( ! param->GetParameterCandidates().isNull() ) {
        txt += " Candidates      : " + Wt::WString((char*)(param->GetParameterCandidates()).data())+ "\n";
      }
    }
  }
  return txt;
}



/**  Implement G4VBasicShell vurtual function
 */
G4bool G4UIWt::GetHelpChoice(
 G4int& aInt
)
{
#ifdef G4DEBUG_INTERFACES_BASIC
  printf("G4UIWt::GetHelpChoice SHOULD NEVER GO HERE");
#endif
  return true;
}


/**   Implement G4VBasicShell vurtual function
*/
void G4UIWt::ExitHelp(
)
{
#ifdef G4DEBUG_INTERFACES_BASIC
  printf("G4UIWt::ExitHelp SHOULD NEVER GO HERE");
#endif
}


/**   Event filter method. Every event from WtApplication goes here.<br/>
   We apply a filter only for the Up and Down Arrow press when the WLineEdit<br/>
   is active. If this filter match, Up arrow we give the previous command<br/>
   and Down arrow will give the next if exist.<br/>
   @param obj Emitter of the event
   @param event Kind of event
*/
bool G4UIWt::eventFilter( // Should stay with a minuscule eventFilter because of Wt
 WObject *aObj
,Wt::WEvent *aEvent
)
{
  if (aObj == NULL) return false;
  if (aEvent == NULL) return false;

  if (aObj == fCommandHistoryArea) {
    if (aEvent->type() == Wt::WEvent::KeyPress) {
      fCommandArea->setFocus();
    }
  }
  if (aObj == fCommandArea) {
    if (aEvent->type() == Wt::WEvent::KeyPress) {
      Wt::WKeyEvent *e = static_cast<Wt::WKeyEvent*>(aEvent);
      if ((e->key() == (Wt::Key_Down)) ||
          (e->key() == (Wt::Key_PageDown)) ||
          (e->key() == (Wt::Key_Up)) ||
          (e->key() == (Wt::Key_PageUp))) {
// #if WT_VERSION < 0x040000
//         // count rows...
//         WListViewItem* tmpItem = fCommandHistoryArea->firstChild();
//         int selection = -1;
//         int index = 0;
//         while (tmpItem != 0) {
//           if (tmpItem == fCommandHistoryArea->selectedItem()) {
//             selection = index;
//           }
//           index ++;
//           tmpItem = tmpItem->nextSibling();
//         }
//         if (fCommandHistoryArea->childCount()) {
//           if (selection == -1) {
//             selection = fCommandHistoryArea->childCount()-1;
//           } else {
//             if (e->key() == (Wt::Key_Down)) {
//               if (selection <(fCommandHistoryArea->childCount()-1))
//                 selection++;
//             } else if (e->key() == (Wt::Key_PageDown)) {
//               selection = fCommandHistoryArea->childCount()-1;
// #else
        int selection = fCommandHistoryArea->currentRow();
        if (fCommandHistoryArea->count()) {
          if (selection == -1) {
            selection = fCommandHistoryArea->count()-1;
          } else {
            if (e->key() == (Wt::Key_Down)) {
              if (selection <(fCommandHistoryArea->count()-1))
                selection++;
            } else if (e->key() == (Wt::Key_PageDown)) {
              selection = fCommandHistoryArea->count()-1;
// #endif
            } else if (e->key() == (Wt::Key_Up)) {
              if (selection >0)
                selection --;
            } else if (e->key() == (Wt::Key_PageUp)) {
              selection = 0;
            }
          }
          fCommandHistoryArea->clearSelection();
// #if WT_VERSION < 0x040000
//           WListViewItem* tmpItem = fCommandHistoryArea->firstChild();
//           int index = 0;
//           while (tmpItem != 0) {
//             if (index == selection) {
//               tmpItem->setSelected(true);
//               fCommandHistoryArea->setCurrentItem(tmpItem);
//           }
//           index ++;
//           tmpItem = tmpItem->nextSibling();
//         }
// #else
// #if WT_VERSION < 0x040202
          fCommandHistoryArea->setItemSelected(fCommandHistoryArea->item(selection),true);
// #else
//           fCommandHistoryArea->item(selection)->setSelected(true);
// #endif      
//           fCommandHistoryArea->setCurrentItem(fCommandHistoryArea->item(selection));
// #endif
        }
      } else if (e->key() == (Wt::Key_Tab)) {
// #if WT_VERSION < 0x040000
//         G4String ss = Complete(fCommandArea->text().ascii());
// #else
        G4String ss = Complete(fCommandArea->text().toStdString().c_str());
// #endif
        fCommandArea->setText((char*)(ss.data()));

        // do not pass by parent, it will disable widget tab focus !
        return true;
      }
    }
  }
  // pass the event on to the parent class
  return Wt::WObject::eventFilter(aObj, aEvent);
}




/***************************************************************************/
//
//             SLOTS DEFINITIONS
//
/***************************************************************************/

/**   Called when user give "help" command.
*/
void G4UIWt::ShowHelpCallback (
)
{
  TerminalHelp("");
}


/**   Called when user click on clear button. Clear the text Output area
*/
void G4UIWt::ClearButtonCallback (
)
{
  fTextArea->clear();
}

/**   Called when user exit session
*/
void G4UIWt::ExitSession (
)
{
  SessionTerminate();
}


/**   Callback call when "click on a menu entry.<br>
   Send the associated command to geant4
*/
void G4UIWt::CommandEnteredCallback (
)
{
// #if WT_VERSION < 0x040000
//   G4String command (fCommandArea->text().ascii());
//   if (fCommandArea->text().simplifyWhiteSpace() != "") {

//     WListViewItem *newItem = new WListViewItem(fCommandHistoryArea);
//     newItem->setText(0,fCommandArea->text());
//     fCommandHistoryArea->insertItem(newItem);
//     // now we have to arrange 
//     WListViewItem *temp= fCommandHistoryArea->lastItem();
//     for (int i=0; i<fCommandHistoryArea->childCount()-1;i++) {
//       fCommandHistoryArea->takeItem(temp);
//       fCommandHistoryArea->insertItem(temp);
//       temp= fCommandHistoryArea->lastItem();
//     }
// #else
  G4String command (fCommandArea->text().toStdString().c_str());
  if (fCommandArea->text().trimmed() != "") {
    fCommandHistoryArea->addItem(fCommandArea->text());
// #endif
    fCommandHistoryArea->clearSelection();
    fCommandHistoryArea->setCurrentItem(NULL);
    fCommandArea->setText("");

    G4Wt* interactorManager = G4Wt::getInstance ();
    if (interactorManager) { 
      interactorManager->FlushAndWaitExecution();
    }
    if (command(0,4) != "help") {
      ApplyShellCommand (command,exitSession,exitPause);
    } else {
      TerminalHelp(command);
    }
    if(exitSession==true) 
      SessionTerminate();
  }
}


/**   Callback call when "enter" clicked on the command zone.<br>
   Send the command to geant4
   @param aCommand
*/
void G4UIWt::ButtonCallback (
 const WString& aCommand
)
{
// #if WT_VERSION < 0x040000
//   G4String ss = G4String(aCommand.ascii());
// #else
  G4String ss = G4String(aCommand.toStdString().c_str());
// #endif
  ApplyShellCommand(ss,exitSession,exitPause);
  if(exitSession==true) 
    SessionTerminate();
}



/**   This callback is activated when user selected a item in the help tree
*/
void G4UIWt::HelpTreeClicCallback (
)
{
// #if WT_VERSION < 0x040000
//   WListViewItem* item =  NULL;
// #else
  WTreeNode* item =  NULL;
// #endif
  if (!fHelpTreeWidget)
    return ;

  if (!fHelpArea)
    return;
  
// #if WT_VERSION < 0x040000
//   item =fHelpTreeWidget->selectedItem();
// #else
  Wt::WList<WTreeNode *> list =fHelpTreeWidget->selectedItems();
  if (list.isEmpty())
    return;
  item = list.first();
// #endif
  if (!item)
    return;
  
  G4UImanager* UI = G4UImanager::GetUIpointer();
  if(UI==NULL) return;
  G4UIcommandTree * treeTop = UI->GetTree();



  std::string itemText;
// #if WT_VERSION < 0x040000
//   itemText = std::string(item->text(0).ascii());
// #else
  itemText = std::string(item->text(0).toStdString());
// #endif

  G4UIcommand* command = treeTop->FindPath(itemText.c_str());

  if (command) {
// #if WT_VERSION >= 0x040000
// #if WT_VERSION < 0x040200
//     fHelpArea->clear();
//     fHelpArea->append(GetCommandList(command));
// #else
    fHelpArea->setText(GetCommandList(command));
// #endif
// #else
//     fHelpArea->setText(GetCommandList(command));
// #endif
  } else {  // this is a command
    G4UIcommandTree* path = treeTop->FindCommandTree(itemText.c_str());
    if ( path) {
      // this is not a command, this is a sub directory
      // We display the Title
// #if WT_VERSION >= 0x040000
// #if WT_VERSION < 0x040200
//       fHelpArea->clear();
//       fHelpArea->append(path->GetTitle().data());
// #else
      fHelpArea->setText(path->GetTitle().data());
// #endif
// #else
//       fHelpArea->setText(path->GetTitle().data());
// #endif
    }
  }
}
 
/**   This callback is activated when user double clic on a item in the help tree
*/
void G4UIWt::HelpTreeDoubleClicCallback (
)
{
  HelpTreeClicCallback();

// #if WT_VERSION < 0x040000
//   WListViewItem* item =  NULL;
// #else
  Wt::WTreeNode* item =  NULL;
// #endif
  if (!fHelpTreeWidget)
    return ;

  if (!fHelpArea)
    return;
  
// #if WT_VERSION < 0x040000
//   item =fHelpTreeWidget->selectedItem();
// #else
  Wt::WList<Wt::WTreeNode *> list =fHelpTreeWidget->selectedItems();
  if (list.isEmpty())
    return;
  item = list.first();
// #endif
  if (!item)
    return;

  fCommandArea->clear();
  fCommandArea->setText(item->text(0));
}


/**   Callback called when user select an old command in the command history<br>
   Give it to the command area.
*/
void G4UIWt::CommandHistoryCallback(
)
{
// #if WT_VERSION < 0x040000
//   WListViewItem* item =  NULL;
// #else
// #endif
  if (!fCommandHistoryArea)
    return ;

  
// #if WT_VERSION < 0x040000
//   item =fCommandHistoryArea->selectedItem();
// #else
// #endif
// #if WT_VERSION < 0x040000
//   fCommandArea->setText(item->text(0));
// #else
  fCommandArea->setText(fCommandHistoryArea->curentText());
// #endif

}


/**   Callback called when user give a new string to look for<br>
   Display a list of matching commands descriptions. If no string is set,
   will display the complete help tree
*/
void G4UIWt::lookForHelpStringCallback(
)
{
// #if WT_VERSION < 0x040200
//   fHelpArea->clear();
// #else
  fHelpArea->setText("");
// #endif
  if (fHelpLine->text() =="") {
    // clear old help tree
    fHelpTreeWidget->clearSelection();
// #if WT_VERSION < 0x040000
//     fHelpTreeWidget->removeColumn(1);
//     fHelpTreeWidget->removeColumn(0);
// #endif
    CreateHelpTree();
    return;
  }

  // the help tree
  G4UImanager* UI = G4UImanager::GetUIpointer();
  if(UI==NULL) return;
  G4UIcommandTree * treeTop = UI->GetTree();
  
  G4int treeSize = treeTop->GetTreeEntry();

  // clear old help tree
  fHelpTreeWidget->clearSelection();
// #if WT_VERSION < 0x040000
//   fHelpTreeWidget->removeColumn(1);
//   fHelpTreeWidget->removeColumn(0);
// #endif

  // look for new items

  int tmp = 0;
// #if WT_VERSION < 0x040000
//   int multFactor = 1000; // factor special for having double keys in Wt3
//   int doubleKeyAdd = 0;  // decay for doubleKeys in Wt3
// #endif

  Wt::WMap<int,Wt::WString> commandResultyMap;
  Wt::WMap<int,Wt::WString> commandChildResultMap;

  for (int a=0;a<treeSize;a++) {
    G4UIcommand* command = treeTop->FindPath(treeTop->GetTree(a+1)->GetPathName().data());
// #if WT_VERSION > 0x040000
    tmp = GetCommandList (command).count(fHelpLine->text(),Wt::CaseInsensitive);
// #else
//     tmp = GetCommandList (command).contains(fHelpLine->text(),false);
// #endif
    if (tmp >0) {
// #if WT_VERSION > 0x040000
       commandResultMap.insertMulti(tmp,Wt::WString((char*)(treeTop->GetTree(a+1)->GetPathName()).data()));
// #else // tricky thing for Wt3...
//       doubleKeyAdd = 0;
//       while (commandResultMap.find( tmp*multFactor+doubleKeyAdd) != commandResultMap.end()) {
//         doubleKeyAdd ++;
//       }
//       commandResultMap.insert( tmp*multFactor+doubleKeyAdd,WString((char*)(treeTop->GetTree(a+1)->GetPathName()).data()) );
// #endif
    }
    // look for childs
    commandChildResultMap = LookForHelpStringInChildTree(treeTop->GetTree(a+1),fHelpLine->text());
    // insert new childs
    if (!commandChildResultMap.empty()) {
// #if WT_VERSION > 0x040000
      Wt::WMap<int,WString>::const_iterator i = commandChildResultMap.constBegin();
      while (i != commandChildResultMap.constEnd()) {
        commandResultMap.insertMulti(i.key(),i.value());
// #else // tricky thing for Wt3...
//       WMap<int,WString>::const_iterator i = commandChildResultMap.begin();
//       while (i != commandChildResultMap.end()) {
//         doubleKeyAdd = 0;
//         while (commandResultMap.find( i.key()*multFactor+doubleKeyAdd) != commandResultMap.end()) {
//           doubleKeyAdd ++;
//         }
//         commandResultMap.insert(i.key()*multFactor+doubleKeyAdd,i.data());
// #endif
        i++;
      }
      commandChildResultMap.clear();
    }
  }

  // build new help tree
// #if WT_VERSION < 0x040000
//   fHelpTreeWidget->setSelectionMode(WListView::Single);
//   fHelpTreeWidget->setRootIsDecorated(true);
//   fHelpTreeWidget->addColumn("Command");
//   fHelpTreeWidget->addColumn("Match");
//   //  fHelpTreeWidget->header()->setResizeEnabled(FALSE,1);
// #else
  fHelpTreeWidget->setSelectionMode(Wt::WAbstractItemView::SingleSelection);
  fHelpTreeWidget->setColumnCount(2);
  Wt::WStringList labels;
  labels << Wt::WString("Command") << Wt::WString("Match");
  fHelpTreeWidget->setHeaderLabels(labels);
// #endif

  if (commandResultMap.empty()) {
// #if WT_VERSION < 0x040200
//     fHelpArea->clear();
//     fHelpArea->append("No match found");
// #else
    fHelpArea->setText("No match found");
// #endif
    return;
  }

// #if WT_VERSION > 0x040000
//   WMap<int,WString>::const_iterator i = commandResultMap.constEnd();
// #else
  Wt::WMap<int,Wt::WString>::const_iterator i = commandResultMap.end();
// #endif
  i--;
  // 10 maximum progress values
  float multValue = 10.0/(float)(i.key());
  Wt::WString progressChar = "|";
  Wt::WString progressStr = "|";

// #if WT_VERSION < 0x040000
//   WListViewItem * newItem;
// #else
  Wt::WTreeNode * newItem;
// #endif
  bool end = false;
  while (!end) {
// #if WT_VERSION > 0x040000
    if (i == commandResultMap.constBegin()) {
// #else
//     if (i == commandResultMap.begin()) {
// #endif
      end = true;
    }
    for(int a=0;a<int(i.key()*multValue);a++) {
      progressStr += progressChar;
    }
// #if WT_VERSION < 0x040000
//     newItem = new WListViewItem(fHelpTreeWidget);
//     newItem->setText(0,i.data().simplifyWhiteSpace());
// #else
    newItem = new Wt::WTreeNode(fHelpTreeWidget);
    newItem->setText(0,i.value().trimmed());
// #endif
    newItem->setText(1,progressStr);
    
// #if WT_VERSION >= 0x040200
    newItem->setForeground ( 1, Wt::WBrush(Wt::blue) );
// #endif
    progressStr = "|";
    i--;
  }
  // FIXME :  to be checked on Wt3
// #if WT_VERSION < 0x040000
//   fHelpTreeWidget->setColumnWidthMode (1,WListView::Maximum);
//   fHelpTreeWidget->setSorting(1,false);
// #else
  fHelpTreeWidget->resizeColumnToContents (0);
  fHelpTreeWidget->sortItems(1,Wt::DescendingOrder);
  //  fHelpTreeWidget->setColumnWidth(1,10);//resizeColumnToContents (1);
// #endif
}




Wt::WMap<int,Wt::WString> G4UIWt::LookForHelpStringInChildTree(
 G4UIcommandTree *aCommandTree
,const Wt::WString & text
 )
{
  Wt::WMap<int,Wt::WString> commandResultMap;
  if (aCommandTree == NULL) return commandResultMap;
  
// #if WT_VERSION < 0x040000
//   int multFactor = 1000; // factor special for having double keys in Wt3
//   int doubleKeyAdd = 0;  // decay for doubleKeys in Wt3
// #endif

  // Get the Sub directories
  int tmp = 0;
  Wt::WMap<int,Wt::WString> commandChildResultMap;
  
  for (int a=0;a<aCommandTree->GetTreeEntry();a++) {
    const G4UIcommand* command = aCommandTree->GetGuidance();
// #if WT_VERSION > 0x040000
    tmp = GetCommandList (command).count(text,Wt::CaseInsensitive);
// #else
//     tmp = GetCommandList (command).contains(text,false);
// #endif
    if (tmp >0) {
// #if WT_VERSION > 0x040000
      commandResultMap.insertMulti(tmp,Wt::WString((char*)(aCommandTree->GetTree(a+1)->GetPathName()).data()));
// #else // tricky thing for Wt3...
//       doubleKeyAdd = 0;
//       while (commandResultMap.find( tmp*multFactor+doubleKeyAdd) != commandResultMap.end()) {
//         doubleKeyAdd ++;
//       }
//       commandResultMap.insert(tmp*multFactor+doubleKeyAdd,WString((char*)(aCommandTree->GetTree(a+1)->GetPathName()).data()));
// #endif
    }
    // look for childs
    commandChildResultMap = LookForHelpStringInChildTree(aCommandTree->GetTree(a+1),text);
    
    if (!commandChildResultMap.empty()) {
      // insert new childs
// #if WT_VERSION > 0x040000
      Wt::WMap<int,Wt::WString>::const_iterator i = commandChildResultMap.constBegin();
      while (i != commandChildResultMap.constEnd()) {
        commandResultMap.insertMulti(i.key(),i.value());
// #else // tricky thing for Wt3...
//       WMap<int,WString>::const_iterator i = commandChildResultMap.begin();
//       while (i != commandChildResultMap.end()) {
//         doubleKeyAdd = 0;
//         while (commandResultMap.find( i.key()*multFactor+doubleKeyAdd) != commandResultMap.end()) {
//           doubleKeyAdd ++;
//         }
//         commandResultMap.insert(i.key()*multFactor+doubleKeyAdd,i.data());
// #endif
        i++;
      }
      commandChildResultMap.clear();
    }
  }
  // Get the Commands
  
  for (int a=0;a<aCommandTree->GetCommandEntry();a++) {
    const G4UIcommand* command = aCommandTree->GetCommand(a+1);
// #if WT_VERSION > 0x040000
    tmp = GetCommandList (command).count(text,Wt::CaseInsensitive);
// #else
//     tmp = GetCommandList (command).contains(text,false);
// #endif
    if (tmp >0) {
// #if WT_VERSION > 0x040000
      commandResultMap.insertMulti(tmp,Wt::WString((char*)(aCommandTree->GetCommand(a+1)->GetCommandPath()).data()));
// #else // tricky thing for Wt3...
//       doubleKeyAdd = 0;
//       while (commandResultMap.find( tmp*multFactor+doubleKeyAdd) != commandResultMap.end()) {
//         doubleKeyAdd ++;
//       }
//       commandResultMap.insert(tmp*multFactor+doubleKeyAdd,WString((char*)(aCommandTree->GetCommand(a+1)->GetCommandPath()).data()));
// #endif
#ifdef G4DEBUG_INTERFACES_BASIC
#endif
    }
    
  }
  return commandResultMap;
}
#endif
