//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4OpenGLStoredQtViewer.cc,v 1.26 2009/07/27 14:01:13 lgarnier Exp $
// GEANT4 tag $Name:  $
//
//
// Class G4OpenGLStoredQtViewer : a class derived from G4OpenGLQtViewer and
//                                G4OpenGLStoredViewer.

#ifdef G4VIS_BUILD_OPENGLQT_DRIVER
#define QT_STORE_46_DBG 1
#define QT_STORE_46_DBG_INIT 1
#define QT_STORE_46_DBG_COMPUTE 1 seul ok
//#define QT_STORE_46_DBG_RESIZE 1 resize et compute ok
//#define QT_STORE_46_DBG_PAINT 1

#include "G4VViewer.hh"
#include "G4OpenGLStoredQtViewer.hh"
#include "G4OpenGLStoredSceneHandler.hh"

#include "G4ios.hh"

G4OpenGLStoredQtViewer::G4OpenGLStoredQtViewer
(G4OpenGLStoredSceneHandler& sceneHandler,
 const G4String&  name):
  G4VViewer (sceneHandler, sceneHandler.IncrementViewCount (), name),
  G4OpenGLViewer (sceneHandler),
  G4OpenGLQtViewer (sceneHandler),
  G4OpenGLStoredViewer (sceneHandler)             // FIXME : gerer le pb du parent !
{

#if QT_VERSION < 0x040000
  setFocusPolicy(QWidget::StrongFocus); // enable keybord events
#else
  setFocusPolicy(Qt::StrongFocus); // enable keybord events
#endif
  fHasToRepaint =false;

  if (fViewId < 0) return;  // In case error in base class instantiation.
}

G4OpenGLStoredQtViewer::~G4OpenGLStoredQtViewer() {
  makeCurrent();
  // this is connect to the Dialog for deleting it properly
  // when close event.
  //   ((QDialog*)window())->reject();
}

void G4OpenGLStoredQtViewer::Initialise() {
#ifdef G4DEBUG_VIS_OGL
  printf("G4OpenGLStoredQtViewer::Initialise 1\n");
#endif
  fReadyToPaint = false;
  CreateMainWindow (this,QString(fName));
  CreateFontLists ();
  
  fReadyToPaint = true;
}

#ifdef QT_STORE_46_DBG_INIT
void G4OpenGLStoredQtViewer::initializeGL () {
  glShadeModel(GL_SMOOTH);							// Enable Smooth Shading
  glClearColor(0.0f, 0.0f, 0.0f, 0.5f);				// Black Background
  glClearDepth(1.0f);									// Depth Buffer Setup
  glEnable(GL_DEPTH_TEST);							// Enables Depth Testing
  glDepthFunc(GL_LEQUAL);								// The Type Of Depth Testing To Do
  glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);	// Really Nice Perspective Calculations
 

 return;										// Initialization Went OK

 }
#else
void G4OpenGLStoredQtViewer::initializeGL () {

  InitializeGLView ();

#ifdef G4DEBUG_VIS_OGL
  printf("G4OpenGLStoredQtViewer::InitialiseGL () 1\n");
#endif

  // clear the buffers and window.
  ClearView ();
  FinishView ();
   
  glDepthFunc (GL_LEQUAL);
  glDepthMask (GL_TRUE);
#ifdef G4DEBUG_VIS_OGL
    printf("glDepthFunc (GL_LEQUAL)  G4OpenGLStoredQtViewer\n ");
    printf("glDepthMask (GL_TRUE)  G4OpenGLStoredQtViewer\n ");
#endif

  if (fSceneHandler.GetScene() == 0) {
    fHasToRepaint =false;
  } else {
    fHasToRepaint =true;
  }

#ifdef G4DEBUG_VIS_OGL
  printf("G4OpenGLStoredQtViewer::InitialiseGL  END\n");
#endif
}

#endif

void G4OpenGLStoredQtViewer::DrawView () {
#ifdef G4DEBUG_VIS_OGL
  printf("G4OpenGLStoredQtViewer::DrawView  VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV\n");
#endif
  // That's no the same logic as Immediate Viewer, I don't know why...
  // But if I send updateGL here, we go here :
  //  updateQWidget -> paintGL -> ComputeView
  // whih is not the same as ComputeView Directly
  // And we loose the redraw of things !
  
  ComputeView();
#ifdef G4DEBUG_VIS_OGL
  printf("G4OpenGLStoredQtViewer::DrawView  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n");
#endif
}

#ifdef QT_STORE_46_DBG_COMPUTE
void G4OpenGLStoredQtViewer::ComputeView () {
    glBegin(GL_QUADS);
    //carr rouge
    glColor3ub(255,0,0);
    glVertex3d(9,9,0);
    glVertex3d(9,0,0);
    glVertex3d(0,0,0);
    glVertex3d(0,9,0);
    //carr vert
    glColor3ub(0,255,0);
    glVertex3d(9,9,0);
    glVertex3d(18,9,0);
    glVertex3d(18,0,0);
    glVertex3d(9,0,0);
    //carr vert
    glColor3ub(0,255,0);
    glVertex3d(0,18,0);
    glVertex3d(9,18,0);
    glVertex3d(9,9,0);
    glVertex3d(0,9,0);
    //carr bleu
    glColor3ub(0,0,255);
    glVertex3d(18,18,0);
    glVertex3d(18,9,0);
    glVertex3d(9,9,0);
    glVertex3d(9,18,0);
    //carr bleu
    glColor3ub(0,0,255);
    glVertex3d(9,0,0);
    glVertex3d(9,9,0);
    glVertex3d(9,9,9);
    glVertex3d(9,0,9);
    //carr blanc
    glColor3ub(255,255,255);
    glVertex3d(9,9,0);
    glVertex3d(0,9,0);
    glVertex3d(0,9,9);
    glVertex3d(9,9,9);
    //carr rouge
    glColor3ub(255,0,0);
    glVertex3d(9,9,9);
    glVertex3d(9,0,9);
    glVertex3d(0,0,9);
    glVertex3d(0,9,9);
    glEnd();
 }
#else
void G4OpenGLStoredQtViewer::ComputeView () {

#ifdef G4DEBUG_VIS_OGL
  printf("G4OpenGLStoredQtViewer::ComputeView %d %d   VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV\n",getWinWidth(), getWinHeight());
#endif
  makeCurrent();
  G4ViewParameters::DrawingStyle style = GetViewParameters().GetDrawingStyle();

  //Make sure current viewer is attached and clean...

  //See if things have changed from last time and remake if necessary...
  // The fNeedKernelVisit flag might have been set by the user in
  // /vis/viewer/rebuild, but if not, make decision and set flag only
  // if necessary...
  if (!fNeedKernelVisit) {
    KernelVisitDecision ();
  }
  G4bool kernelVisitWasNeeded = fNeedKernelVisit; // Keep (ProcessView resets).
  ProcessView ();
   

  if(style!=G4ViewParameters::hlr &&
     haloing_enabled) {
#ifdef G4DEBUG_VIS_OGL
    printf("G4OpenGLStoredQtViewer::ComputeView DANS LE IF\n");
#endif

    HaloingFirstPass ();
    DrawDisplayLists ();
#ifdef G4DEBUG_VIS_OGL
    printf("glFlush ()  G4OpenGLStoredQtViewer\n ");
#endif
    glFlush ();

    HaloingSecondPass ();

    DrawDisplayLists ();
    FinishView ();

  } else {
     
    // If kernel visit was needed, drawing and FinishView will already
    // have been done, so...
    if (!kernelVisitWasNeeded) {
#ifdef G4DEBUG_VIS_OGL
      printf("**************************  G4OpenGLStoredQtViewer::ComputeView Don't need kernel Visit \n");
#endif
      DrawDisplayLists ();
      FinishView ();
    } else {
#ifdef G4DEBUG_VIS_OGL
      printf("**************************  G4OpenGLStoredQtViewer::ComputeView need kernel Visit \n");
#endif
      // However, union cutaways are implemented in DrawDisplayLists, so make
      // an extra pass...
      if (fVP.IsCutaway() &&
          fVP.GetCutawayMode() == G4ViewParameters::cutawayUnion) {
        ClearView();
        DrawDisplayLists ();
        FinishView ();
#ifdef G4DEBUG_VIS_OGL
        printf("***************************  CASE 4 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ \n");
#endif
      } else { // ADD TO AVOID KernelVisit=1 and nothing to display
        DrawDisplayLists ();
        FinishView ();
      }
    }
  }

  if (isRecording()) {
    savePPMToTemp();
  }

#ifdef G4DEBUG_VIS_OGL
  printf("G4OpenGLStoredQtViewer::ComputeView %d %d ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ \n",getWinWidth(), getWinHeight());
#endif
  fHasToRepaint =true;
}
#endif


/**
   - Lors du resize de la fenetre, on doit non pas redessiner le detecteur, mais aussi les evenements
*/
#ifdef QT_STORE_46_DBG_RESIZE
void G4OpenGLStoredQtViewer::resizeGL(
                                      int aWidth
                                      ,int aHeight)
{  
#ifdef G4DEBUG_VIS_OGL
  printf("G4OpenGLStoredQtViewer::resizeGL\n");
#endif
  // Set new size, it will be update when next Repaint()->SetView() called
  if (2 == 1) {
    if (aHeight==0)
      {
        aHeight=1;	
      }
    
    glViewport(0,0,aWidth,aHeight);
    
    glMatrixMode(GL_PROJECTION);		
    glLoadIdentity();	
    
    // Calculate The Aspect Ratio Of The Window
    gluPerspective(45.0f,(GLfloat)aWidth/(GLfloat)aHeight,0.1f,100.0f);
    
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
  } else {
    int side = qMin(aWidth, aHeight);
    glViewport((aWidth - side) / 2, (aHeight - side) / 2, side, side);
    
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glOrtho(-0.5, +0.5, -0.5, +0.5, 4.0, 15.0);
    glMatrixMode(GL_MODELVIEW);
  }
}
#else
void G4OpenGLStoredQtViewer::resizeGL(
                                      int aWidth
                                      ,int aHeight)
{  
#ifdef G4DEBUG_VIS_OGL
  printf("G4OpenGLStoredQtViewer::resizeGL\n");
#endif
  // Set new size, it will be update when next Repaint()->SetView() called

  ResizeWindow(aWidth,aHeight);



  SetView(); // en test .......................
  //  ResizeGLView(); // en test .......................




  fHasToRepaint = sizeHasChanged();
}
#endif


#ifdef QT_STORE_46_DBG_PAINT
void G4OpenGLStoredQtViewer::paintGL()
{
#ifdef G4DEBUG_VIS_OGL
  printf("G4OpenGLStoredQtViewer::paintGL\n");
#endif
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    gluLookAt(15,15,15,0,0,0,0,0,1);

    glBegin(GL_QUADS);
    //carr rouge
    glColor3ub(255,0,0);
    glVertex3d(9,9,0);
    glVertex3d(9,0,0);
    glVertex3d(0,0,0);
    glVertex3d(0,9,0);
    //carr vert
    glColor3ub(0,255,0);
    glVertex3d(9,9,0);
    glVertex3d(18,9,0);
    glVertex3d(18,0,0);
    glVertex3d(9,0,0);
    //carr vert
    glColor3ub(0,255,0);
    glVertex3d(0,18,0);
    glVertex3d(9,18,0);
    glVertex3d(9,9,0);
    glVertex3d(0,9,0);
    //carr bleu
    glColor3ub(0,0,255);
    glVertex3d(18,18,0);
    glVertex3d(18,9,0);
    glVertex3d(9,9,0);
    glVertex3d(9,18,0);
    //carr bleu
    glColor3ub(0,0,255);
    glVertex3d(9,0,0);
    glVertex3d(9,9,0);
    glVertex3d(9,9,9);
    glVertex3d(9,0,9);
    //carr blanc
    glColor3ub(255,255,255);
    glVertex3d(9,9,0);
    glVertex3d(0,9,0);
    glVertex3d(0,9,9);
    glVertex3d(9,9,9);
    //carr rouge
    glColor3ub(255,0,0);
    glVertex3d(9,9,9);
    glVertex3d(9,0,9);
    glVertex3d(0,0,9);
    glVertex3d(0,9,9);
    glEnd();
}

#else
void G4OpenGLStoredQtViewer::paintGL()
{
#ifdef G4DEBUG_VIS_OGL
  printf("G4OpenGLStoredQtViewer::paintGL ready:%d fHasTo:%d??\n",fReadyToPaint,fHasToRepaint);
#endif
  if (!fReadyToPaint) {
    fReadyToPaint= true;
    return;
  }
  // DO NOT RESIZE IF SIZE HAS NOT CHANGE :
  //    WHEN CLICK ON THE FRAME FOR EXAMPLE
  //    EXECEPT WHEN MOUSE MOVE EVENT
  if ( !fHasToRepaint) {
    if (((getWinWidth() == (unsigned int)width())) &&(getWinHeight() == (unsigned int) height())) {
      return;
    }
  }
#ifdef G4DEBUG_VIS_OGL
  printf("G4OpenGLStoredQtViewer::paintGL VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV ready %d\n",fReadyToPaint);
#endif

  SetView();
          
  ClearView (); //ok, put the background correct
  ComputeView();
     
  fHasToRepaint =false;
     
#ifdef G4DEBUG_VIS_OGL
  printf("G4OpenGLStoredQtViewer::paintGL ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ ready %d\n",fReadyToPaint);
#endif
}

#endif

void G4OpenGLStoredQtViewer::mousePressEvent(QMouseEvent *event)
{
  G4MousePressEvent(event);
}

void G4OpenGLStoredQtViewer::keyPressEvent (QKeyEvent * event) 
{
  G4keyPressEvent(event);
}

void G4OpenGLStoredQtViewer::wheelEvent (QWheelEvent * event) 
{
  G4wheelEvent(event);
}

/**
 * This function was build in order to make a zoom on double clic event.
 * It was think to build a rubberband on the zoom area, but never work fine
 */
void G4OpenGLStoredQtViewer::mouseDoubleClickEvent(QMouseEvent *)
{
  G4MouseDoubleClickEvent();
}

void G4OpenGLStoredQtViewer::mouseReleaseEvent(QMouseEvent *)
{
  G4MouseReleaseEvent();
}

void G4OpenGLStoredQtViewer::mouseMoveEvent(QMouseEvent *event)
{
  G4MouseMoveEvent(event);
}


void G4OpenGLStoredQtViewer::contextMenuEvent(QContextMenuEvent *e)
{
  G4manageContextMenuEvent(e);
}

void G4OpenGLStoredQtViewer::updateQWidget() {
  fHasToRepaint= true;
  updateGL();
  fHasToRepaint= false;
}

void G4OpenGLStoredQtViewer::ShowView (
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
#if QT_VERSION < 0x040000
  setActiveWindow();
#else
  activateWindow();
#endif
}

#endif
