  set prompt='mac-g4> ' 
  #//////////////////////////////////////////////////////////
  # Core :
  #//////////////////////////////////////////////////////////

  export MAKECMD=make
  export G4INSTALL=/media/disk/Geant4/trunk
  export G4SYSTEM=Linux-g++
  export G4WORKDIR=$G4INSTALL
  export G4STTDIR=$G4WORKDIR/stt
  export G4LIB=$G4INSTALL/lib
  export G4DEBUG=1
  export G4INCLUDE=$G4INSTALL/include/geant4
  export CPPVERBOSE=1
#  export G4LIB_USE_GRANULAR=1
#  unset G4LIB_USE_GRANULAR
  # Shareable library
  export G4LIB_BUILD_SHARED=1
#  unset G4LIB_BUILD_SHARED
  #FIXME export G4LIB_BUILD_SHARED 1
  export CLHEP_BASE_DIR=/media/disk/usr/local
  export DYLD_LIBRARY_PATH=${DYLD_LIBRARY_PATH}:${CLHEP_BASE_DIR}/lib:$G4LIB/$G4SYSTEM
  export LD_LIBRARY_PATH=${DYLD_LIBRARY_PATH}
  # data :
  export G4DATA=$G4INSTALL/data
  export NeutronHPCrossSections=$G4DATA/G4NDL3.5
  export G4LEVELGAMMADATA=$G4DATA/PhotonEvaporation
  export G4RADIOACTIVEDATA=$G4DATA/RadiativeDecay
  export G4LEDATA=$G4DATA//G4EMLOW5.1
#  export QTHOME=/usr/bin
  #//////////////////////////////////////////////////////////
  # GUI, Visualization :
  #//////////////////////////////////////////////////////////
  # GUI :
  export G4UI_BUILD_QT_SESSION=1
  export G4UI_USE_QT=1
  # OpenGL :
  #
  export G4VIS_BUILD_OPENGLQT_DRIVER=1
  export G4VIS_USE_OPENGLQT=1

  export QTFLAGS="-I/usr/include/qt3 -I/usr/include/qt3/QtCore -I/usr/include/qt3/QtGui -I/usr/include/qt3/QtOpenGL"
  export QTLIBS="-L/usr/shared/qt3/lib -lqt-mt -lqui"
  export GLQTLIBS="-L/usr/shared/qt3/lib -lqt-mt -lqui"
  export QTMOC="/usr/bin/moc-qt3"


  #//////////////////////////////////////////////////////////
  # Inventor :
  #//////////////////////////////////////////////////////////
  #export G4VIS_BUILD_OIX_DRIVER=1
  #export G4VIS_USE_OIX=1
  # SGI-Inventor :
  # Darwin : Tiger, g++4.0 out.
  #export OIVHOME /usr/local/SGI-Inventor/2.1.5.10/macos104_gcc40/usr
  #export DYLD_LIBRARY_PATH ${DYLD_LIBRARY_PATH}:"$OIVHOME/lib"
  # OpenScientist RTK Coin* :
  #export OIVHOME /Applications/OpenScientist/v15r0
  #export OIVFLAGS "-I${OIVHOME}/Resources/CoinXt/include -I${OIVHOME}/Resources/CoinGL/include"
  #export OIVLIBS "-L${OIVHOME}/lib -lCoinXt -losc_Coin"
  #export DYLD_LIBRARY_PATH "${DYLD_LIBRARY_PATH}:${OIVHOME}/lib"
  # OpenScientist devel Coin* :
  #export COINGLHOME /barrand/OpenScientist/dev/CoinGL/v1r244p0
  #export COINXTHOME /barrand/OpenScientist/dev/CoinXt/v1r122p0
  #export COINGLHOME=~/Work/svn/trunk/OpenScientist/CoinGL/v1r200p3
  #export COINXTHOME=~/Work/svn/trunk/OpenScientist/CoinXT/v1r50p4
  #export OIVFLAGS="-I${COINGLHOME}/include -I${COINXTHOME}/include"
  #export OIVLIBS="-L${COINXTHOME}/Darwin -lCoinXt -L${COINGLHOME}/Darwin -lCoin"
  #export DYLD_LIBRARY_PATH="${DYLD_LIBRARY_PATH}:${COINGLHOME}/Darwin:${COINXTHOME}/Darwin"
  #export XENVIRONMENT visTutor/g4Xt.xrm
#  export DYLD_BIND_AT_LAUNCH 1
  #//////////////////////////////////////////////////////////
  # AIDA :
  #//////////////////////////////////////////////////////////
  #  export G4ANALYSIS_USE 1
  # OSC-dev implementation :
  #  source $HOME_BARRAND/OpenScientist/dev/setup.csh
  #  source $HOME_BARRAND/OpenScientist/dev/OnXLab/v1r0/cmt/setup.csh
  # Set AIDA compile and link access :
  #  export G4ANALYSIS_AIDA_CONFIG_CFLAGS `aida-config --cflags`
  #  export G4ANALYSIS_AIDA_CONFIG_LIBS `aida-config --libs`
  # Set PYTHONPATH to access local scripts :
  #  export PYTHONPATH ${PYTHONPATH}:.
#
  # OSC-15 implementation :
  #   source /barrand/OpenScientist/v15r0/aida-setup.csh
  # Set AIDA compile and link access :
  #  export G4ANALYSIS_AIDA_CONFIG_CFLAGS `aida-config --cflags`
  #  export G4ANALYSIS_AIDA_CONFIG_LIBS `aida-config --libs`
  # Set PYTHONPATH to access local scripts :
  #  export PYTHONPATH ${PYTHONPATH}:.
  #