//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4EmProcessSubType.hh,v 1.9 2008/12/18 13:01:42 gunter Exp $
// GEANT4 tag $Name: geant4-09-03-cand-01 $
//
//---------------------------------------------------------------
//
// G4EmProcessSubType.hh
//
// Class Description:
//   This is an enumerator to define sub-type of electro-magnetic
//   processes
//
// Creation date: 23.09.2008
// Modifications:
//
//---------------------------------------------------------------

#ifndef G4EmProcessSubType_h
#define G4EmProcessSubType_h 1

enum G4EmProcessSubType 
{ 
  fCoulombScattering = 1, 
  fIonisation = 2, 
  fBremsstrahlung = 3, 
  fPairProdByCharged = 4,
  fAnnihilation = 5, 
  fAnnihilationToMuMu = 6,
  fAnnihilationToHadrons = 7,

  fMultipleScattering = 10, 
  
  fRayleigh = 11,
  fPhotoElectricEffect = 12,
  fComptonScattering = 13,
  fGammaConversion = 14,
  fGammaConversionToMuMu = 15,
 
  fCerenkov = 21,
  fScintillation = 22,
  fSynchrotronRadiation = 23,
  fTransitionRadiation = 24  
};

#endif
