//
// ********************************************************************
// * DISCLAIMER                                                       *
// *                                                                  *
// * The following disclaimer summarizes all the specific disclaimers *
// * of contributors to this software. The specific disclaimers,which *
// * govern, are listed with their locations in:                      *
// *   http://cern.ch/geant4/license                                  *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.                                                             *
// *                                                                  *
// * This  code  implementation is the  intellectual property  of the *
// * GEANT4 collaboration.                                            *
// * By copying,  distributing  or modifying the Program (or any work *
// * based  on  the Program)  you indicate  your  acceptance of  this *
// * statement, and all its terms.                                    *
// ********************************************************************
//
// The code was written by :
//	^Claudio Andenna claudio.andenna@iss.infn.it, claudio.andenna@ispesl.it
//      *Barbara Caccia barbara.caccia@iss.it
//      with the support of Pablo Cirrone (LNS, INFN Catania Italy)
//
// ^ISPESL and INFN Roma, gruppo collegato Sanità, Italy
// *Istituto Superiore di Sanità and INFN Roma, gruppo collegato Sanità, Italy
//  Viale Regina Elena 299, 00161 Roma (Italy)
//  tel (39) 06 49902246
//  fax (39) 06 49387075
//
// more information:
// http://g4advancedexamples.lngs.infn.it/Examples/medical-linac
//
//*******************************************************//


#ifndef ML2PrimaryGenerationActionMessengerH
#define ML2PrimaryGenerationActionMessengerH


#include "globals.hh"
#include "G4UImessenger.hh"

class CML2PrimaryGenerationAction;
class G4UImessenger;
class G4UIcmdWithAnInteger;
class G4UIcmdWithAString;
class G4UIcmdWithADoubleAndUnit;

class CML2PrimaryGenerationActionMessenger : public G4UImessenger 
{
public:
	CML2PrimaryGenerationActionMessenger(CML2PrimaryGenerationAction *PML2PrimaryGenerationAction);
	~CML2PrimaryGenerationActionMessenger(void);
	void SetNewValue(G4UIcommand* cmd, G4String newValue);

private:
	CML2PrimaryGenerationAction *pML2PrimaryGenerationAction;

	G4UIcmdWithAnInteger *nIdenticalParticles, *nLoopsPhSpParticles;
	G4UIcmdWithAnInteger *nMaxParticlesInRamPhaseSpace;
	G4UIcmdWithADoubleAndUnit *GunMeanEnegy, *GunStdEnegy, *GunRadious;
	G4UIcmdWithAString  *calculatedPhaseSpaceFileIN, *sourceTypeName;
	G4UIcmdWithADoubleAndUnit *rotationX,  *rotationY,  *rotationZ;
};

#endif

