//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// $Id: SteppingMessenger.cc,v 1.2 2006/06/29 16:46:03 gunter Exp $
// GEANT4 tag $Name: geant4-09-03-cand-01 $
// 
//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......
//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

#include "SteppingMessenger.hh"

#include "SteppingAction.hh"

#include "G4UIdirectory.hh"
#include "G4UIcmdWithADouble.hh"

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

SteppingMessenger::SteppingMessenger(SteppingAction* StpAct)
:stepAction(StpAct)
{ 
  stepDir = new G4UIdirectory("/testem/step/");
  stepDir ->SetGuidance("stepping action control");
      
  destepCmd = new G4UIcmdWithADouble("/testem/step/maxEdepForPlot",this);
  destepCmd->SetGuidance("Set max fraction of edep for plotting final state");
  destepCmd->SetParameterName("fract",false);
  destepCmd->SetRange("fract>0.&&fract<=1.");  
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

SteppingMessenger::~SteppingMessenger()
{
  delete destepCmd;
  delete stepDir;   
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

void SteppingMessenger::SetNewValue(G4UIcommand* command, G4String newValue)
{ 
  if (command == destepCmd)
    {stepAction->SetMaxEdepForPlot(destepCmd->GetNewDoubleValue(newValue));}
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......
