//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//

#include "G4CascadeSigmaZeroPChannel.hh"

namespace {
  // Outgoing particle types of a given multiplicity

  static const G4int s0p2bfs[3][2] =
    {{1, 25}, {1,21}, {2,23}};

  static const G4int s0p3bfs[12][3] =
    {{1,1,13}, {1,2,17}, {1,7,25}, {2,3,25},  {1,5,23},  {2,7,23},
     {1,7,21}, {2,3,21}, {1,3,27}, {1,15,29}, {2,11,29}, {1,11,31}};  

  static const G4int s0p4bfs[33][4] =
    {{1,1,7,13},   {1,1,5,17},   {1,2,7,17},   {1,2,3,13},   {2,2,3,17},
     {1,7,7,25},   {1,3,5,25},   {2,3,7,25},   {1,15,17,25}, {1,11,13,25},
     {2,11,17,25}, {1,5,7,23},   {2,7,7,23},   {2,3,5,23},   {1,13,15,23},
     {2,15,17,23}, {2,11,13,23}, {1,7,7,21},   {1,3,5,21},   {2,3,7,21},
     {1,15,17,21}, {1,11,13,21}, {2,11,17,21}, {1,3,7,27},   {2,3,3,27},
     {1,11,17,27}, {1,7,15,29},  {2,3,15,29},  {2,7,11,29},  {1,5,11,29},
     {1,7,11,31},  {1,3,15,31},  {2,3,11,31}};       

  static const G4int s0p5bfs[59][5] =
    {{1,1,7,7,13},   {1,1,3,5,13},   {1,1,5,7,17},   {1,2,7,7,17},
     {1,2,3,5,17},   {1,2,3,7,13},   {2,2,3,7,17},   {2,2,3,3,13},
     {1,7,7,7,25},   {1,3,5,7,25},   {2,3,7,7,25},   {2,3,3,5,25},
     {1,7,15,17,25}, {1,3,13,15,25}, {1,7,11,13,25}, {1,5,11,17,25},     
     {2,7,11,17,25}, {2,3,11,13,25}, {2,3,15,17,25}, {1,5,7,7,23}, 
     {1,3,5,5,23},   {2,7,7,7,23},   {2,3,5,7,23},   {1,5,15,17,23}, 
     {1,7,13,15,23}, {1,5,11,13,23}, {2,7,15,17,23}, {2,3,13,15,23}, 
     {2,5,11,17,23}, {2,7,11,13,23}, {1,7,7,7,21},   {1,3,5,7,21},
     {2,3,7,7,21},   {2,3,3,5,21},   {1,7,15,17,21}, {1,3,13,15,21},
     {1,7,11,13,21}, {1,5,11,17,21}, {2,7,11,17,21}, {2,3,11,13,21},
     {2,3,15,17,21}, {1,3,7,7,27},   {1,3,3,5,27},   {2,3,3,7,27},
     {1,7,11,17,27}, {1,3,11,13,27}, {1,3,15,17,27}, {2,3,11,17,27},
     {1,7,7,15,29},  {1,3,5,15,29},  {2,3,7,15,29},  {2,7,7,11,29},
     {2,3,5,11,29},  {1,5,7,11,29},  {1,7,7,11,31},  {1,3,5,11,31},
     {1,3,7,15,31},  {2,3,7,11,31},  {2,3,3,15,31}};

  static const G4int s0p6bfs[30][6] =
    {{1,1,7,7,7,13},   {1,1,3,5,7,13},   {1,1,5,7,7,17},
     {1,1,3,5,5,17},   {1,2,7,7,7,17},   {1,2,3,5,7,17},
     {1,2,3,7,7,13},   {1,2,3,3,5,13},   {2,2,3,7,7,17},
     {2,2,3,3,5,17},   {2,2,3,3,7,13},   {1,7,7,7,7,25},
     {1,3,5,7,7,25},   {1,3,3,5,5,25},   {2,3,7,7,7,25},
     {2,3,3,5,7,25},   {1,5,7,7,7,23},   {1,3,5,5,7,23},
     {2,7,7,7,7,23},   {2,3,5,7,7,23},   {2,3,3,5,5,23},
     {1,7,7,7,7,21},   {1,3,5,7,7,21},   {1,3,3,5,5,21}, 
     {2,3,7,7,7,21},   {2,3,3,5,7,21},   {1,3,7,7,7,27}, 
     {1,3,3,5,7,27},   {2,3,3,7,7,27},   {2,3,3,3,5,27}};

  static const G4int s0p7bfs[20][7] =
    {{1,1,7,7,7,7,13},  {1,1,3,5,7,7,13},  {1,1,3,3,5,5,13}, 
     {1,1,5,7,7,7,17},  {1,1,3,5,5,7,17},  {1,2,7,7,7,7,17},
     {1,2,3,5,7,7,17},  {1,2,3,3,5,5,17},  {1,2,3,7,7,7,13}, 
     {1,2,3,3,5,7,13},  {2,2,3,7,7,7,17},  {2,2,3,3,5,7,17},
     {2,2,3,3,7,7,13},  {2,2,3,3,3,5,13},  {1,7,7,7,7,7,25},
     {1,3,5,7,7,7,25},  {1,3,3,5,5,7,25},  {2,3,7,7,7,7,25},
     {2,3,3,5,7,7,25},  {2,3,3,3,5,5,25}}; 

  // Cross sections for L p -> 2-7 body final states
  // 
  // first index:    0-2: channels for mult = 2
  //                3-14: channels for mult = 3 
  //               15-47: channels for mult = 4
  //              48-106: channels for mult = 5
  //             107-136: channels for mult = 6
  //             137-156: channels for mult = 7
  //
  // second index: kinetic energy
  // 
  static const G4double s0pCrossSections[157][31] = {
    //
    // multiplicity 2 (3 channels)
    //
    // S0 p
    {300.0,45.37,12.35,12.93,14.02,15.11,16.20,17.28,18.05,18.18,
     18.32,17.82,15.53,13.38,11.69,10.12, 9.14, 8.50, 8.10, 7.70,
     7.40, 7.10, 6.90, 6.70, 6.40, 6.10, 6.00, 5.90, 5.77, 5.65, 4.70},

    // L p
    { 0.0,  0.0,  0.0,  0.69, 1.48, 2.28, 3.08, 3.87, 4.38, 4.33,
      4.27, 4.00, 3.27, 2.07, 1.02, 0.35, 0.11, 0.05, 0.01, 0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},
 
    // S+ n
    { 0.0,  0.0,  0.0,  0.69, 1.48, 2.28, 3.08, 3.87, 4.38, 4.33,
      4.27, 4.00, 3.27, 2.07, 1.02, 0.35, 0.11, 0.05, 0.01, 0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},

    //
    //  multiplicity 3 (12 channels)
    //
    // p p K-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.06, 0.69, 1.22, 1.04, 0.77, 0.57, 0.45, 0.35, 0.24,
      0.21, 0.19, 0.18, 0.17, 0.16, 0.14, 0.12, 0.10, 0.09, 0.08, 0.01},
 
    // n p K0bar
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.06, 0.69, 1.22, 1.04, 0.77, 0.57, 0.45, 0.35, 0.24,
      0.21, 0.19, 0.18, 0.17, 0.16, 0.14, 0.12, 0.10, 0.09, 0.08, 0.01},
 
    // S0 p pi0
    { 0.0,  0.0,  0.0,  0.23, 0.51, 0.78, 1.05, 1.32, 1.57, 1.77,
      1.97, 4.06, 4.21, 3.03, 1.82, 0.96, 0.57, 0.42, 0.27, 0.19,
      0.17, 0.16, 0.15, 0.14, 0.13, 0.11, 0.09, 0.07, 0.06, 0.05, 0.0},
 
    // S0 n pi+
    { 0.0,  0.0,  0.0,  0.26, 0.57, 0.88, 1.19, 1.50, 1.78, 2.01,
      2.24, 3.64, 3.36, 2.42, 1.45, 0.80, 0.46, 0.33, 0.22, 0.15,
      0.13, 0.12, 0.11, 0.10, 0.09, 0.07, 0.06, 0.04, 0.04, 0.03, 0.0},

    // S+ p pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.07, 0.18, 0.15, 0.09, 0.06, 0.04, 0.03, 0.02,
      0.01, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},
 
    // S+ n pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.07, 0.18, 0.15, 0.09, 0.06, 0.04, 0.03, 0.02,
      0.01, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},
 
    // L p pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.95, 0.98, 0.60, 0.33, 0.18, 0.14, 0.09, 0.06,
      0.05, 0.05, 0.04, 0.04, 0.04, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01},
 
    // L n pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.04,
      0.06, 0.32, 0.84, 0.77, 0.48, 0.27, 0.15, 0.11, 0.07, 0.05,
      0.04, 0.04, 0.03, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01},
 
    // S- p pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.07, 0.18, 0.15, 0.09, 0.06, 0.04, 0.03, 0.02,
      0.01, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},
 
    // X0 p K0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.02, 0.02,
      0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},
 
    // X0 n K+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.02, 0.02,
      0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},
 
    // X- p K+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.02, 0.02,
      0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},

    //
    //  multiplicity 4 (33 channels)
    //
    // p p K- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.05, 0.18, 0.34, 0.47, 0.59, 0.77, 1.00, 1.15,
      1.10, 1.00, 0.90, 0.81, 0.73, 0.66, 0.59, 0.53, 0.51, 0.49, 0.31},
 
    // p p K0bar pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.05, 0.18, 0.34, 0.47, 0.59, 0.77, 1.00, 1.15,
      1.10, 1.00, 0.90, 0.81, 0.73, 0.66, 0.59, 0.53, 0.51, 0.49, 0.31},
 
    // n p K0bar pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.05, 0.18, 0.34, 0.47, 0.59, 0.77, 1.00, 1.15,
      1.10, 1.00, 0.90, 0.81, 0.73, 0.66, 0.59, 0.53, 0.51, 0.49, 0.31},
 
    // n p K- pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.05, 0.18, 0.34, 0.47, 0.59, 0.77, 1.00, 1.15,
      1.10, 1.00, 0.90, 0.81, 0.73, 0.66, 0.59, 0.53, 0.51, 0.49, 0.31},
 
    // n n K0bar pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.05, 0.18, 0.34, 0.47, 0.59, 0.77, 1.00, 1.15,
      1.10, 1.00, 0.90, 0.81, 0.73, 0.66, 0.59, 0.53, 0.51, 0.49, 0.31},
 
    // S0 p 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.01, 0.12, 0.36, 1.13, 1.97, 2.74, 2.59, 2.07, 1.56, 1.54, 
      1.51, 1.49, 1.46, 1.68, 1.89, 1.95, 1.98, 2.02, 2.02, 2.02, 2.04},
 
    // S0 p pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01,
      0.02, 0.20, 0.59, 1.59, 3.24, 4.96, 4.33, 3.45, 2.60, 2.56,
      2.52, 2.48, 2.44, 2.40, 2.36, 2.32, 2.28, 2.24, 2.22, 2.20, 2.04},
 
    // S0 n pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.20, 0.59, 1.67, 2.86, 3.64, 4.08, 4.17, 4.00, 3.50,
      3.32, 3.20, 3.00, 2.80, 2.60, 2.40, 2.20, 2.00, 1.89, 1.79, 1.00},
 
    // S0 p K0 K0bar
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.04, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01},
 
    // S0 p K+ K-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.04, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01},
 
    // S0 n K+ K0bar
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.04, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01},

    // S+ p pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.01, 0.04, 0.16, 0.29, 0.35, 0.43, 0.38, 0.33,
      0.27, 0.22, 0.19, 0.16, 0.14, 0.12, 0.10, 0.08, 0.07, 0.07, 0.01},
 
    // S+ n 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.01, 0.03, 0.10, 0.17, 0.24, 0.26, 0.23, 0.20,
      0.16, 0.13, 0.11, 0.11, 0.11, 0.10, 0.09, 0.07, 0.07, 0.06, 0.0},
 
    // S+ n pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.01, 0.04, 0.16, 0.29, 0.35, 0.43, 0.38, 0.33,
      0.27, 0.22, 0.19, 0.16, 0.14, 0.12, 0.10, 0.08, 0.07, 0.07, 0.01},

    // S+ p K- K0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03,
      0.04, 0.04, 0.03, 0.03, 0.02, 0.02, 0.01, 0.01, 0.01, 0.0,  0.0},
 
    // S+ n K0bar K0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03,
      0.04, 0.04, 0.03, 0.03, 0.02, 0.02, 0.01, 0.01, 0.01, 0.0,  0.0},
 
    // S+ n K+ K-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03,
      0.04, 0.04, 0.03, 0.03, 0.02, 0.02, 0.01, 0.01, 0.01, 0.0,  0.0},

    // L p 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.04, 0.21, 0.40, 0.77, 0.86, 0.80, 0.75, 0.68,
      0.67, 0.54, 0.51, 0.56, 0.60, 0.59, 0.52, 0.45, 0.40, 0.36, 0.10},
 
    // L p pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.01, 0.08, 0.34, 0.66, 1.28, 1.43, 1.33, 1.25, 1.15,
      1.12, 0.90, 0.85, 0.80, 0.75, 0.70, 0.60, 0.50, 0.44, 0.39, 0.10},
 
    // L n pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.01, 0.08, 0.34, 0.66, 1.01, 1.22, 1.39, 1.30, 1.20,
      1.10, 1.05, 1.00, 0.95, 0.85, 0.75, 0.65, 0.55, 0.51, 0.47, 0.15},
 
    // L p K0 K0bar
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.03, 0.03, 0.02, 0.02, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0},
 
    // L p K+ K-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.03, 0.03, 0.02, 0.02, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0},
 
    // L n K+ K0bar
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.03, 0.03, 0.02, 0.02, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0},

    // S- p pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.01, 0.03, 0.13, 0.29, 0.30, 0.32, 0.32, 0.28,
      0.26, 0.24, 0.22, 0.19, 0.17, 0.15, 0.13, 0.11, 0.11, 0.10, 0.07},
 
    // S- n 2pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.01, 0.03, 0.13, 0.29, 0.30, 0.32, 0.32, 0.28, 
      0.26, 0.24, 0.22, 0.19, 0.17, 0.15, 0.13, 0.11, 0.11, 0.10, 0.07},
 
    // S- p K+ K0bar
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03,
      0.04, 0.04, 0.03, 0.03, 0.02, 0.02, 0.01, 0.01, 0.0,  0.0,  0.0},
 
    // X0 p K0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.03, 0.03, 0.02, 0.02, 0.01, 0.01, 0.0,  0.0,  0.0},
 
    // X0 n K0 pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.03, 0.03, 0.02, 0.02, 0.01, 0.01, 0.0,  0.0,  0.0},
 
    // X0 n K+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.03, 0.03, 0.02, 0.02, 0.01, 0.01, 0.0,  0.0,  0.0},

    // X0 p K+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.03, 0.03, 0.02, 0.02, 0.01, 0.01, 0.0,  0.0,  0.0},
 
    // X- p K+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.03, 0.03, 0.02, 0.02, 0.01, 0.01, 0.0,  0.0,  0.0},
 
    // X- p K0 pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.03, 0.03, 0.02, 0.02, 0.01, 0.01, 0.0,  0.0,  0.0},
 
    // X- n K+ pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.03, 0.03, 0.02, 0.02, 0.01, 0.01, 0.0,  0.0,  0.0},

    //
    //  multiplicity 5 (59 channels)
    // 
    // 
    // p p K- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.03, 0.05, 0.07, 0.09, 0.12, 0.13,
      0.14, 0.16, 0.18, 0.22, 0.26, 0.28, 0.29, 0.31, 0.31, 0.31, 0.30},
 
    // p p K- pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.02, 0.05, 0.08, 0.12, 0.15, 0.20, 0.22,
      0.24, 0.26, 0.30, 0.32, 0.32, 0.33, 0.33, 0.34, 0.34, 0.34, 0.30},
 
    // p p K0bar pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.02, 0.05, 0.08, 0.12, 0.15, 0.20, 0.22,
      0.24, 0.26, 0.30, 0.32, 0.32, 0.33, 0.33, 0.34, 0.34, 0.34, 0.30},
 
    // n p K0bar 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.03, 0.05, 0.07, 0.09, 0.12, 0.13,
      0.14, 0.16, 0.18, 0.22, 0.26, 0.28, 0.29, 0.31, 0.31, 0.31, 0.30},
 
    // n p K0bar pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.02, 0.05, 0.08, 0.12, 0.15, 0.20, 0.22,
      0.24, 0.26, 0.30, 0.32, 0.32, 0.33, 0.33, 0.34, 0.34, 0.34, 0.30},
 
    // n p K- pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.02, 0.05, 0.08, 0.12, 0.15, 0.20, 0.22,
      0.24, 0.26, 0.30, 0.32, 0.32, 0.33, 0.33, 0.34, 0.34, 0.34, 0.30},
  
    // n n K0bar pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.02, 0.05, 0.08, 0.12, 0.15, 0.20, 0.22,
      0.24, 0.26, 0.30, 0.32, 0.32, 0.33, 0.33, 0.34, 0.34, 0.34, 0.30},
 
    // n n K- 2pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.02, 0.05, 0.08, 0.12, 0.15, 0.20, 0.22,
      0.24, 0.26, 0.30, 0.32, 0.32, 0.33, 0.33, 0.34, 0.34, 0.34, 0.30},

    // S0 p 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.02, 0.08, 0.14, 0.20, 0.22, 0.26, 0.32, 0.34,
      0.36, 0.37, 0.37, 0.42, 0.46, 0.49, 0.50, 0.50, 0.50, 0.51, 0.50},
 
    // S0 p pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.04, 0.13, 0.24, 0.31, 0.37, 0.43, 0.53, 0.57,
      0.60, 0.62, 0.62, 0.60, 0.58, 0.58, 0.57, 0.56, 0.56, 0.56, 0.50},
 
    // S0 n pi+ 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.02, 0.08, 0.14, 0.20, 0.22, 0.26, 0.32, 0.34,
      0.36, 0.37, 0.37, 0.42, 0.46, 0.49, 0.50, 0.50, 0.50, 0.51, 0.50},
 
    // S0 n 2pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.04, 0.13, 0.24, 0.31, 0.37, 0.43, 0.53, 0.57,
      0.60, 0.62, 0.62, 0.60, 0.58, 0.58, 0.57, 0.56, 0.56, 0.56, 0.50},
 
    // S0 p K0 K0bar pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},
  
    // S0 p K0 K- pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},
 
    // S0 p K+ K- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},

    // S0 p K+ K0bar pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},
 
    // S0 n K+ K0bar pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},
 
    // S0 n K+ K- pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},
 
    // S0 n K0 K0bar pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},

    // S+ p pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02, 0.02, 0.03, 0.04,
      0.04, 0.05, 0.05, 0.06, 0.06, 0.07, 0.06, 0.06, 0.06, 0.07, 0.06},
 
    // S+ p pi+ 2pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.03, 0.04, 0.05, 0.06,
      0.07, 0.08, 0.09, 0.09, 0.08, 0.08, 0.07, 0.07, 0.07, 0.07, 0.06},
 
    // S+ n 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02, 0.02, 0.03, 0.04,
      0.04, 0.05, 0.05, 0.06, 0.06, 0.07, 0.06, 0.06, 0.06, 0.07, 0.06},
 
    // S+ n pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.03, 0.04, 0.05, 0.06,
      0.07, 0.08, 0.09, 0.09, 0.08, 0.08, 0.07, 0.07, 0.07, 0.07, 0.06}, 

    // S+ p K0 K0bar pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01,
      0.02, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0},
 
    // S+ p K0 K- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01,
      0.02, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0},
 
    // S+ p K+ K- pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01,
      0.02, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0},
 
    // S+ n K0 K0bar pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01,
      0.02, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0},
 
    // S+ n K0 K- pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01,
      0.02, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0},
 
    // S+ n K+ K0bar pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01,
      0.02, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0},
 
    // S+ n K+ K- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01,
      0.02, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0},

    // L p 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.02, 0.05, 0.07, 0.07, 0.09, 0.10, 0.12,
      0.13, 0.14, 0.16, 0.20, 0.21, 0.20, 0.19, 0.18, 0.17, 0.17, 0.14},

    // L p pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.04, 0.08, 0.11, 0.12, 0.14, 0.18, 0.20,
      0.22, 0.24, 0.26, 0.28, 0.26, 0.24, 0.22, 0.20, 0.19, 0.18, 0.14},
 
    // L n pi+ 2pi0 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.02, 0.05, 0.07, 0.07, 0.09, 0.10, 0.12,
      0.13, 0.14, 0.16, 0.20, 0.21, 0.20, 0.19, 0.18, 0.17, 0.17, 0.14},

    // L n 2pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.04, 0.08, 0.11, 0.12, 0.14, 0.18, 0.20,
      0.22, 0.24, 0.26, 0.28, 0.26, 0.24, 0.22, 0.20, 0.19, 0.18, 0.14},
 
    // L p K0 K0bar pi0 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},
 
    // L p K0 K- pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},
 
    // L p K+ K- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},
 
    // L p K+ K0bar pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},

    // L n K+ K0bar pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},
 
    // L n K+ K- pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},
 
    // L n K0 K0bar pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},

    // S- p pi+ 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02, 0.02, 0.03, 0.04,
      0.04, 0.05, 0.05, 0.06, 0.06, 0.07, 0.06, 0.06, 0.06, 0.07, 0.06},
 
    // S- p 2pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.03, 0.04, 0.05, 0.06,
      0.07, 0.08, 0.09, 0.09, 0.08, 0.08, 0.07, 0.07, 0.07, 0.07, 0.06},
 
    // S- n 2pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.03, 0.04, 0.05, 0.06,
      0.07, 0.08, 0.09, 0.09, 0.08, 0.08, 0.07, 0.07, 0.07, 0.07, 0.06},
 
    // S- p K+ K0bar pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},

    // S- p K+ K- pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},
 
    // S- p K0 K0bar pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},

    // S- n K+ K0bar pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02,
      0.02, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01}, 

    // X0 p K0 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.01, 
      0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},
 
    // X0 p K0 pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03, 
      0.02, 0.02, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},
 
    // X0 n K0 pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03, 
      0.02, 0.02, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},
 
    // X0 n K+ 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.01, 
      0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},
 
    // X0 n K+ pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03, 
      0.02, 0.02, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},
 
    // X0 p K+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03, 
      0.02, 0.02, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},
 
    // X- p K+ 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.01, 
      0.01, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},
 
    // X- p K+ pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03, 
      0.02, 0.02, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},
 
    // X- p K0 pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03, 
      0.02, 0.02, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},
 
    // X- n K+ pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03, 
      0.02, 0.02, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},

    // X- n K0 2pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03, 
      0.02, 0.02, 0.01, 0.01, 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0},

    //
    //  multiplicity 6 (30 channels)
    // 
    // p p K- 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.04, 0.05, 0.06,
      0.08, 0.10, 0.12, 0.15, 0.19, 0.22, 0.24, 0.26, 0.26, 0.26, 0.25},

    // p p K- pi+ pi- pi0    
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.04, 0.06, 0.08, 0.10,
      0.13, 0.16, 0.19, 0.22, 0.24, 0.26, 0.28, 0.29, 0.29, 0.28, 0.25},

    // p p K0bar pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.04, 0.05, 0.06,
      0.08, 0.10, 0.12, 0.15, 0.19, 0.22, 0.24, 0.26, 0.26, 0.26, 0.25},

    // p p K0bar pi+ 2pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.04, 0.06, 0.08, 0.10,
      0.13, 0.16, 0.19, 0.22, 0.24, 0.26, 0.28, 0.29, 0.29, 0.28, 0.25},

    // n p K0bar 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.04, 0.05, 0.06,
      0.08, 0.10, 0.12, 0.15, 0.19, 0.22, 0.24, 0.26, 0.26, 0.26, 0.25},

    // n p K0bar pi+ pi- pi0 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.04, 0.06, 0.08, 0.10,
      0.13, 0.16, 0.19, 0.22, 0.24, 0.26, 0.28, 0.29, 0.29, 0.28, 0.25},

    // n p K- pi+ 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.04, 0.05, 0.06,
      0.08, 0.10, 0.12, 0.15, 0.19, 0.22, 0.24, 0.26, 0.26, 0.26, 0.25},

    // n p K- 2pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.04, 0.06, 0.08, 0.10,
      0.13, 0.16, 0.19, 0.22, 0.24, 0.26, 0.28, 0.29, 0.29, 0.28, 0.25},

    // n n K0bar pi+ 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.04, 0.05, 0.06,
      0.08, 0.10, 0.12, 0.15, 0.19, 0.22, 0.24, 0.26, 0.26, 0.26, 0.25},

    // n n K0bar 2pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.04, 0.06, 0.08, 0.10,
      0.13, 0.16, 0.19, 0.22, 0.24, 0.26, 0.28, 0.29, 0.29, 0.28, 0.25},

    // n n K- 2pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.04, 0.05, 0.06, 0.07,
      0.09, 0.12, 0.15, 0.18, 0.20, 0.22, 0.23, 0.24, 0.24, 0.23, 0.20},

    // S0 p 4pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.04, 0.04, 0.05, 0.06, 0.07, 0.08,
      0.08, 0.10, 0.10, 0.15, 0.20, 0.23, 0.25, 0.28, 0.28, 0.28, 0.30},

    // S0 p pi+ pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.02, 0.06, 0.07, 0.08, 0.10, 0.11, 0.13,
      0.15, 0.16, 0.17, 0.21, 0.25, 0.27, 0.28, 0.31, 0.31, 0.30, 0.30},

    // S0 p 2pi+ 2pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.04, 0.09, 0.12, 0.14, 0.16, 0.19, 0.22,
      0.25, 0.27, 0.29, 0.30, 0.31, 0.32, 0.33, 0.34, 0.34, 0.33, 0.30},

    // S0 n pi+ 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.02, 0.06, 0.07, 0.08, 0.10, 0.11, 0.13,
      0.15, 0.16, 0.17, 0.21, 0.25, 0.27, 0.28, 0.31, 0.31, 0.30, 0.30},

    // S0 n 2pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.04, 0.09, 0.12, 0.14, 0.16, 0.19, 0.22,
      0.25, 0.27, 0.29, 0.30, 0.31, 0.32, 0.33, 0.34, 0.34, 0.33, 0.30},

    // S+ p pi- 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.01, 0.01, 0.02, 0.02,
      0.02, 0.03, 0.02, 0.03, 0.04, 0.04, 0.04, 0.02, 0.02, 0.03, 0.02},

    // S+ p pi+ 2pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.04, 0.04, 0.03, 0.02},

    // S+ n 4pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.01, 0.01, 0.01,
      0.01, 0.01, 0.01, 0.02, 0.03, 0.03, 0.04, 0.03, 0.03, 0.03, 0.0},

    // S+ n pi+ pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.01, 0.01, 0.02, 0.02,
      0.02, 0.02, 0.02, 0.03, 0.04, 0.04, 0.04, 0.04, 0.04, 0.03, 0.02},

    // S+ n 2pi+ 2pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.04, 0.04, 0.03, 0.02},

    // L p 4pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02,
      0.03, 0.03, 0.04, 0.05, 0.07, 0.08, 0.08, 0.09, 0.09, 0.10, 0.10},

    // L p pi+ pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03, 0.04, 0.04,
      0.05, 0.05, 0.06, 0.07, 0.09, 0.09, 0.10, 0.10, 0.10, 0.10, 0.10},

    // L p 2pi+ 2pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.03, 0.04, 0.05, 0.05, 0.06, 0.07,
      0.08, 0.09, 0.10, 0.10, 0.11, 0.11, 0.11, 0.11, 0.11, 0.11, 0.10},

    // L n pi+ 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03, 0.04, 0.04,
      0.05, 0.05, 0.06, 0.07, 0.09, 0.09, 0.10, 0.10, 0.10, 0.10, 0.10},

    // L n 2pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.03, 0.04, 0.05, 0.05, 0.06, 0.07,
      0.08, 0.09, 0.10, 0.10, 0.11, 0.11, 0.11, 0.11, 0.11, 0.11, 0.10},

    // S- p pi+ 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.01, 0.01, 0.02, 0.02,
      0.02, 0.02, 0.02, 0.03, 0.04, 0.04, 0.03, 0.04, 0.04, 0.03, 0.02},

    // S- p 2pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.04, 0.05, 0.05, 0.05, 0.04, 0.04, 0.04, 0.03, 0.02},

    // S- n 2pi+ 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.01, 0.01, 0.02, 0.02,
      0.02, 0.02, 0.02, 0.03, 0.04, 0.04, 0.03, 0.04, 0.04, 0.03, 0.02},

    // S- n 3pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.04, 0.05, 0.05, 0.05, 0.04, 0.04, 0.04, 0.03, 0.02},

    //
    //  multiplicity 7 (20 channels)
    // 
    // p p K- 4pi0    
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.0,  0.01, 0.02, 0.02,
      0.03, 0.04, 0.05, 0.07, 0.11, 0.14, 0.17, 0.21, 0.21, 0.22, 0.24},

    // p p K- pi+ pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04,
      0.05, 0.07, 0.08, 0.10, 0.14, 0.17, 0.20, 0.23, 0.23, 0.24, 0.24},

    // p p K- 2pi+ 2pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.05, 0.07,
      0.09, 0.11, 0.13, 0.15, 0.17, 0.20, 0.23, 0.26, 0.26, 0.26, 0.24},

    // p p K0bar pi- 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04,
      0.05, 0.07, 0.08, 0.10, 0.14, 0.17, 0.20, 0.23, 0.23, 0.24, 0.24},

    // p p K0bar pi+ 2pi- pi0 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.05, 0.07, 0.09,
      0.11, 0.13, 0.15, 0.17, 0.20, 0.23, 0.26, 0.26, 0.26, 0.25, 0.24},

    // n p K0bar 4pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02,
      0.03, 0.04, 0.05, 0.07, 0.11, 0.14, 0.17, 0.21, 0.21, 0.22, 0.24},

    // n p K0bar pi+ pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04,
      0.05, 0.07, 0.08, 0.10, 0.14, 0.17, 0.20, 0.23, 0.23, 0.24, 0.24},

    // n p K0bar 2pi+ 2pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.05, 0.07,
      0.09, 0.11, 0.13, 0.15, 0.17, 0.20, 0.23, 0.26, 0.26, 0.26, 0.24},

    // n p K- pi+ 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04,
      0.05, 0.07, 0.08, 0.10, 0.14, 0.17, 0.20, 0.23, 0.23, 0.24, 0.24},

    // n p K- 2pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.05, 0.07,
      0.09, 0.11, 0.13, 0.15, 0.17, 0.20, 0.23, 0.26, 0.26, 0.26, 0.24},

    // n n K0bar pi+ 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04,
      0.05, 0.07, 0.08, 0.10, 0.14, 0.17, 0.20, 0.23, 0.23, 0.24, 0.24},

    // n n K0bar 2pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.05, 0.07,
      0.09, 0.11, 0.13, 0.15, 0.17, 0.20, 0.23, 0.26, 0.26, 0.26, 0.24},

    // n n K- 2pi+ 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03, 0.04,
      0.05, 0.07, 0.08, 0.10, 0.14, 0.17, 0.20, 0.23, 0.23, 0.24, 0.24},

    // n n K- 3pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.05, 0.07,
      0.09, 0.11, 0.13, 0.15, 0.17, 0.20, 0.23, 0.26, 0.26, 0.26, 0.24},

    // S0 p 5pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.01, 0.02,
      0.02, 0.03, 0.04, 0.06, 0.07, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08},

    // S0 p pi+ pi- 3pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.02, 0.03,
      0.04, 0.05, 0.06, 0.08, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.08},

    // S0 p 2pi+ 2pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.03, 0.04, 0.05,
      0.06, 0.08, 0.10, 0.12, 0.11, 0.11, 0.10, 0.10, 0.10, 0.09, 0.08},

    // S0 n pi+ 4pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02,
      0.03, 0.04, 0.05, 0.07, 0.10, 0.12, 0.14, 0.14, 0.14, 0.14, 0.14},

    // S0 n 2pi+ pi- 2pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.04,
      0.05, 0.07, 0.08, 0.10, 0.13, 0.14, 0.16, 0.16, 0.16, 0.15, 0.14},

    // S0 n 3pi+ 2pi- 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.02, 0.03, 0.03, 0.05, 0.07,
      0.09, 0.11, 0.13, 0.15, 0.16, 0.17, 0.18, 0.18, 0.18, 0.17, 0.14} };
}

G4CascadeSigmaZeroPChannelData::data_t
G4CascadeSigmaZeroPChannelData::data(s0p2bfs, s0p3bfs, s0p4bfs,
				     s0p5bfs, s0p6bfs, s0p7bfs,
				     s0pCrossSections);
