//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// FredPhysicsList
//
// Implementation of Physics for fred
//

#include "FredPhysicsList.hh"
#include "G4ParticleTypes.hh"

//
// Constructor
//
FredPhysicsList::FredPhysicsList(): G4VUserPhysicsList()
{
  defaultCutValue = 2.0*mm;
}



FredPhysicsList::~FredPhysicsList() {;}

//
// ConstructParticle: Define particles
//
void FredPhysicsList::ConstructParticle()
{
	// Particles are defined via static member functions

	G4Geantino::GeantinoDefinition();
	G4MuonMinus::MuonMinusDefinition();
}

//
// ConstructProcess: define processes
//
void FredPhysicsList::ConstructProcess()
{
	AddTransportation();
}

//
// SetCuts: define cuts
//
void FredPhysicsList::SetCuts()
{
	// From "novice" example 1

	// uppress error messages even in case e/gamma/proton do not exist            
	G4int temp = GetVerboseLevel();                                                SetVerboseLevel(0);                                                           
	//  " G4VUserPhysicsList::SetCutsWithDefault" method sets 
	//   the default cut value for all particle types 
	SetCutsWithDefault();   

	// Retrieve verbose level
	SetVerboseLevel(temp);  
	//  " G4VUserPhysicsList::SetCutsWithDefault" method sets 
	//   the default cut value for all particle types 
	SetCutsWithDefault();   
}
