//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4Na25GEMProbability.cc,v 1.5 2009/09/15 12:54:17 vnivanch Exp $
// GEANT4 tag $Name: geant4-09-04-beta-01 $
//
// Hadronic Process: Nuclear De-excitations
// by V. Lara (Nov 1999)
//


#include "G4Na25GEMProbability.hh"

G4Na25GEMProbability::G4Na25GEMProbability() :
  G4GEMProbability(25,11,5.0/2.0) // A,Z,Spin
{

    ExcitEnergies.push_back(89.53*keV);
    ExcitSpins.push_back(3.0/2.0);
    ExcitLifetimes.push_back(5.13e-3*picosecond);

    ExcitEnergies.push_back(1069.32*keV);
    ExcitSpins.push_back(1.0/2.0);
    ExcitLifetimes.push_back(1.6*picosecond);

    ExcitEnergies.push_back(2202.0*keV);
    ExcitSpins.push_back(3.0/2.0);
    ExcitLifetimes.push_back(17.0e-3*picosecond);

    ExcitEnergies.push_back(2417.0*keV);
    ExcitSpins.push_back(7.0/2.0);
    ExcitLifetimes.push_back(0.14*picosecond);

    ExcitEnergies.push_back(2788.0*keV);
    ExcitSpins.push_back(3.0/2.0);
    ExcitLifetimes.push_back(14.0e-3*picosecond);

    ExcitEnergies.push_back(2914.0*keV);
    ExcitSpins.push_back(3.0/2.0);
    ExcitLifetimes.push_back(14.0e-3*picosecond);

    ExcitEnergies.push_back(3687.0*keV);
    ExcitSpins.push_back(1.0/2.0);
    ExcitLifetimes.push_back(14.0e-3*picosecond);

    ExcitEnergies.push_back(3995.0*keV);
    ExcitSpins.push_back(1.0/2.0);
    ExcitLifetimes.push_back(14.0e-3*picosecond);

}


G4Na25GEMProbability::G4Na25GEMProbability(const G4Na25GEMProbability &) : G4GEMProbability()
{
  throw G4HadronicException(__FILE__, __LINE__, "G4Na25GEMProbability::copy_constructor meant to not be accessable");
}




const G4Na25GEMProbability & G4Na25GEMProbability::
operator=(const G4Na25GEMProbability &)
{
  throw G4HadronicException(__FILE__, __LINE__, "G4Na25GEMProbability::operator= meant to not be accessable");
  return *this;
}


G4bool G4Na25GEMProbability::operator==(const G4Na25GEMProbability &) const
{
  return false;
}

G4bool G4Na25GEMProbability::operator!=(const G4Na25GEMProbability &) const
{
  return true;
}



