//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4FissionProbability.hh,v 1.4 2010/11/17 20:22:46 vnivanch Exp $
// GEANT4 tag $Name: geant4-09-04-ref-00 $
//
// Hadronic Process: Nuclear De-excitations
// by V. Lara (Oct 1998) 
//



#ifndef G4FissionProbability_h
#define G4FissionProbability_h 1


#include "G4VEmissionProbability.hh"
#include "G4EvaporationLevelDensityParameter.hh"
#include "G4FissionLevelDensityParameter.hh"

class G4FissionProbability : public G4VEmissionProbability
{
public:
  // Default constructor
  G4FissionProbability();

  ~G4FissionProbability();  

private:  
  // Copy constructor
  G4FissionProbability(const G4FissionProbability &right);

  const G4FissionProbability & operator=(const G4FissionProbability &right);
  G4bool operator==(const G4FissionProbability &right) const;
  G4bool operator!=(const G4FissionProbability &right) const;
  
public:
  G4double EmissionProbability(const G4Fragment & fragment, G4double MaximalKineticEnergy);

private:
  G4EvaporationLevelDensityParameter theEvapLDP;
  G4FissionLevelDensityParameter theFissLDP;


};


#endif
