//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4UIQt.cc,v 1.14 2006/06/29 19:09:49 gunter Exp $
// GEANT4 tag $Name: geant4-08-01 $
//
// G.Barrand

//#define DEBUG

#ifdef G4UI_BUILD_QT_SESSION

#include "G4Types.hh"

#include <string.h>

#include "G4UIQt.hh"
#include "G4UImanager.hh"
#include "G4StateManager.hh"
#include "G4UIcommandTree.hh"
#include "G4UIcommandStatus.hh"

#include "G4Qt.hh"

#include <QtGui/qapplication.h>
#include <QtGui/qwidget.h>

#include <stdlib.h>

static G4bool ConvertStringToInt(const char*,int&);
//static void ExecuteChangeSizeFunction(Widget);

static G4bool exitSession = true;
static G4bool exitPause = true;
static G4bool exitHelp = true;
/***************************************************************************/
/**
 Build a Qt window with a menubar, output area and promt area 
      +-----------------------+
      |exit menu|             |
      |                       |
      | +-------------------+ |
      | |                   | |
      | |  Output area      | |
      | |                   | |
      | +-------------------+ |
      |                       |
      | +-------------------+ |
      | |> promt area       | |
      | +-------------------+ |
*/

G4UIQt::G4UIQt (
 int argc,
 char** argv
)
:shell(NULL)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  G4UImanager* UI = G4UImanager::GetUIpointer(); # TO KEEP
  if(UI!=NULL) UI->SetSession(this); # TO KEEP

  new QApplication (argc, argv);

  mainWindow = new QMainWindow(0,qApp->applicationDirPath () );

//  G4Qt* interactorManager = G4Qt::getInstance (argc,argv,(char*)"Qt");  # TO KEEP ?

//   Widget top = (Widget)interactorManager->GetMainInteractor();

//   if(getenv("XENVIRONMENT")==NULL) {
//     XrmDatabase database = XrmGetDatabase(XtDisplay(top));
//     if(database!=NULL) {
//       XrmPutLineResource(&database,"*topShadowColor:white");
//       XrmPutLineResource(&database,"*bottomShadowColor:black");
//       XrmPutLineResource(&database,"*foreground:black");
//       XrmPutLineResource(&database,"*background:lightgrey");
//       XrmPutLineResource(&database,"*borderColor:lightgrey");
//       XrmPutLineResource(&database,"*fontList:-*-helvetica-bold-r-*-*-*-120-*-*-*-*-iso8859-1");
//       XrmPutLineResource(&database,"*text.background:white");
//       XrmPutLineResource(&database,"*text.fontList:*courier*-r-*--14-*");
//       XrmPutLineResource(&database,"*text.maxLength:8000");
//     }
//   }

//   Arg args[9];
//   XtSetArg(args[0],XmNkeyboardFocusPolicy,XmPOINTER); // For completion.
//   shell = XtAppCreateShell ("G4UIXm","G4UIXm",
// 			    topLevelShellWidgetClass,XtDisplay(top),
// 			    args,1); 
//   form = XmCreateForm (shell,(char*)"form",NULL,0);
//   XtManageChild (form);

//   XtSetArg(args[0],XmNtopAttachment   ,XmATTACH_FORM);
//   XtSetArg(args[1],XmNleftAttachment  ,XmATTACH_FORM);
//   XtSetArg(args[2],XmNrightAttachment ,XmATTACH_FORM);
//   menuBar = XmCreateMenuBar (form,(char*)"menuBar",args,3);

//   XtSetArg(args[0],XmNtopAttachment      ,XmATTACH_NONE);
//   XtSetArg(args[1],XmNleftAttachment     ,XmATTACH_FORM);
//   XtSetArg(args[2],XmNrightAttachment    ,XmATTACH_FORM);
//   XtSetArg(args[3],XmNbottomAttachment   ,XmATTACH_FORM);
//   command = XmCreateCommand (form,(char*)"command",args,4);
//   XtManageChild (command);

//   XtSetArg(args[0],XmNtopAttachment   ,XmATTACH_NONE);
//   XtSetArg(args[1],XmNleftAttachment  ,XmATTACH_FORM);
//   XtSetArg(args[2],XmNrightAttachment ,XmATTACH_FORM);
//   XtSetArg(args[3],XmNbottomAttachment,XmATTACH_WIDGET);
//   XtSetArg(args[4],XmNbottomWidget    ,command);
//   XmString cps = XmStringLtoRCreate((char*)"Clear",XmSTRING_DEFAULT_CHARSET);
//   XtSetArg (args[5],XmNlabelString,cps);
//   Widget clearButton = XmCreatePushButton(form,(char*)"clearButton",args,6);
//   XmStringFree (cps);
//   XtManageChild (clearButton);

//   XtSetArg(args[0],XmNtopAttachment   ,XmATTACH_WIDGET);
//   XtSetArg(args[1],XmNtopWidget       ,menuBar);
//   XtSetArg(args[2],XmNleftAttachment  ,XmATTACH_FORM);
//   XtSetArg(args[3],XmNrightAttachment ,XmATTACH_FORM);
//   XtSetArg(args[4],XmNbottomAttachment,XmATTACH_WIDGET);
//   XtSetArg(args[5],XmNbottomWidget    ,clearButton);
//   XtSetArg(args[6],XmNeditMode        ,XmMULTI_LINE_EDIT);
//   XtSetArg(args[7],XmNrows            ,12);
//   XtSetArg(args[8],XmNcolumns         ,80);
//   text = XmCreateScrolledText (form,(char*)"text",args,9);
//   XtManageChild (text);

//   XtAddCallback(clearButton,XmNactivateCallback,
// 		clearButtonCallback,(XtPointer)text);
//   XtAddCallback(command,XmNcommandEnteredCallback,
// 		commandEnteredCallback,(XtPointer)this);

//   Widget commandText = XmCommandGetChild(command,XmDIALOG_COMMAND_TEXT);
//   XtAddEventHandler(commandText,KeyPressMask,False,keyHandler,(XtPointer)this);

//   XtRealizeWidget(shell);
//   XtMapWidget(shell);

  if(UI!=NULL) UI->SetCoutDestination(this);  # TO KEEP
}
/***************************************************************************/
G4UIQt::~G4UIQt(
) 
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{ 
  G4UImanager* UI = G4UImanager::GetUIpointer();  # TO KEEP
  if(UI!=NULL) {  # TO KEEP
    UI->SetSession(NULL);  # TO KEEP
    UI->SetCoutDestination(NULL);  # TO KEEP
  }
  XtDestroyWidget(shell);
}
/***************************************************************************/
/*
    Start the Qt main loop
 */
G4UIsession* G4UIQt::SessionStart (
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  frame->show();
  qApp->exec();

//   G4Qt* interactorManager = G4Qt::getInstance (); # TO KEEP ?
//   Prompt("session"); # TO KEEP
//   exitSession = false; # TO KEEP
//   interactorManager->DisableSecondaryLoop (); # TO KEEP
//   void* event; # TO KEEP
//   while((event = interactorManager->GetEvent())!=NULL) {  # TO KEEP
//     interactorManager->DispatchEvent(event); # TO KEEP
//     if(exitSession==true) break; # TO KEEP
//   } # TO KEEP
//   interactorManager->EnableSecondaryLoop (); # TO KEEP
  return this; # TO KEEP
}
/***************************************************************************/
/**
  Display the prompt in the prompt area
 */
void G4UIQt::Prompt (
 G4String aPrompt
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  Arg args[1];
  char* str = (char*)XtNewString(aPrompt.data());
  XmString cps = XmStringLtoRCreate(str,XmSTRING_DEFAULT_CHARSET);
  XtFree(str);
  XtSetArg(args[0],XmNpromptString,cps);
  XtSetValues(command,args,1);
  XmStringFree(cps);
}
/***************************************************************************/
void G4UIQt::SessionTerminate (
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
}
/***************************************************************************/
void G4UIQt::PauseSessionStart (
 G4String a_state
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  if(a_state=="G4_pause> ") {  # TO KEEP
    SecondaryLoop ("Pause, type continue to exit this state"); # TO KEEP
  } # TO KEEP

  if(a_state=="EndOfEvent") { # TO KEEP
    // Picking with feed back in event data Done here !!!
    SecondaryLoop ("End of event, type continue to exit this state"); # TO KEEP
  } # TO KEEP
}
/***************************************************************************/
void G4UIXm::SecondaryLoop (
 G4String a_prompt
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  G4Qt* interactorManager = G4Qt::getInstance (); # TO KEEP ?
  Prompt(a_prompt); # TO KEEP
  exitPause = false; # TO KEEP
  void* event; # TO KEEP
  while((event = interactorManager->GetEvent())!=NULL) {  # TO KEEP
    interactorManager->DispatchEvent(event); # TO KEEP
    if(exitPause==true) break; # TO KEEP
  } # TO KEEP
  Prompt("session"); # TO KEEP
}
/***************************************************************************/
/**
  Receive a cout from Geant4. We have to display it in the cout zone
 */
G4int G4UIXm::ReceiveG4cout (
 G4String a_string
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  XmTextAppendString(text,(char*)a_string.data());
  return 0;
}
/***************************************************************************/
/**
  Receive a cerr from Geant4. We have to display it in the cout zone
 */
G4int G4UIXm::ReceiveG4cerr (
 G4String a_string
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  XmTextAppendString(text,(char*)a_string.data());
  return 0;
}
/***************************************************************************/
G4bool G4UIXm::GetHelpChoice(
 G4int& aInt
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
//   fHelp = true; # TO KEEP
//   // SecondaryLoop : # TO KEEP
//   G4Qt* interactorManager = G4Qt::getInstance (); # TO KEEP ?
//   Prompt("Help"); # TO KEEP
//   exitHelp = false; # TO KEEP
//   void* event; # TO KEEP
//   while((event = interactorManager->GetEvent())!=NULL) {  # TO KEEP
//     interactorManager->DispatchEvent(event); # TO KEEP
//     if(exitHelp==true) break; # TO KEEP
//   } # TO KEEP
//   Prompt("session"); # TO KEEP
//   // # TO KEEP
//   if(fHelp==false) return false; # TO KEEP
//   aInt = fHelpChoice; # TO KEEP
//   fHelp = false; # TO KEEP
//   return true; # TO KEEP
}
/***************************************************************************/
void G4UIXm::ExitHelp(
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
}
/***************************************************************************/
void G4UIXm::AddMenu (
 const char* a_name
,const char* a_label
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
//   if(menuBar==NULL) return;
//   if(a_name==NULL) return;
//   if(a_label==NULL) return;
//   XtManageChild (menuBar);
//   // Pulldown menu :
//   Widget widget;
//   widget = XmCreatePulldownMenu (menuBar,(char*)a_name,NULL,0);
//   AddInteractor (a_name,(G4Interactor)widget);
//   // Cascade button :
//   Arg args[2];
//   XmString cps = XmStringLtoRCreate((char*)a_label,XmSTRING_DEFAULT_CHARSET);
//   XtSetArg (args[0],XmNlabelString,cps);
//   XtSetArg (args[1],XmNsubMenuId,widget);
//   widget = XmCreateCascadeButton (menuBar,(char*)a_name,args,2);
//   XmStringFree (cps);
//   XtManageChild (widget);
//   ExecuteChangeSizeFunction(form);
}
/***************************************************************************/
void G4UIXm::AddButton (
 const char* a_menu
,const char* a_label
,const char* a_command
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
//   if(a_menu==NULL) return; # TO KEEP
//   if(a_label==NULL) return; # TO KEEP
//   if(a_command==NULL) return; # TO KEEP
//   Widget parent = (Widget)GetInteractor(a_menu);
//   if(parent==NULL) return;
//   Widget widget = XmCreatePushButton(parent,(char*)a_label,NULL,0);
//   XtManageChild (widget);
//   XtAddCallback (widget,XmNactivateCallback,ButtonCallback,(XtPointer)this);
//   commands[widget] = a_command;
//}
// /***************************************************************************/
// G4String G4UIXm::GetCommand (
//  Widget a_widget
// )
// /***************************************************************************/
// /*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
// {
//   return commands[a_widget];
// }
/***************************************************************************/
/***************************************************************************/
/***************************************************************************/
/**
  Callback call when "enter" clicked on the prompt zone.
  Send the command to geant4
 */
void G4UIXm::commandEnteredCallback (
 Widget    a_widget
,XtPointer a_tag
,XtPointer a_data
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  G4UIQt*  This = (G4UIQt*)a_tag;

//   XmString cps  = ((XmCommandCallbackStruct*)a_data)->value;
//   char*    ss = XmConvertCompoundStringToString(cps,0);
//   G4String command (ss);
//   XtFree   (ss);

//   if(This->fHelp==true) {
//     exitHelp = true;
//     This->fHelp = ConvertStringToInt(command.data(),This->fHelpChoice);
//   } else {
//     This->ApplyShellCommand (command,exitSession,exitPause);
//   }

//   a_widget = NULL;
//   a_tag    = NULL;
}
// /***************************************************************************/
// void G4UIXm::keyHandler (
//  Widget a_widget
// ,XtPointer a_tag
// ,XEvent* a_event
// ,Boolean*
// )
// /***************************************************************************/
// /*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
// {
//   KeySym keySym;
//   XLookupString(&(a_event->xkey),NULL,0,&keySym,NULL);
//   if(keySym!=XK_Tab) return;
//   G4UIXm* This = (G4UIXm*)a_tag;
//   char* s = XmTextGetString(a_widget);
//   G4String ss = This->Complete(s);
//   XmTextSetString(a_widget,(char*)ss.data());
//   XtFree(s);
//   XmTextSetInsertionPosition(a_widget,XmTextGetLastPosition(a_widget));
//}
// /***************************************************************************/
// void clearButtonCallback (
//  Widget
// ,XtPointer a_tag
// ,XtPointer
// )
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
//   XmTextSetString((Widget)a_tag,(char*)"");
}
/***************************************************************************/
void G4UIXm::ButtonCallback (
 Widget a_widget
,XtPointer a_tag
,XtPointer
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
//   G4UIXm* This = (G4UIXm*)a_tag;
//   if(This->fHelp==true) return; // Disabled when in help.
//   G4String ss = This->GetCommand (a_widget);
//   //printf ("debug : execute:\n%s\n",ss.data());
//   This->ApplyShellCommand(ss,exitSession,exitPause);
}
/***************************************************************************/
/***************************************************************************/
/***************************************************************************/
// char* XmConvertCompoundStringToString (
//  XmString a_cps 
// ,int a_number 
// )
// /***************************************************************************/
// /*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
// {
//   if(a_cps==NULL) return NULL;
//   char* ss = NULL;
//   XmStringContext context;
//   XmStringInitContext(&context,a_cps);
//   int icount = 0;
//   Boolean Done = False;
//   while(Done==False) {  
//     char* text = NULL;
//     XmStringCharSet charset = NULL;
//     XmStringDirection direct;
//     Boolean sep;
//     if(XmStringGetNextSegment(context,&text,&charset,&direct,&sep)==True) {
//       XtFree(charset);
//       if(sep==True) Done = True;
//       if(icount==a_number) { 
// 	ss = text;
// 	break;
//       }
//       icount++;
//       XtFree(text);
//     }
//     else
//       Done = True;
//   }
//   XmStringFreeContext(context);
//   return ss;
}
// /***************************************************************************/
// void XmTextAppendString (
//  Widget This
// ,char* a_string
// )
// /***************************************************************************/
// /*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
// {
//   if(This==NULL) return;
//   if(!XtIsSubclass(This,xmTextWidgetClass)) return;
//   if(a_string==NULL) return;
//   XmTextPosition  lastpos = XmTextGetLastPosition(This);
//   XmTextReplace(This,lastpos,lastpos,a_string);
//   XmTextSetInsertionPosition(This,XmTextGetLastPosition(This));
// }
//////////////////////////////////////////////////////////////////////////////
G4bool ConvertStringToInt(
 const char* aString
,int& aInt
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  aInt = 0; # TO KEEP
  if(aString==NULL) return false; # TO KEEP
  char* s; # TO KEEP
  long value = strtol(aString,&s,10); # TO KEEP
  if(s==aString) return false; # TO KEEP
  aInt = value; # TO KEEP
  return true; # TO KEEP
}
#include <X11/IntrinsicP.h>
//////////////////////////////////////////////////////////////////////////////
// void ExecuteChangeSizeFunction (
//  Widget aWidget
// )
// //////////////////////////////////////////////////////////////////////////////
// //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
// {
//   if(aWidget==NULL) return;
//   if(aWidget->core.widget_class->core_class.resize==NULL) return;
//   (aWidget->core.widget_class->core_class.resize)(aWidget);
// }


#endif
