// TODO !

//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4UIQt.cc,v 1.14 2007/05/29 11:09:49 $
// GEANT4 tag $Name: geant4-08-01 $
//
// L. Garnier

//#define DEBUG

#ifdef G4UI_BUILD_QT_SESSION

#include "G4Types.hh"

#include <string.h>

#include "G4UIQt.hh"
#include "G4UImanager.hh"
#include "G4StateManager.hh"
#include "G4UIcommandTree.hh"
#include "G4UIcommandStatus.hh"

#include "G4Qt.hh"

#include <QtGui/qapplication.h>
#include <QtGui/qwidget.h>
#include <QtGui/qmenu.h>
#include <QtGui/qmenubar.h>
#include <QtGui/qboxlayout.h>
#include <QtGui/qpushbutton.h>
#include <QtGui/qlabel.h>
#include <QtGui/qsplitter.h>
#include <QtGui/qscrollbar.h>

#include <stdlib.h>

static G4bool ConvertStringToInt(const char*,int&);

static G4bool exitSession = true;
static G4bool exitPause = true;
static G4bool exitHelp = true;
/***************************************************************************/
/**
 Build a Qt window with a menubar, output area and promt area 
      +-----------------------+
      |exit menu|             |
      |                       |
      | +-------------------+ |
      | |                   | |
      | |  Output area      | |
      | |                   | |
      | +-------------------+ |
      |     | clear |         |
      | +-------------------+ |
      | |  promt history    | |
      | +-------------------+ |
      | +-------------------+ |
      | |> promt area       | |
      | +-------------------+ |
      +-----------------------+
*/

G4UIQt::G4UIQt (
 int argc,
 char** argv
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  G4Qt* interactorManager = G4Qt::getInstance ();
  G4UImanager* UI = G4UImanager::GetUIpointer(); // TO KEEP
  if(UI!=NULL) UI->SetSession(this); // TO KEEP

  fMainWindow = new QMainWindow();
  fMainWindow->setWindowTitle( "G4UI Session" ); 
  fMainWindow->resize(800,600); 

  QSplitter *splitter = new QSplitter(Qt::Vertical);
  fTextArea = new QTextEdit();
  QPushButton *clearButton = new QPushButton("clear");
  connect(clearButton, SIGNAL(clicked()), SLOT(clearButtonCallback()));

  fCommandHistoryArea = new QTextEdit();
  fCommandLabel = new QLabel();

  fCommandArea = new QLineEdit();
  fCommandArea->activateWindow();
  connect(fCommandArea, SIGNAL(returnPressed()), SLOT(commandEnteredCallback()));
  fCommandArea->setFocusPolicy ( Qt::StrongFocus );
  fCommandArea->setFocus(Qt::TabFocusReason);
  fTextArea->setReadOnly(true);
  fCommandHistoryArea->setReadOnly(true);

  
  QVBoxLayout *layoutSplitter = new QVBoxLayout;

  QWidget* topWidget = new QWidget();
  QVBoxLayout *layoutTop = new QVBoxLayout;

  QWidget* bottomWidget = new QWidget();
  QVBoxLayout *layoutBottom = new QVBoxLayout;


  layoutTop->addWidget(fTextArea);
  layoutTop->addWidget(clearButton);
  topWidget->setLayout(layoutTop);

  layoutBottom->addWidget(fCommandHistoryArea);
  layoutBottom->addWidget(fCommandLabel);
  layoutBottom->addWidget(fCommandArea);
  bottomWidget->setLayout(layoutBottom);


  layoutSplitter->addWidget(topWidget);
  layoutSplitter->addWidget(bottomWidget);
  splitter->setLayout(layoutSplitter);

  fMainWindow->setCentralWidget(splitter);

  QMenu *fileMenu = fMainWindow->menuBar()->addMenu("File");
  fileMenu->addAction("Quitter", fMainWindow, SLOT(close()));

//  QMainWindow top = (QMainWindow)interactorManager->GetMainInteractor();

//   if(getenv("XENVIRONMENT")==NULL) {
//     XrmDatabase database = XrmGetDatabase(XtDisplay(top));
//     if(database!=NULL) {
//       XrmPutLineResource(&database,"*topShadowColor:white");
//       XrmPutLineResource(&database,"*bottomShadowColor:black");
//       XrmPutLineResource(&database,"*foreground:black");
//       XrmPutLineResource(&database,"*background:lightgrey");
//       XrmPutLineResource(&database,"*borderColor:lightgrey");
//       XrmPutLineResource(&database,"*fontList:-*-helvetica-bold-r-*-*-*-120-*-*-*-*-iso8859-1");
//       XrmPutLineResource(&database,"*text.background:white");
//       XrmPutLineResource(&database,"*text.fontList:*courier*-r-*--14-*");
//       XrmPutLineResource(&database,"*text.maxLength:8000");
//     }
//   }

//   Arg args[9];
//   XtSetArg(args[0],XmNkeyboardFocusPolicy,XmPOINTER); // For completion.
//   shell = XtAppCreateShell ("G4UIXm","G4UIXm",
// 			    topLevelShellWidgetClass,XtDisplay(top),
// 			    args,1); 
//   form = XmCreateForm (shell,(char*)"form",NULL,0);
//   XtManageChild (form);

//   XtSetArg(args[0],XmNtopAttachment   ,XmATTACH_FORM);
//   XtSetArg(args[1],XmNleftAttachment  ,XmATTACH_FORM);
//   XtSetArg(args[2],XmNrightAttachment ,XmATTACH_FORM);
//   menuBar = XmCreateMenuBar (form,(char*)"menuBar",args,3);

//   XtSetArg(args[0],XmNtopAttachment      ,XmATTACH_NONE);
//   XtSetArg(args[1],XmNleftAttachment     ,XmATTACH_FORM);
//   XtSetArg(args[2],XmNrightAttachment    ,XmATTACH_FORM);
//   XtSetArg(args[3],XmNbottomAttachment   ,XmATTACH_FORM);
//   command = XmCreateCommand (form,(char*)"command",args,4);
//   XtManageChild (command);

//   XtSetArg(args[0],XmNtopAttachment   ,XmATTACH_NONE);
//   XtSetArg(args[1],XmNleftAttachment  ,XmATTACH_FORM);
//   XtSetArg(args[2],XmNrightAttachment ,XmATTACH_FORM);
//   XtSetArg(args[3],XmNbottomAttachment,XmATTACH_WIDGET);
//   XtSetArg(args[4],XmNbottomWidget    ,command);
//   XmString cps = XmStringLtoRCreate((char*)"Clear",XmSTRING_DEFAULT_CHARSET);
//   XtSetArg (args[5],XmNlabelString,cps);
//   Widget clearButton = XmCreatePushButton(form,(char*)"clearButton",args,6);
//   XmStringFree (cps);
//   XtManageChild (clearButton);

//   XtSetArg(args[0],XmNtopAttachment   ,XmATTACH_WIDGET);
//   XtSetArg(args[1],XmNtopWidget       ,menuBar);
//   XtSetArg(args[2],XmNleftAttachment  ,XmATTACH_FORM);
//   XtSetArg(args[3],XmNrightAttachment ,XmATTACH_FORM);
//   XtSetArg(args[4],XmNbottomAttachment,XmATTACH_WIDGET);
//   XtSetArg(args[5],XmNbottomWidget    ,clearButton);
//   XtSetArg(args[6],XmNeditMode        ,XmMULTI_LINE_EDIT);
//   XtSetArg(args[7],XmNrows            ,12);
//   XtSetArg(args[8],XmNcolumns         ,80);
//   text = XmCreateSGcrolledText (form,(char*)"text",args,9);
//   XtManageChild (text);

//   XtAddCallback(clearButton,XmNactivateCallback,
// 		clearButtonCallback,(XtPointer)text);
//   XtAddCallback(command,XmNcommandEnteredCallback,
// 		commandEnteredCallback,(XtPointer)this);

//   Widget commandText = XmCommandGetChild(command,XmDIALOG_COMMAND_TEXT);
//   XtAddEventHandler(commandText,KeyPressMask,False,keyHandler,(XtPointer)this);

//   XtRealizeWidget(shell);
//   XtMapWidget(shell);

  if(UI!=NULL) UI->SetCoutDestination(this);  // TO KEEP
}
/***************************************************************************/
G4UIQt::~G4UIQt(
) 
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{ 
  G4UImanager* UI = G4UImanager::GetUIpointer();  // TO KEEP
  if(UI!=NULL) {  // TO KEEP
    UI->SetSession(NULL);  // TO KEEP
    UI->SetCoutDestination(NULL);  // TO KEEP
  }

  
  if (fMainWindow!=NULL)
    delete fMainWindow;
}
/***************************************************************************/
/*
    Start the Qt main loop
 */
G4UIsession* G4UIQt::SessionStart (
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{

  G4Qt* interactorManager = G4Qt::getInstance ();
  fMainWindow->show();
  Prompt("session");
  exitSession = false;


  printf("disable secondary loop\n");
  interactorManager->DisableSecondaryLoop (); // TO KEEP
  ((QApplication*)interactorManager->GetMainInteractor())->exec(); 
  // on ne passe pas le dessous ? FIXME ????






//   void* event; // TO KEEP
//   while((event = interactorManager->GetEvent())!=NULL) {  // TO KEEP
//     interactorManager->DispatchEvent(event); // TO KEEP
//     if(exitSession==true) break; // TO KEEP
//   } // TO KEEP
   interactorManager->EnableSecondaryLoop (); // TO KEEP
  printf("enable secondary loop\n");
  return this; // TO KEEP
}
/***************************************************************************/

/**
  Display the prompt in the prompt area
 */
void G4UIQt::Prompt (
 G4String aPrompt
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  fCommandLabel->setText((char*)aPrompt.data());
}
/***************************************************************************/
void G4UIQt::SessionTerminate (
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
}
/***************************************************************************/
void G4UIQt::PauseSessionStart (
 G4String a_state
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  printf("G4UIQt::PauseSessionStart\n");
  if(a_state=="G4_pause> ") {  // TO KEEP
    SecondaryLoop ("Pause, type continue to exit this state"); // TO KEEP
  } // TO KEEP

  if(a_state=="EndOfEvent") { // TO KEEP
    // Picking with feed back in event data Done here !!!
    SecondaryLoop ("End of event, type continue to exit this state"); // TO KEEP
  } // TO KEEP
}
/***************************************************************************/
void G4UIQt::SecondaryLoop (
 G4String a_prompt
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  printf("G4UIQt::SecondaryLoop\n");
  G4Qt* interactorManager = G4Qt::getInstance (); // TO KEEP ?
  Prompt(a_prompt); // TO KEEP
  exitPause = false; // TO KEEP
  void* event; // TO KEEP
  while((event = interactorManager->GetEvent())!=NULL) {  // TO KEEP
    interactorManager->DispatchEvent(event); // TO KEEP
    if(exitPause==true) break; // TO KEEP
  } // TO KEEP
  Prompt("session"); // TO KEEP
}
/***************************************************************************/
/**
  Receive a cout from Geant4. We have to display it in the cout zone
 */
G4int G4UIQt::ReceiveG4cout (
 G4String a_string
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  fTextArea->append(QString((char*)a_string.data()).trimmed());
  fTextArea->verticalScrollBar()->setSliderPosition(fTextArea->verticalScrollBar()->maximum());
  return 0;
}
/***************************************************************************/
/**
  Receive a cerr from Geant4. We have to display it in the cout zone
 */
G4int G4UIQt::ReceiveG4cerr (
 G4String a_string
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  QColor previousColor = fTextArea->textColor();
  fTextArea->setTextColor(Qt::red);
  fTextArea->append(QString((char*)a_string.data()).trimmed());
  fTextArea->setTextColor(previousColor);
  fTextArea->verticalScrollBar()->setSliderPosition(fTextArea->verticalScrollBar()->maximum());
  return 0;
}
/***************************************************************************/
G4bool G4UIQt::GetHelpChoice(
 G4int& aInt
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  printf("G4UIQt::GetHelpChoice\n");
  
  fHelp = true; // TO KEEP
//   // SecondaryLoop : // TO KEEP
  G4Qt* interactorManager = G4Qt::getInstance (); // TO KEEP ?
  Prompt("Help"); // TO KEEP
  exitHelp = false; // TO KEEP
  void* event; // TO KEEP
  while((event = interactorManager->GetEvent())!=NULL) {  // TO KEEP
    interactorManager->DispatchEvent(event); // TO KEEP
    if(exitHelp==true) break; // TO KEEP
  } // TO KEEP
  Prompt("session"); // TO KEEP
  // // TO KEEP
  if(fHelp==false) return false; // TO KEEP
  aInt = fHelpChoice; // TO KEEP
  fHelp = false; // TO KEEP
  return true; // TO KEEP
}
/***************************************************************************/
void G4UIQt::ExitHelp(
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  printf("G4UIQt::ExitHelp\n");
}

/***************************************************************************/
void G4UIQt::AddMenu (
 const char* a_name
,const char* a_label
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  printf("G4UIQt::AddMenu %s %s\n",a_name,a_label);

  QMenu *fileMenu = fMainWindow->menuBar()->addMenu(a_label);
  AddInteractor (a_name,(G4Interactor)fileMenu);

  //  QMenu *menu = new QMenu("test");//a_label);
  //  fMainWindow->menuBar()->addMenu(menu); 

//   if(menuBar==NULL) return;
//   if(a_name==NULL) return;
//   if(a_label==NULL) return;
//   XtManageChild (menuBar);
//   // Pulldown menu :
//   Widget widget;
//   widget = XmCreatePulldownMenu (menuBar,(char*)a_name,NULL,0);
//   AddInteractor (a_name,(G4Interactor)widget);
//   // Cascade button :
//   Arg args[2];
//   XmString cps = XmStringLtoRCreate((char*)a_label,XmSTRING_DEFAULT_CHARSET);
//   XtSetArg (args[0],XmNlabelString,cps);
//   XtSetArg (args[1],XmNsubMenuId,widget);
//   widget = XmCreateCascadeButton (menuBar,(char*)a_name,args,2);
//   XmStringFree (cps);
//   XtManageChild (widget);
//   ExecuteChangeSizeFunction(form);
}
/***************************************************************************/
void G4UIQt::AddButton (
 const char* a_menu
,const char* a_label
,const char* a_command
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  if(a_menu==NULL) return; // TO KEEP
  if(a_label==NULL) return; // TO KEEP
  if(a_command==NULL) return; // TO KEEP
  QMenu *parent = (QMenu*)GetInteractor(a_menu);
  if(parent==NULL) return;
  
  signalMapper = new QSignalMapper(this);
  QAction *action = parent->addAction(a_label, signalMapper, SLOT(map()));
  signalMapper->setMapping(action, QString(a_command));
  connect(signalMapper, SIGNAL(mapped(const QString &)),this, SLOT(buttonCallback(const QString&)));
  
  //  std::string slot = SLOT(buttonCallback(std::string));    
  printf("G4UIQt::AddButton %s %s %s\n",a_menu,a_label,a_command);

//   Widget widget = XmCreatePushButton(parent,(char*)a_label,NULL,0);
//   XtManageChild (widget);
//   XtAddCallback (widget,XmNactivateCallback,ButtonCallback,(XtPointer)this);
//   commands[action] = a_command;
}


// /***************************************************************************/
//G4String G4UIQt::GetCommand (
//  QAction *a_widget
//)
// /***************************************************************************/
// /*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
// {
//   return commands[a_widget];
// }
/***************************************************************************/
/***************************************************************************/
/***************************************************************************/

/**
  Callback call when "enter" clicked on the command zone.
  Send the command to geant4
 */
void G4UIQt::buttonCallback (
  const QString& a_command
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  if(fHelp==true) return; // Disabled when in help.
  G4String ss = G4String(a_command.toStdString().c_str());
  printf ("debug : execute:\n%s\n",ss.data());
  ApplyShellCommand(ss,exitSession,exitPause);
}

/**
  Callback call when "click on a menu entry.
  Send the associated command to geant4
 */
void G4UIQt::commandEnteredCallback (
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  G4String command (fCommandArea->text().toStdString().c_str());
  if (fCommandArea->text().toStdString().c_str() != "") {
    fCommandHistoryArea->append(fCommandArea->text());
    if(fHelp==true) {
      exitHelp = true;
      fHelp = ConvertStringToInt(command.data(),fHelpChoice);
    } else {
      ApplyShellCommand (command,exitSession,exitPause);
    }
  }
  fCommandArea->setText("");}
}


/***************************************************************************/
void G4UIQt::clearButtonCallback (
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  fTextArea->clear();
}

//////////////////////////////////////////////////////////////////////////////
G4bool ConvertStringToInt(
 const char* aString
,int& aInt
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  aInt = 0; // TO KEEP
  if(aString==NULL) return false; // TO KEEP
  char* s; // TO KEEP
  long value = strtol(aString,&s,10); // TO KEEP
  if(s==aString) return false; // TO KEEP
  aInt = value; // TO KEEP
  return true; // TO KEEP
}

#endif
