// TODO !

//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4UIQt.cc,v 1.14 2007/05/29 11:09:49 $
// GEANT4 tag $Name: geant4-08-01 $
//
// L. Garnier

//#define DEBUG

#ifdef G4UI_BUILD_QT_SESSION

#include "G4Types.hh"

#include <string.h>

#include "G4UIQt.hh"
#include "G4UImanager.hh"
#include "G4StateManager.hh"
#include "G4UIcommandTree.hh"
#include "G4UIcommandStatus.hh"

#include "G4Qt.hh"

#include <QtGui/qapplication.h>
#include <QtGui/qwidget.h>
#include <QtGui/qmenu.h>
#include <QtGui/qmenubar.h>
#include <QtGui/qboxlayout.h>
#include <QtGui/qpushbutton.h>
#include <QtGui/qlabel.h>
#include <QtGui/qsplitter.h>
#include <QtGui/qscrollbar.h>
#include <QtGui/qdialog.h>

#include <stdlib.h>

static G4bool ConvertStringToInt(const char*,int&);

static G4bool exitSession = true;
static G4bool exitPause = true;
static G4bool exitHelp = true;
/***************************************************************************/
/**
 Build a Qt window with a menubar, output area and promt area 
      +-----------------------+
      |exit menu|             |
      |                       |
      | +-------------------+ |
      | |                   | |
      | |  Output area      | |
      | |                   | |
      | +-------------------+ |
      |     | clear |         |
      | +-------------------+ |
      | |  promt history    | |
      | +-------------------+ |
      | +-------------------+ |
      | |> promt area       | |
      | +-------------------+ |
      +-----------------------+
*/

G4UIQt::G4UIQt (
 int argc,
 char** argv
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  G4Qt* interactorManager = G4Qt::getInstance ();
  G4UImanager* UI = G4UImanager::GetUIpointer();
  if(UI!=NULL) UI->SetSession(this);

  fMainWindow = new QMainWindow();
  fMainWindow->setWindowTitle( "G4UI Session" ); 
  fMainWindow->resize(800,600); 
  fMainWindow->move(QPoint(300,100));

  QSplitter *splitter = new QSplitter(Qt::Vertical);
  fTextArea = new QTextEdit();
  QPushButton *clearButton = new QPushButton("clear");
  connect(clearButton, SIGNAL(clicked()), SLOT(clearButtonCallback()));

  fCommandHistoryArea = new QTextEdit();
  fCommandLabel = new QLabel();

  fCommandArea = new QLineEdit();
  fCommandArea->activateWindow();
  connect(fCommandArea, SIGNAL(returnPressed()), SLOT(commandEnteredCallback()));
  fCommandArea->setFocusPolicy ( Qt::StrongFocus );
  fCommandArea->setFocus(Qt::TabFocusReason);
  fTextArea->setReadOnly(true);
  fCommandHistoryArea->setReadOnly(true);

  

  // Set layouts
  QVBoxLayout *layoutSplitter = new QVBoxLayout;

  QWidget* topWidget = new QWidget();
  QVBoxLayout *layoutTop = new QVBoxLayout;

  QWidget* bottomWidget = new QWidget();
  QVBoxLayout *layoutBottom = new QVBoxLayout;


  layoutTop->addWidget(fTextArea);
  layoutTop->addWidget(clearButton);
  topWidget->setLayout(layoutTop);

  layoutBottom->addWidget(fCommandHistoryArea);
  layoutBottom->addWidget(fCommandLabel);
  layoutBottom->addWidget(fCommandArea);
  bottomWidget->setLayout(layoutBottom);


  layoutSplitter->addWidget(topWidget);
  layoutSplitter->addWidget(bottomWidget);
  splitter->setLayout(layoutSplitter);

  fMainWindow->setCentralWidget(splitter);

  QMenu *fileMenu = fMainWindow->menuBar()->addMenu("File");
  fileMenu->addAction("Quitter", fMainWindow, SLOT(close()));

  // Set the splitter size. The fTextArea sould be 2/3 on the fMainWindow
  QList<int> vals = splitter->sizes();
  if(vals.size()==2) {
    vals[0] = (splitter->orientation()==Qt::Vertical ? splitter->height() : splitter->width())*3/4;
    vals[1] = (splitter->orientation()==Qt::Vertical ? splitter->height() : splitter->width())*1/4;
    splitter->setSizes(vals);
  }


  if(UI!=NULL) UI->SetCoutDestination(this);  // TO KEEP
}
/***************************************************************************/
G4UIQt::~G4UIQt(
) 
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{ 
  G4UImanager* UI = G4UImanager::GetUIpointer();  // TO KEEP
  if(UI!=NULL) {  // TO KEEP
    UI->SetSession(NULL);  // TO KEEP
    UI->SetCoutDestination(NULL);  // TO KEEP
  }

  
  if (fMainWindow!=NULL)
    delete fMainWindow;
}
/***************************************************************************/
/*
    Start the Qt main loop
 */
G4UIsession* G4UIQt::SessionStart (
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{

  G4Qt* interactorManager = G4Qt::getInstance ();
  fMainWindow->show();
  Prompt("session");
  exitSession = false;


  printf("disable secondary loop\n");
  interactorManager->DisableSecondaryLoop (); // TO KEEP
  ((QApplication*)interactorManager->GetMainInteractor())->exec(); 
  // on ne passe pas le dessous ? FIXME ????
  // je ne pense pas 13/06

//   void* event; // TO KEEP
//   while((event = interactorManager->GetEvent())!=NULL) {  // TO KEEP
//     interactorManager->DispatchEvent(event); // TO KEEP
//     if(exitSession==true) break; // TO KEEP
//   } // TO KEEP

  interactorManager->EnableSecondaryLoop ();
  printf("enable secondary loop\n");
  return this;
}
/***************************************************************************/

/**
  Display the prompt in the prompt area
 */
void G4UIQt::Prompt (
 G4String aPrompt
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  fCommandLabel->setText((char*)aPrompt.data());
}
/***************************************************************************/
void G4UIQt::SessionTerminate (
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  G4Qt* interactorManager = G4Qt::getInstance ();
  fMainWindow->close();
  ((QApplication*)interactorManager->GetMainInteractor())->exit(); 
}
/***************************************************************************/
void G4UIQt::PauseSessionStart (
 G4String a_state
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  printf("G4UIQt::PauseSessionStart\n");
  if(a_state=="G4_pause> ") {  // TO KEEP
    SecondaryLoop ("Pause, type continue to exit this state"); // TO KEEP
  } // TO KEEP

  if(a_state=="EndOfEvent") { // TO KEEP
    // Picking with feed back in event data Done here !!!
    SecondaryLoop ("End of event, type continue to exit this state"); // TO KEEP
  } // TO KEEP
}
/***************************************************************************/
void G4UIQt::SecondaryLoop (
 G4String a_prompt
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  printf("G4UIQt::SecondaryLoop\n");
  G4Qt* interactorManager = G4Qt::getInstance (); // TO KEEP ?
  Prompt(a_prompt); // TO KEEP
  exitPause = false; // TO KEEP
  void* event; // TO KEEP
  while((event = interactorManager->GetEvent())!=NULL) {  // TO KEEP
    interactorManager->DispatchEvent(event); // TO KEEP
    if(exitPause==true) break; // TO KEEP
  } // TO KEEP
  Prompt("session"); // TO KEEP
}
/***************************************************************************/
/**
  Receive a cout from Geant4. We have to display it in the cout zone
 */
G4int G4UIQt::ReceiveG4cout (
 G4String a_string
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  fTextArea->append(QString((char*)a_string.data()).trimmed());
  fTextArea->verticalScrollBar()->setSliderPosition(fTextArea->verticalScrollBar()->maximum());
  return 0;
}
/***************************************************************************/
/**
  Receive a cerr from Geant4. We have to display it in the cout zone
 */
G4int G4UIQt::ReceiveG4cerr (
 G4String a_string
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  QColor previousColor = fTextArea->textColor();
  fTextArea->setTextColor(Qt::red);
  fTextArea->append(QString((char*)a_string.data()).trimmed());
  fTextArea->setTextColor(previousColor);
  fTextArea->verticalScrollBar()->setSliderPosition(fTextArea->verticalScrollBar()->maximum());
  return 0;
}
/***************************************************************************/
G4bool G4UIQt::GetHelpChoice(
 G4int& aInt
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  printf("G4UIQt::GetHelpChoice\n");
  
  fHelp = true; // TO KEEP
//   // SecondaryLoop : // TO KEEP
  G4Qt* interactorManager = G4Qt::getInstance (); // TO KEEP ?
  Prompt("Help"); // TO KEEP
  exitHelp = false; // TO KEEP
  void* event; // TO KEEP
  while((event = interactorManager->GetEvent())!=NULL) {  // TO KEEP
    interactorManager->DispatchEvent(event); // TO KEEP
    if(exitHelp==true) break; // TO KEEP
  } // TO KEEP
  Prompt("session"); // TO KEEP
  // // TO KEEP
  if(fHelp==false) return false; // TO KEEP
  aInt = fHelpChoice; // TO KEEP
  fHelp = false; // TO KEEP
  return true; // TO KEEP
}
/***************************************************************************/
void G4UIQt::ExitHelp(
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  printf("G4UIQt::ExitHelp\n");
}

/***************************************************************************/
void G4UIQt::AddMenu (
 const char* a_name
,const char* a_label
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  printf("G4UIQt::AddMenu %s %s\n",a_name,a_label);

  QMenu *fileMenu = fMainWindow->menuBar()->addMenu(a_label);
  AddInteractor (a_name,(G4Interactor)fileMenu);

  //  QMenu *menu = new QMenu("test");//a_label);
  //  fMainWindow->menuBar()->addMenu(menu); 

//   if(menuBar==NULL) return;
//   if(a_name==NULL) return;
//   if(a_label==NULL) return;
//   XtManageChild (menuBar);
//   // Pulldown menu :
//   Widget widget;
//   widget = XmCreatePulldownMenu (menuBar,(char*)a_name,NULL,0);
//   AddInteractor (a_name,(G4Interactor)widget);
//   // Cascade button :
//   Arg args[2];
//   XmString cps = XmStringLtoRCreate((char*)a_label,XmSTRING_DEFAULT_CHARSET);
//   XtSetArg (args[0],XmNlabelString,cps);
//   XtSetArg (args[1],XmNsubMenuId,widget);
//   widget = XmCreateCascadeButton (menuBar,(char*)a_name,args,2);
//   XmStringFree (cps);
//   XtManageChild (widget);
//   ExecuteChangeSizeFunction(form);
}
/***************************************************************************/
void G4UIQt::AddButton (
 const char* a_menu
,const char* a_label
,const char* a_command
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  if(a_menu==NULL) return; // TO KEEP
  if(a_label==NULL) return; // TO KEEP
  if(a_command==NULL) return; // TO KEEP
  QMenu *parent = (QMenu*)GetInteractor(a_menu);
  if(parent==NULL) return;
  
  signalMapper = new QSignalMapper(this);
  QAction *action = parent->addAction(a_label, signalMapper, SLOT(map()));
  signalMapper->setMapping(action, QString(a_command));
  connect(signalMapper, SIGNAL(mapped(const QString &)),this, SLOT(buttonCallback(const QString&)));
  
  //  std::string slot = SLOT(buttonCallback(std::string));    
  printf("G4UIQt::AddButton %s %s %s\n",a_menu,a_label,a_command);

//   Widget widget = XmCreatePushButton(parent,(char*)a_label,NULL,0);
//   XtManageChild (widget);
//   XtAddCallback (widget,XmNactivateCallback,ButtonCallback,(XtPointer)this);
//   commands[action] = a_command;
}


// /***************************************************************************/
//G4String G4UIQt::GetCommand (
//  QAction *a_widget
//)
// /***************************************************************************/
// /*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
// {
//   return commands[a_widget];
// }
/***************************************************************************/
/***************************************************************************/
/***************************************************************************/

/**
  Callback call when "enter" clicked on the command zone.
  Send the command to geant4
 */
void G4UIQt::buttonCallback (
  const QString& a_command
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  if(fHelp==true) return; // Disabled when in help.
  G4String ss = G4String(a_command.toStdString().c_str());
  printf ("debug : execute:\n-%s- %d %d \n",ss.data(),exitSession,exitPause);
  ApplyShellCommand(ss,exitSession,exitPause);
  if(exitSession==true) 
    SessionTerminate();
}

/**
  Callback call when "click on a menu entry.
  Send the associated command to geant4
 */
void G4UIQt::commandEnteredCallback (
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  printf ("debug : callback\n");
  G4String command (fCommandArea->text().toStdString().c_str());
  if (fCommandArea->text().toStdString().c_str() != "") {
    fCommandHistoryArea->append(fCommandArea->text());
    if(fHelp==true) {
  printf ("ne doit plus passer ici\n");
      exitHelp = true;
      fHelp = ConvertStringToInt(command.data(),fHelpChoice);
    } else {
      if (command(0,4) != "help") {
        ApplyShellCommand (command,exitSession,exitPause);
      } else {
        printf ("terminal help\n");
        TerminalHelp(command);
      }
      if(exitSession==true) 
        SessionTerminate();
    }
  }
  fCommandArea->setText("");
}


/***************************************************************************/
void G4UIQt::clearButtonCallback (
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  fTextArea->clear();
}

//////////////////////////////////////////////////////////////////////////////
G4bool ConvertStringToInt(
 const char* aString
,int& aInt
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  aInt = 0; // TO KEEP
  if(aString==NULL) return false; // TO KEEP
  char* s; // TO KEEP
  long value = strtol(aString,&s,10); // TO KEEP
  if(s==aString) return false; // TO KEEP
  aInt = value; // TO KEEP
  return true; // TO KEEP
}

#endif

void G4UIQt::TerminalHelp(G4String newCommand)
{
  QDialog *helpDialog = new QDialog;

  QSplitter *splitter = new QSplitter(Qt::Horizontal);
  fHelpArea = new QTextEdit();
  QPushButton *exitButton = new QPushButton("Exit");
  connect(exitButton, SIGNAL(clicked()), helpDialog,SLOT(close()));
  fHelpArea->setReadOnly(true);

  // the help tree
  G4UImanager* UI = G4UImanager::GetUIpointer();
  if(UI==NULL) return;
  G4UIcommandTree * treeTop = UI->GetTree();

  QTreeWidget *treeWidget = new QTreeWidget();
  treeWidget->setColumnCount(2);
  QStringList labels;
  labels << QString("Summary") << QString("Description");
  treeWidget->setHeaderLabels(labels);

  QList<QTreeWidgetItem *> items;
  G4int treeSize = treeTop->GetTreeEntry();
  QTreeWidgetItem * newItem;
  for (int a=0;a<treeSize;a++) {
    // Creating new item
    QStringList stringList;
    stringList << QString((char*)(treeTop->GetTree(a+1)->GetPathName()).data()).trimmed()  ;
    stringList << QString((char*)(treeTop->GetTree(a+1)->GetTitle()).data()).trimmed()  ;

    newItem = new QTreeWidgetItem(stringList);

    // look for childs
    CreateChildTree(newItem,treeTop->GetTree(a+1));

    items.append(newItem);
  }
  treeWidget->insertTopLevelItems(0, items);

  //connecting callback
  signalMapper = new QSignalMapper(this);
  connect(treeWidget, SIGNAL(itemClicked(QTreeWidgetItem*, int)),this, SLOT(helpTreeCallback(QTreeWidgetItem*, int)));  

  // Set layouts
  QHBoxLayout *splitterLayout = new QHBoxLayout;

  QVBoxLayout *vLayout = new QVBoxLayout;

  splitterLayout->addWidget(treeWidget);
  splitterLayout->addWidget(fHelpArea);
  splitter->setLayout(splitterLayout);

  vLayout->addWidget(splitter);
  vLayout->addWidget(exitButton);
  helpDialog->setLayout(vLayout);

  helpDialog->resize(800,600); 
  helpDialog->move(QPoint(400,150));
  helpDialog->show();
  helpDialog->raise();
  helpDialog->activateWindow();
  ////////////////

  printf ("G4UIQt::TerminalHelp \n");


//   size_t i = newCommand.index(" ");
//   if( i != std::string::npos )
//   {
//     G4String newValue = newCommand(i+1,newCommand.length()-(i+1));
//     newValue.strip(G4String::both);
//     G4String targetCom = ModifyToFullPathCommand( newValue );
//     G4UIcommand* theCommand = treeTop->FindPath( targetCom );
//     if( theCommand != NULL ) 
//     { 
//       theCommand->List();
//       return;
//     }
//     else
//     {
//       G4cout << "Command <" << newValue << " is not found." << G4endl;
//       return;
//     }
//   }

//   G4UIcommandTree * floor[10];
//   floor[0] = treeTop;
//   G4int iFloor = 0;
//   size_t prefixIndex = 1;
//   G4String prefix = GetCurrentWorkingDirectory();
//   while( prefixIndex < prefix.length()-1 )
//   {
//     size_t ii = prefix.index("/",prefixIndex);
//     floor[iFloor+1] = 
//       floor[iFloor]->GetTree(G4String(prefix(0,ii+1)));
//     prefixIndex = ii+1;
//     iFloor++;
//   }
//   floor[iFloor]->ListCurrentWithNum();
//   // 1998 Oct 2 non-number input
//   while(1){
//    //G4cout << G4endl << "Type the number ( 0:end, -n:n level back ) : "<<std::flush;
//     G4cout << G4endl << "Type the number ( 0:end, -n:n level back ) : "<<G4endl;
//     G4int i;
//     if(!GetHelpChoice(i)){
//       G4cout << G4endl << "Not a number, once more" << G4endl; 
//       continue;
//     } else if( i < 0 ){
//       iFloor += i;
//       if( iFloor < 0 ) iFloor = 0;
//       floor[iFloor]->ListCurrentWithNum(); 
//       continue;
//     } else if(i == 0) { 
//       break;
//     } else if( i > 0 ) {
//       G4int n_tree = floor[iFloor]->GetTreeEntry();
//       if( i > n_tree )
//       { 
//         if( i <= n_tree + floor[iFloor]->GetCommandEntry() )
//         { 
//           floor[iFloor]->GetCommand(i-n_tree)->List(); 
//         }
//       }
//       else
//       {
//         floor[iFloor+1] = floor[iFloor]->GetTree(i);
//         iFloor++;
//         floor[iFloor]->ListCurrentWithNum();
//       }
//     }
//   }
  G4cout << "Exit from HELP." << G4endl << G4endl;
  //G4cout << G4endl;
  ExitHelp();
}
void G4UIQt::CreateChildTree(QTreeWidgetItem *a_parent,G4UIcommandTree *a_commandTree) {
  printf ("G4UIQt::CreateChildTree \n");

  // Creating new item
  QTreeWidgetItem * newItem;


  // Get the Sub directories
  for (int a=0;a<a_commandTree->GetTreeEntry();a++) {
    
    QStringList stringList;
    stringList << QString((char*)(a_commandTree->GetTree(a+1)->GetPathName()).data()).trimmed()  ;
    stringList << QString((char*)(a_commandTree->GetTree(a+1)->GetTitle()).data()).trimmed()  ;
    newItem = new QTreeWidgetItem(stringList);

    //connecting callback
    //    signalMapper = new QSignalMapper(this);
    //    QAction *action = parent->addAction(a_label, signalMapper, SLOT(map()));
    
    //  signalMapper->setMapping(action, QString(a_command));
    //  connect(signalMapper, SIGNAL(mapped(const QString &)),this, SLOT(helpTreeCallback(const QString&)));
    //QTreeWidget::itemActivated ( QTreeWidgetItem * item, int column )   [signal]

    CreateChildTree(newItem,a_commandTree->GetTree(a+1));
    a_parent->addChild(newItem);
  }



  // Get the Commands

  for (int a=0;a<a_commandTree->GetCommandEntry();a++) {
    
    QStringList stringList;
    stringList << QString((char*)(a_commandTree->GetCommand(a+1)->GetCommandPath()).data()).trimmed()  ;
    stringList << QString((char*)(a_commandTree->GetCommand(a+1)->GetTitle()).data()).trimmed()  ;
    newItem = new QTreeWidgetItem(stringList);
      
    a_parent->addChild(newItem);

  }

  printf ("G4UIQt::CreateChildTree  end of for loop\n");
}

/**
This callback is activated when user selected a item in the help tree
 */
/***************************************************************************/
void G4UIQt::helpTreeCallback (
 QTreeWidgetItem* a_treeItem
,int a_index
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  if (fHelpArea) {
    G4UImanager* UI = G4UImanager::GetUIpointer();
    if(UI==NULL) return;
    G4UIcommandTree * treeTop = UI->GetTree();
    G4UIcommand* command = treeTop->FindPath(a_treeItem->text (0).toStdString().c_str());
    if (command) {
      printf ("G4UIQt::CreateChildTree  end of for loop ========\n");
      fHelpArea->setText(GetCommandList(treeTop->FindPath(a_treeItem->text (0).toStdString().c_str())));
    } else {
      printf ("G4UIQt::CreateChildTree  end of for loop ********\n");
    }
  }
}

/**
 */
/***************************************************************************/
QString G4UIQt::GetCommandList (
  G4UIcommand *a_command
)
/***************************************************************************/
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
{
  printf ("G4UIQt::CreateChildTree  %s --\n",(char*)(a_command->GetCommandName()).data())  ;

  QString txt;
  G4String commandPath = a_command->GetCommandPath();
  G4String rangeString = a_command->GetRange();

  if((commandPath.length()-1)!='/')
  {
    txt += "Command " + QString((char*)(commandPath).data()) + "\n";
  }
  txt += "Guidance :\n";
  G4int n_guidanceEntry = a_command->GetGuidanceEntries();
  for( G4int i_thGuidance=0; i_thGuidance < n_guidanceEntry; i_thGuidance++ )
    { txt += QString((char*)(a_command->GetGuidanceLine(i_thGuidance)).data()) + "\n"; }
  if( ! rangeString.isNull() )
    { txt += " Range of parameters : " + QString((char*)(rangeString).data()) + "\n"; }
  G4int n_parameterEntry = a_command->GetParameterEntries();
  if( n_parameterEntry > 0 )
  {
    for( G4int i_thParameter=0; i_thParameter<n_parameterEntry; i_thParameter++ )
      { a_command->GetParameter(i_thParameter)->List(); }
  }
  return txt;
}
