//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4OpenGLStoredQtViewer.hh,v 1.7 2007/06/25 21:18:06 $
// GEANT4 tag $Name: geant4-08-01-patch-01 $
//
// 
// Class G4OpenGLStoredQtViewer : a class derived from
//   G4OpenGLQtViewer and G4OpenGLStoredViewer.

#ifdef G4VIS_BUILD_OPENGLQT_DRIVER

#ifndef G4OPENGLSTOREDQTVIEWER_HH
#define G4OPENGLSTOREDQTVIEWER_HH

#include "G4VViewer.hh"
#include "G4OpenGLStoredViewer.hh"
#include "G4OpenGLQtViewer.hh"

class G4OpenGLStoredSceneHandler;

class G4OpenGLStoredQtViewer:
public G4OpenGLQtViewer, public G4OpenGLStoredViewer{
  
public:
  G4OpenGLStoredQtViewer (G4OpenGLStoredSceneHandler& scene,
			     const G4String& name = "");
  void Initialise ();
  void DrawView ();
  void FinishView ();
};

#endif

#endif

