//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4OpenGLImmediateQtViewer.cc,v 1.16 2007/06/25 16:38:13 $
// GEANT4 tag $Name: geant4-08-02-patch-01 $
//
//
// Class G4OpenGLImmediateQtViewer : a class derived from G4OpenGLQtViewer and
//                                G4OpenGLImmediateViewer.

#ifdef G4VIS_BUILD_OPENGLQT_DRIVER

#include "G4OpenGLImmediateQtViewer.hh"

#include "G4ios.hh"

G4OpenGLImmediateQtViewer::G4OpenGLImmediateQtViewer
(G4OpenGLImmediateSceneHandler& sceneHandler,
 const G4String&  name):
G4OpenGLViewer (sceneHandler),
G4OpenGLQtViewer (sceneHandler),
G4OpenGLImmediateViewer (sceneHandler),
G4VViewer (sceneHandler, sceneHandler.IncrementViewCount (), name) {

  if (fViewId < 0) return;  // In case error in base class instantiation.
}

void G4OpenGLImmediateQtViewer::Initialise() {

  readyToPaint = false;

// ensure a suitable window was found

  printf("G4OpenGLImmediateQtViewer::Initialise () 1\n");
  CreateGLQtContext ();
  printf("G4OpenGLImmediateQtViewer::Initialise () 2\n");

  CreateMainWindow (this);
  printf("G4OpenGLImmediateQtViewer::Initialise () 3\n");
  CreateFontLists ();
  printf("G4OpenGLImmediateQtViewer::Initialise () 4\n");
  readyToPaint = true;

  InitializeGLView ();

  printf("G4OpenGLImmediateQtViewer::Initialise () 5\n");

  // clear the buffers and window.
  //  ClearView ();
  printf("G4OpenGLImmediateQtViewer::Initialise () 6\n");
  //  FinishView ();
  printf("G4OpenGLImmediateQtViewer::Initialise () 7\n");

  // If a double buffer context has been forced upon us, ignore the
  // back buffer for this OpenGLImmediate view.
  glDrawBuffer (GL_FRONT);

  glDepthFunc (GL_LEQUAL);
  glDepthMask (GL_TRUE);
  printf("G4OpenGLImmediateQtViewer::Initialise () 8\n");

}

void G4OpenGLImmediateQtViewer::InitialiseGL () {
  printf("G4OpenGLImmediateQtViewer::Initialise   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
  printf("G4OpenGLImmediateQtViewer::Initialise  -------------------------------------------------------------------------------------\n");
}


void G4OpenGLImmediateQtViewer::DrawView () {

  printf("G4OpenGLImmediateQtViewer::DrawView %d %d   VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV\n",WinSize_x, WinSize_y);
  // If a double buffer context has been forced upon us, ignore the
  // back buffer for this OpenGLImmediate view.
  glDrawBuffer (GL_FRONT);

  G4ViewParameters::DrawingStyle style = GetViewParameters().GetDrawingStyle();

  //Make sure current viewer is attached and clean...
  //Qt version needed
  //glXMakeCurrent (dpy, win, cx);
  glViewport (0, 0, WinSize_x, WinSize_y);

  if(style!=G4ViewParameters::hlr &&
     haloing_enabled) {

    HaloingFirstPass ();
    NeedKernelVisit ();
    ProcessView ();
    glFlush ();

    HaloingSecondPass ();

  }

  NeedKernelVisit ();  // Always need to visit G4 kernel.
  ProcessView ();
  FinishView ();
  printf("G4OpenGLImmediateQtViewer::DrawView %d %d ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ \n",WinSize_x, WinSize_y);

}


//////////////////////////////////////////////////////////////////////////////
void G4OpenGLImmediateQtViewer::FinishView (
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  printf("G4OpenGLImmediateQtViewer::FinishView VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV\n");
  //    if(!fHDC) return;

  glFlush ();
  printf("G4OpenGLImmediateQtViewer::FinishView ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ \n");

  // Empty the Windows message queue :
//   MSG event;
//   while ( ::PeekMessage(&event, NULL, 0, 0, PM_REMOVE) ) {
//     ::TranslateMessage(&event);
//     ::DispatchMessage (&event);
//   }
}


void G4OpenGLImmediateQtViewer::resizeGL(
 int width
,int height)
{
  printf("G4OpenGLImmediateQtViewer::resizeGL VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV \n");
  /*
  int side = qMin(width, height);
  glViewport((width - side) / 2, (height - side) / 2, side, side);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glOrtho(-0.5, +0.5, +0.5, -0.5, 4.0, 15.0);
  glMatrixMode(GL_MODELVIEW);
  */
  printf("G4OpenGLImmediateQtViewer::resizeGL ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ \n");
}

void G4OpenGLImmediateQtViewer::paintGL()
 {
  printf("G4OpenGLImmediateQtViewer::paintGL VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV \n");
  float b=3;
  if (!readyToPaint)
    return;

  //  WinSize_x = (G4int) width();
  //  WinSize_y = (G4int) height();

  //  glViewport (0, 0, width(), height());

  //  SetView();
  printf("before ClearView\n");
  //  makeCurrent();
  for (int a=0;a<100000000;a++) {b = b/3.1456;}
  printf("    ClearView\n");
  //  ClearView (); //ok, put the background correct
  //  DrawView();
  //  ShowView();
  //  printf("before ClearView\n");
  //  ClearView (); //ok, put the background correct
  printf("G4OpenGLImmediateQtViewer::paintGL ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n");
  // FIXME
  //  FinishView();
  //  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  //  glLoadIdentity();
  //  glTranslated(0.0, 0.0, -10.0);

 glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
 glLoadIdentity();
 glTranslatef(-1.5f,0.0f,-6.0f);
 glBegin(GL_TRIANGLES);
 glVertex3f( 0.0f, 1.0f, 0.0f);
 glVertex3f(-1.0f,-1.0f, 0.0f);
 glVertex3f( 1.0f,-1.0f, 0.0f);
 glEnd();
 glTranslatef(3.0f,0.0f,0.0f);
 glBegin(GL_QUADS);
 glVertex3f(-1.0f, 1.0f, 0.0f);
 glVertex3f( 1.0f, 1.0f, 0.0f);
 glVertex3f( 1.0f,-1.0f, 0.0f);
 glVertex3f(-1.0f,-1.0f, 0.0f);
 glEnd(); 
 }
#endif
