//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4OpenGLImmediateQtViewer.cc,v 1.16 2007/06/25 16:38:13 $
// GEANT4 tag $Name: geant4-08-02-patch-01 $
//
//
// Class G4OpenGLImmediateQtViewer : a class derived from G4OpenGLQtViewer and
//                                G4OpenGLImmediateViewer.

#ifdef G4VIS_BUILD_OPENGLQT_DRIVER

#include "G4OpenGLImmediateQtViewer.hh"

#include "G4ios.hh"

G4OpenGLImmediateQtViewer::G4OpenGLImmediateQtViewer
(G4OpenGLImmediateSceneHandler& sceneHandler,
 const G4String&  name):
 G4VViewer (sceneHandler, sceneHandler.IncrementViewCount (), name),
 G4OpenGLViewer (sceneHandler),
 G4OpenGLQtViewer (sceneHandler),
 G4OpenGLImmediateViewer (sceneHandler),
 QGLWidget()                      // FIXME : gerer le pb du parent !
 {

  if (fViewId < 0) return;  // In case error in base class instantiation.
   printf("GLWidget::GLWidget \n");
     object = 0;
     xRot = 0;
     yRot = 0;
     zRot = 0;

     trolltechGreen = QColor::fromCmykF(0.40, 0.0, 1.0, 0.0);
     trolltechPurple = QColor::fromCmykF(0.39, 0.39, 0.0, 0.0);
   printf("GLWidget::GLWidget END\n");
}

G4OpenGLImmediateQtViewer::~G4OpenGLImmediateQtViewer() {
   printf("GLWidget::~GLWidget \n");
     makeCurrent();
     glDeleteLists(object, 1);
   printf("GLWidget::~GLWidget END\n");
}

void G4OpenGLImmediateQtViewer::Initialise() {
   printf("GLWidget::Initialise \n");
   printf("readyToPaint = false \n");
   readyToPaint = false;
   //  printf("G4OpenGLImmediateQtViewer::Initialise () 1\n");
  //  CreateGLQtContext ();
  printf("G4OpenGLImmediateQtViewer::Initialise () 2\n");

  CreateMainWindow (this);
  printf("G4OpenGLImmediateQtViewer::Initialise () 3\n");

  //  CreateFontLists ();  // FIXME Does nothing!

  printf("readyToPaint = true \n");
  readyToPaint = true;
}

void G4OpenGLImmediateQtViewer::initializeGL () {
   printf("GLWidget::initializeGL \n");
     qglClearColor(trolltechPurple.dark());
     object = makeObject();
     glShadeModel(GL_FLAT);
     glEnable(GL_DEPTH_TEST);
     glEnable(GL_CULL_FACE);
   printf("GLWidget::initializeGL END\n");

//   printf("G4OpenGLImmediateQtViewer::InitialiseGL   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");

// // ensure a suitable window was found


//   InitializeGLView ();

//   printf("G4OpenGLImmediateQtViewer::InitialiseGL () 1\n");

//   // clear the buffers and window.
//   //  ClearView ();
//   printf("G4OpenGLImmediateQtViewer::InitialiseGL () 2\n");
//   //  FinishView ();

//   // If a double buffer context has been forced upon us, ignore the
//   // back buffer for this OpenGLImmediate view.
//   glDrawBuffer (GL_FRONT);

//   glDepthFunc (GL_LEQUAL);
//   glDepthMask (GL_TRUE);

//   printf("G4OpenGLImmediateQtViewer::InitialiseGL  -------------------------------------------------------------------------------------\n");
}


void G4OpenGLImmediateQtViewer::DrawView () {

  printf("G4OpenGLImmediateQtViewer::DrawView %d %d   VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV\n",WinSize_x, WinSize_y);
  // If a double buffer context has been forced upon us, ignore the
  // back buffer for this OpenGLImmediate view.
//   glDrawBuffer (GL_FRONT);

//   G4ViewParameters::DrawingStyle style = GetViewParameters().GetDrawingStyle();

//   //Make sure current viewer is attached and clean...
//   //Qt version needed
//   //glXMakeCurrent (dpy, win, cx);
//   glViewport (0, 0, WinSize_x, WinSize_y);

//   if(style!=G4ViewParameters::hlr &&
//      haloing_enabled) {

//     HaloingFirstPass ();
//     NeedKernelVisit ();
//     ProcessView ();
//     glFlush ();

//     HaloingSecondPass ();

//   }

//   NeedKernelVisit ();  // Always need to visit G4 kernel.
//   ProcessView ();
//   FinishView ();
  printf("G4OpenGLImmediateQtViewer::DrawView %d %d ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ \n",WinSize_x, WinSize_y);

}

void G4OpenGLImmediateQtViewer::DrawView2 () {

  printf("G4OpenGLImmediateQtViewer::DrawView2 %d %d   VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV\n",WinSize_x, WinSize_y);
   // If a double buffer context has been forced upon us, ignore the
   // back buffer for this OpenGLImmediate view.
  //   glDrawBuffer (GL_FRONT);

   G4ViewParameters::DrawingStyle style = GetViewParameters().GetDrawingStyle();

   //Make sure current viewer is attached and clean...
   //Qt version needed
   //glXMakeCurrent (dpy, win, cx);
   glViewport (0, 0, WinSize_x, WinSize_y);

   if(style!=G4ViewParameters::hlr &&
      haloing_enabled) {

     HaloingFirstPass ();
     NeedKernelVisit ();
     ProcessView ();
     glFlush ();

     HaloingSecondPass ();

   }

   NeedKernelVisit ();  // Always need to visit G4 kernel.
   ProcessView ();
   FinishView ();
  printf("G4OpenGLImmediateQtViewer::DrawView2 %d %d ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ \n",WinSize_x, WinSize_y);

}


//////////////////////////////////////////////////////////////////////////////
void G4OpenGLImmediateQtViewer::FinishView (
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  printf("G4OpenGLImmediateQtViewer::FinishView VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV\n");
//   //    if(!fHDC) return;

//   glFlush ();
  printf("G4OpenGLImmediateQtViewer::FinishView ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ \n");

  // Empty the Windows message queue :
//   MSG event;
//   while ( ::PeekMessage(&event, NULL, 0, 0, PM_REMOVE) ) {
//     ::TranslateMessage(&event);
//     ::DispatchMessage (&event);
//   }
}


void G4OpenGLImmediateQtViewer::resizeGL(
 int width
,int height)
{
  printf("G4OpenGLImmediateQtViewer::resizeGL VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV \n");
  
  int side = qMin(width, height);
  glViewport((width - side) / 2, (height - side) / 2, side, side);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glOrtho(-0.5, +0.5, +0.5, -0.5, 4.0, 15.0);
  glMatrixMode(GL_MODELVIEW);
  
  printf("G4OpenGLImmediateQtViewer::resizeGL ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ \n");
}

void G4OpenGLImmediateQtViewer::paintGL()
 {
   if (!readyToPaint)
     return;
//    printf("GLWidget::paintGL\n");
//      glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
//      glLoadIdentity();
//      glTranslated(0.0, 0.0, -10.0);
//      glRotated(xRot / 16.0, 1.0, 0.0, 0.0);
//      glRotated(yRot / 16.0, 0.0, 1.0, 0.0);
//      glRotated(zRot / 16.0, 0.0, 0.0, 1.0);
//      glCallList(object);
//    printf("GLWidget::paintGL END\n");
//   printf("G4OpenGLImmediateQtViewer::paintGL VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV \n");
//   float b=3;

   WinSize_x = (G4int) width();
   WinSize_y = (G4int) height();

   glViewport (0, 0, width(), height());

   SetView();
//   //  printf("before ClearView\n");
//   //  makeCurrent();
//   //  for (int a=0;a<100000000;a++) {b = b/3.1456;}
//   printf("    ClearView\n");
   ClearView (); //ok, put the background correct
   DrawView2();
//   //  ShowView();
//   //  printf("before ClearView\n");
//   //  ClearView (); //ok, put the background correct
//   // FIXME
  FinishView();
//   //  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
//   //  glLoadIdentity();
//   //  glTranslated(0.0, 0.0, -10.0);

//   printf("G4OpenGLImmediateQtViewer::paintGL ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n");
 }




 GLuint G4OpenGLImmediateQtViewer::makeObject()
 {
     GLuint list = glGenLists(1);
     glNewList(list, GL_COMPILE);

     glBegin(GL_QUADS);

     GLdouble x1 = +0.06;
     GLdouble y1 = -0.14;
     GLdouble x2 = +0.14;
     GLdouble y2 = -0.06;
     GLdouble x3 = +0.08;
     GLdouble y3 = +0.00;
     GLdouble x4 = +0.30;
     GLdouble y4 = +0.22;

     quad(x1, y1, x2, y2, y2, x2, y1, x1);
     quad(x3, y3, x4, y4, y4, x4, y3, x3);

     extrude(x1, y1, x2, y2);
     extrude(x2, y2, y2, x2);
     extrude(y2, x2, y1, x1);
     extrude(y1, x1, x1, y1);
     extrude(x3, y3, x4, y4);
     extrude(x4, y4, y4, x4);
     extrude(y4, x4, y3, x3);

     const double Pi = 3.14159265358979323846;
     const int NumSectors = 200;

     for (int i = 0; i < NumSectors; ++i) {
         double angle1 = (i * 2 * Pi) / NumSectors;
         GLdouble x5 = 0.30 * sin(angle1);
         GLdouble y5 = 0.30 * cos(angle1);
         GLdouble x6 = 0.20 * sin(angle1);
         GLdouble y6 = 0.20 * cos(angle1);

         double angle2 = ((i + 1) * 2 * Pi) / NumSectors;
         GLdouble x7 = 0.20 * sin(angle2);
         GLdouble y7 = 0.20 * cos(angle2);
         GLdouble x8 = 0.30 * sin(angle2);
         GLdouble y8 = 0.30 * cos(angle2);

         quad(x5, y5, x6, y6, x7, y7, x8, y8);

         extrude(x6, y6, x7, y7);
         extrude(x8, y8, x5, y5);
     }

     glEnd();

     glEndList();
     return list;
 }

 void G4OpenGLImmediateQtViewer::quad(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2,
                     GLdouble x3, GLdouble y3, GLdouble x4, GLdouble y4)
 {
     qglColor(trolltechGreen);

     glVertex3d(x1, y1, -0.05);
     glVertex3d(x2, y2, -0.05);
     glVertex3d(x3, y3, -0.05);
     glVertex3d(x4, y4, -0.05);

     glVertex3d(x4, y4, +0.05);
     glVertex3d(x3, y3, +0.05);
     glVertex3d(x2, y2, +0.05);
     glVertex3d(x1, y1, +0.05);
 }

 void G4OpenGLImmediateQtViewer::extrude(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2)
 {
     qglColor(trolltechGreen.dark(250 + int(100 * x1)));

     glVertex3d(x1, y1, +0.05);
     glVertex3d(x2, y2, +0.05);
     glVertex3d(x2, y2, -0.05);
     glVertex3d(x1, y1, -0.05);
 }

#endif
