//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4OpenGLQtExportDialog.cc,v 0.1 2007/09/20 15:18:20 garnier $
// GEANT4 tag $Name: geant4-08-02-patch-01 $
//
// 

#ifdef G4VIS_BUILD_OPENGLQT_DRIVER

#include "G4OpenGLQtExportDialog.hh"

#include <qvariant.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qimage.h>

G4OpenGLQtExportDialog::G4OpenGLQtExportDialog(
 QWidget* parent
,QString nomFich )
  : QDialog( parent )
{
  setWindowTitle( tr( "QtiPlot - Export options" ));
  setMinimumSize( QSize( 310, 140 ) );
  setMaximumSize( QSize( 310, 140 ) );
  
  QGroupBox *groupBox1 = new QGroupBox(tr("Exclusive Radio Buttons"));
  QVBoxLayout *vbox1 = new QVBoxLayout;
  
  if(nomFich.endsWith(".jpg")) {
    
    vbox1->addWidget( new QLabel( tr( "Image quality" ) ));
    boxQuality= new QSpinBox();
    
    boxQuality->setMinimum(0);
    boxQuality->setMaximum(100);
    boxQuality->setValue(100);
    vbox1->addWidget(boxQuality);
  }
  
  if(nomFich.endsWith(".eps")) {
    // balck and white / colour 
    // background
    // size ?
    ;
  }

  if(nomFich.endsWith(".tif") ||
     nomFich.endsWith(".tiff") ||
     nomFich.endsWith(".png") ||
     nomFich.endsWith(".xpm")) {
    boxTransparency = new QCheckBox( "boxTransparency" );
    boxTransparency->setText( "Save transparency" );
    boxTransparency->setChecked( false );
    boxTransparency->setEnabled(false);
    vbox1->addWidget(boxTransparency);
  }

  groupBox1->setLayout(vbox1);

  QGroupBox *groupBox2 = new QGroupBox();
  QHBoxLayout *hbox2 = new QHBoxLayout;
  groupBox2->setFlat (TRUE);

  buttonOk = new QPushButton( tr( "&OK" ) );
  buttonOk->setAutoDefault( TRUE );
  buttonOk->setDefault( TRUE );
  hbox2->addWidget(buttonOk);

  buttonCancel = new QPushButton( tr( "&Cancel" ) );
  buttonCancel->setAutoDefault( TRUE );
  hbox2->addWidget(buttonCancel);

  groupBox2->setLayout(hbox2);
  QHBoxLayout* hlayout = new QHBoxLayout();
  hlayout->addWidget(groupBox1);
  hlayout->addWidget(groupBox2);


  // signals and slots connections
  connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
  connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
}


void G4OpenGLQtExportDialog::enableTransparency(int)
{
  QString type = boxFormat->currentText().toLower();

  if (type == "tif" || type == "tiff" || type == "png" || type == "xpm")
    boxTransparency->setEnabled(true);
}

void G4OpenGLQtExportDialog::enableTransparency()
{
  QString type = f_type.toLower();

  if (type == "tif" || type == "tiff" || type == "png" || type == "xpm")
    boxTransparency->setEnabled(true);
}

void G4OpenGLQtExportDialog::accept()
{
  emit options(f_name, f_type, boxQuality->value(), boxTransparency->isChecked());
  close();
}


G4OpenGLQtExportDialog::~G4OpenGLQtExportDialog()
{
}


#endif
