//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4OpenGLQtExportDialog.cc,v 0.1 2007/09/20 15:18:20 garnier $
// GEANT4 tag $Name: geant4-08-02-patch-01 $
//
// 

#ifdef G4VIS_BUILD_OPENGLQT_DRIVER

#include "G4OpenGLQtExportDialog.hh"

#include <qvariant.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qslider.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qimage.h>

G4OpenGLQtExportDialog::G4OpenGLQtExportDialog(
 QWidget* parent
,QString nomFich )
  : QDialog( parent )
{
  setWindowTitle( tr( " Export options" ));
  
  QGroupBox *groupBox1 = new QGroupBox(tr("Image quality"));
  QVBoxLayout *vbox1 = new QVBoxLayout;
  
  if(nomFich.endsWith(".jpg")) {
    
    QWidget *sliderBox = new QWidget;
    QHBoxLayout *hSlider = new QHBoxLayout;
    //    qualityLabel =  new QLabel( tr( "Image quality" ) );
    //    vbox1->addWidget(qualityLabel);
    qualitySlider= new QSlider(Qt::Horizontal);
    qualitySlider->setMinimum(0);
    qualitySlider->setMaximum(100);
    qualitySlider->setTickPosition(QSlider::TicksBelow);
    qualitySlider->setValue(60);
    hSlider->addWidget(new QLabel("low"));
    hSlider->addWidget(qualitySlider);
    hSlider->addWidget(new QLabel("Maximum"));
    sliderBox->setLayout(hSlider);
    vbox1->addWidget(sliderBox);
  }
  
  if(nomFich.endsWith(".eps")) {
    // balck and white / colour 
    // background
    // size ?
    ;
  }

  if(nomFich.endsWith(".tif") ||
     nomFich.endsWith(".tiff") ||
     nomFich.endsWith(".jpg") ||
     nomFich.endsWith(".png") ||
     nomFich.endsWith(".xpm")) {
    boxTransparency = new QCheckBox( "boxTransparency" );
    boxTransparency->setText( "Save transparency" );
    boxTransparency->setChecked( false );
    boxTransparency->setEnabled(false);
    vbox1->addWidget(boxTransparency);
  }

  groupBox1->setLayout(vbox1);

  QGroupBox *groupBox2 = new QGroupBox();
  QHBoxLayout *hbox2 = new QHBoxLayout;

  buttonOk = new QPushButton( tr( "&OK" ) );
  buttonOk->setAutoDefault( TRUE );
  buttonOk->setDefault( TRUE );
  hbox2->addWidget(buttonOk);

  buttonCancel = new QPushButton( tr( "&Cancel" ) );
  buttonCancel->setAutoDefault( TRUE );
  hbox2->addWidget(buttonCancel);

  groupBox2->setLayout(hbox2);
  QVBoxLayout* vlayout = new QVBoxLayout();
  vlayout->addWidget(groupBox1);
  vlayout->addWidget(groupBox2);

  setLayout(vlayout);

  // signals and slots connections
  connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
  connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
}


void G4OpenGLQtExportDialog::enableTransparency(int)
{
  QString type = boxFormat->currentText().toLower();

  if (type == "tif" || type == "tiff" || type == "png" || type == "xpm")
    boxTransparency->setEnabled(true);
}

int G4OpenGLQtExportDialog::getSliderValue()
{
  return qualitySlider->value();
}

void G4OpenGLQtExportDialog::enableTransparency()
{
  QString type = f_type.toLower();

  if (type == "tif" || type == "tiff" || type == "png" || type == "xpm")
    boxTransparency->setEnabled(true);
}


G4OpenGLQtExportDialog::~G4OpenGLQtExportDialog()
{
}


#endif
