//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4OpenGLQtExportDialog.cc,v 0.1 2007/09/20 15:18:20 garnier $
// GEANT4 tag $Name: geant4-08-02-patch-01 $
//
// 

#ifdef G4VIS_BUILD_OPENGLQT_DRIVER

#include "G4OpenGLQtExportDialog.hh"

#include <qvariant.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qslider.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qradiobutton.h>
#include <qimage.h>
#include <qlineedit.h>

G4OpenGLQtExportDialog::G4OpenGLQtExportDialog(
 QWidget* parent
,QString nomFich
 ,int aHeight
 ,int aWidth
)
  : QDialog( parent )
{
  setWindowTitle( tr( " Export options" ));
  originalWidth = aWidth;
  originalHeight = aHeight;
  printf("height %d width %d\n",aHeight,aWidth);  

  // global layout
  QVBoxLayout* globalVLayout = new QVBoxLayout();

  
  if(nomFich.endsWith(".jpg")) {
    
    QGroupBox *imageGroupBox = new QGroupBox(tr("Image quality"));
    QVBoxLayout *imageGroupBoxLayout = new QVBoxLayout;

    QWidget *sliderBox = new QWidget;
    QHBoxLayout *hSlider = new QHBoxLayout;
    //    qualityLabel =  new QLabel( tr( "Image quality" ) );
    //    imageGroupBoxLayout->addWidget(qualityLabel);
    qualitySlider= new QSlider(Qt::Horizontal);
    qualitySlider->setMinimum(0);
    qualitySlider->setMaximum(100);
    qualitySlider->setTickPosition(QSlider::TicksBelow);
    qualitySlider->setValue(60);
    hSlider->addWidget(new QLabel("low"));
    hSlider->addWidget(qualitySlider);
    hSlider->addWidget(new QLabel("Maximum"));
    sliderBox->setLayout(hSlider);
    imageGroupBoxLayout->addWidget(sliderBox);

    imageGroupBox->setLayout(imageGroupBoxLayout);
    globalVLayout->addWidget(imageGroupBox);
  }
  
  if(nomFich.endsWith(".eps") ||
     nomFich.endsWith(".jpg")) {
    QGroupBox *EPSGroupBox = new QGroupBox(tr("EPS options"));
    QVBoxLayout *EPSGroupBoxLayout = new QVBoxLayout;

    boxEPS = new QCheckBox( "boxEPS" );
    boxEPS->setText( "save background" );
    boxEPS->setChecked( true );

    color = new QRadioButton("Color");
    BW = new QRadioButton("Grayscale");
    color->setChecked( true );
    BW->setChecked( false );
    
    connect( color, SIGNAL( clicked() ), BW, SLOT( toogle() ) );
    connect( BW, SIGNAL( clicked() ), color, SLOT( toogle() ) );


    EPSGroupBoxLayout->addWidget(boxEPS);    
    EPSGroupBoxLayout->addWidget(color);    
    EPSGroupBoxLayout->addWidget(BW);    
    EPSGroupBox->setLayout(EPSGroupBoxLayout);
    globalVLayout->addWidget(EPSGroupBox);

  }

  if(nomFich.endsWith(".tif") ||
     nomFich.endsWith(".tiff") ||
     nomFich.endsWith(".jpg") ||
     nomFich.endsWith(".png") ||
     nomFich.endsWith(".xpm")) {

    QGroupBox *transparencyGroupBox = new QGroupBox(tr("Transparency"));
    QVBoxLayout *transparencyGroupBoxLayout = new QVBoxLayout;

    boxTransparency = new QCheckBox("Save transparency");
    boxTransparency->setChecked( false );
    //    boxTransparency->setEnabled(false);

    transparencyGroupBoxLayout->addWidget(boxTransparency);    
    transparencyGroupBox->setLayout(transparencyGroupBoxLayout);
    globalVLayout->addWidget(transparencyGroupBox);

  }

  // size box    
  QGroupBox *sizeGroupBox = new QGroupBox(tr("Size"));
  QVBoxLayout *sizeGroupBoxLayout = new QVBoxLayout;
  
  original = new QRadioButton("Original");
  modify = new QRadioButton("Modify");
  original->setChecked( true );
  modify->setChecked( false );
  
  sizeGroupBoxLayout->addWidget(original);
  sizeGroupBoxLayout->addWidget(modify);
  connect( original, SIGNAL( clicked() ), modify, SLOT( toogle() ) );
  connect( modify, SIGNAL( clicked() ), original, SLOT( toogle() ) );
  connect( modify, SIGNAL( toggled(bool) ), this, SLOT( changeSizeBox(bool) ) );

  QHBoxLayout *heightLineLayout = new QHBoxLayout;
  heightWidget = new QWidget;
  QString tmp;
 
  heightLineLayout->addWidget(new QLabel("Height"));
  height = new QLineEdit(tmp.setNum(originalHeight));
  height->setMaxLength(5);
  heightLineLayout->addWidget(height);
  ratioCheckBox = new QCheckBox( "Keep ratio" );
  ratioCheckBox->setChecked( true );
  heightLineLayout->addWidget(ratioCheckBox);
  heightWidget->setLayout(heightLineLayout);
  sizeGroupBoxLayout->addWidget(heightWidget);
  connect( ratioCheckBox, SIGNAL( toogle() ), this, SLOT( keepRatio() ) );

  QHBoxLayout *widthLineLayout = new QHBoxLayout;
  widthWidget = new QWidget;

  widthLineLayout->addWidget(new QLabel("Width"));
  width = new QLineEdit(tmp.setNum(originalWidth));
  width->setMaxLength(5);
  widthLineLayout->addWidget(width);
  widthWidget->setLayout(widthLineLayout);
  sizeGroupBoxLayout->addWidget(widthWidget);

  sizeGroupBox->setLayout(sizeGroupBoxLayout);
  globalVLayout->addWidget(sizeGroupBox);

  heightWidget->setVisible(false);
  widthWidget->setVisible(false);

    // button ok/cancel box

  QGroupBox *buttonGroupBox = new QGroupBox();
  QHBoxLayout *buttonGroupBoxLayout = new QHBoxLayout;

  buttonOk = new QPushButton( tr( "&OK" ) );
  buttonOk->setAutoDefault( TRUE );
  buttonOk->setDefault( TRUE );
  buttonGroupBoxLayout->addWidget(buttonOk);

  buttonCancel = new QPushButton( tr( "&Cancel" ) );
  buttonCancel->setAutoDefault( TRUE );
  buttonGroupBoxLayout->addWidget(buttonCancel);

  buttonGroupBox->setLayout(buttonGroupBoxLayout);
  globalVLayout->addWidget(buttonGroupBox);


  setLayout(globalVLayout);

  // signals and slots connections
  connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
  connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
}



int G4OpenGLQtExportDialog::getSliderValue()
{
  return qualitySlider->value();
}

void G4OpenGLQtExportDialog::changeSizeBox(bool aChange)
{
  heightWidget->setVisible(modify->isChecked());
  widthWidget->setVisible(modify->isChecked());
}

void G4OpenGLQtExportDialog::keepRatio()
{
}


G4OpenGLQtExportDialog::~G4OpenGLQtExportDialog()
{
}


#endif
