//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4OpenGLQtExportDialog.hh,v 0.1 2007/09/20 15:18:20 garnier $
// GEANT4 tag $Name: geant4-08-02-patch-01 $
//
// 

#ifdef G4VIS_BUILD_OPENGLQT_DRIVER

#ifndef G4OPENGLQTEXPORTDIALOG_HH
#define G4OPENGLQTEXPORTDIALOG_HH

#include <qvariant.h>
#include <qdialog.h>

class QButtonGroup;
class QPushButton;
class QRadioButton;
class QCheckBox;
class QSlider;
class QComboBox;
class QLabel;
class QLineEdit;

class G4OpenGLQtExportDialog : public QDialog
{
  Q_OBJECT

public:
  G4OpenGLQtExportDialog(QWidget* parent, QString name, int, int);
  ~G4OpenGLQtExportDialog();

  int getSliderValue();

public slots:
  void changeSizeBox(bool);  
  void keepRatio();  

signals:
  void options(const QString&, const QString&, int, bool);
  void exportAll(const QString&, const QString&, int, bool);

private:
  QString f_name, f_type, f_dir;
  QLabel* qualityLabel;
  bool expAll;
  QPushButton* buttonOk;
  QPushButton* buttonCancel;
  //  QButtonGroup* GroupBox1, *GroupBox2;
  QCheckBox* boxEPS,*boxTransparency;
  QCheckBox* ratioCheckBox;
  QSlider * qualitySlider;
  QLabel *formatLabel;
  QRadioButton* color,*BW;
  QRadioButton* original,* modify;
  QLineEdit* height,*width;
  QWidget* heightWidget,* widthWidget;
  int originalWidth;
  int originalHeight;


};

#endif

#endif
