//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4OpenGLQtExportDialog.cc,v 1.4 2007/11/13 17:48:51 lgarnier Exp $
// GEANT4 tag $Name:  $
//
// 

#define GEANT4_QT_DEBUG
#ifdef G4VIS_BUILD_OPENGLQT_DRIVER

#include "G4OpenGLQtExportDialog.hh"

#include <qvariant.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qslider.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qradiobutton.h>
#include <qimage.h>
#include <qlineedit.h>
#include <qbuttongroup.h>

G4OpenGLQtExportDialog::G4OpenGLQtExportDialog(
 QWidget* parent
,QString nomFich
 ,int aHeight
 ,int aWidth
)
  : QDialog( parent )
{
#if QT_VERSION < 0x040000
  setCaption( tr( " Export options" ));
#else
  setWindowTitle( tr( " Export options" ));
#endif
  originalWidth = aWidth;
  originalHeight = aHeight;

  // Initializations
  qualitySlider = NULL;
  width = NULL;
  height = NULL;
  colorButton = NULL;
  BWButton = NULL;

  // global layout
  QVBoxLayout* globalVLayout = new QVBoxLayout(this);

  
  if (nomFich.endsWith(".jpg") || 
      nomFich.endsWith(".jpeg")) {
    
    QGroupBox *imageGroupBox = new QGroupBox(tr("Image quality"),this);
    QVBoxLayout *imageGroupBoxLayout = new QVBoxLayout(imageGroupBox);
    QWidget *sliderBox = new QWidget();

    QHBoxLayout *hSliderLayout = new QHBoxLayout(sliderBox);

    //    qualityLabel =  new QLabel( tr( "Image quality" ) );
    //    imageGroupBoxLayout->addWidget(qualityLabel);
    qualitySlider= new QSlider(Qt::Horizontal,sliderBox);
#if QT_VERSION < 0x040000
    qualitySlider->setMinValue(0);
    qualitySlider->setMaxValue(100);
    qualitySlider->setTickmarks(QSlider::Below); 
#else
    qualitySlider->setMinimum(0);
    qualitySlider->setMaximum(100);
    qualitySlider->setTickPosition(QSlider::TicksBelow);
#endif
    qualitySlider->setValue(60);
    hSliderLayout->addWidget(new QLabel("low",sliderBox));
    hSliderLayout->addWidget(qualitySlider);
    hSliderLayout->addWidget(new QLabel("Maximum",sliderBox));
#if QT_VERSION >= 0x040000
    sliderBox->setLayout(hSliderLayout);
#endif
    imageGroupBoxLayout->addWidget(sliderBox);

#if QT_VERSION >= 0x040000
    imageGroupBox->setLayout(imageGroupBoxLayout);
#endif
    globalVLayout->addWidget(imageGroupBox);
  }
  
  if ((nomFich.endsWith(".ps")) || (nomFich.endsWith(".pdf")) || (nomFich.endsWith(".eps"))) {

    //    transparencyEPS = new QCheckBox( "transparencyEPS" );
    //    transparencyEPS->setText( "save background" );
    //    transparencyEPS->setChecked( true );

    QWidget * EPSWidgetGroupBox; // widget containing group button
    QButtonGroup * EPSButtonGroupBox; // group button 


#if QT_VERSION < 0x040000
    colorButton = new QRadioButton("Color",EPSWidgetGroupBox);
    BWButton = new QRadioButton("Grayscale",EPSWidgetGroupBox);
    EPSButtonGroupBox = new QButtonGroup( 2,Qt::Vertical, tr("EPS options"),this);
    EPSButtonGroupBox->insert(colorButton);
    EPSButtonGroupBox->insert(BWButton);
    EPSButtonGroupBox->setExclusive(true);
    EPSWidgetGroupBox = EPSButtonGroupBox;

#else
    EPSWidgetGroupBox = new QGroupBox(tr("EPS options"));
    QVBoxLayout *EPSGroupBoxLayout = new QVBoxLayout(EPSWidgetGroupBox);

    colorButton = new QRadioButton("Color",EPSWidgetGroupBox);
    BWButton = new QRadioButton("Grayscale",EPSWidgetGroupBox);

    EPSButtonGroupBox = new QButtonGroup();
    EPSButtonGroupBox->addButton(colorButton);
    EPSButtonGroupBox->addButton(BWButton);
    EPSButtonGroupBox->setExclusive(true);

    EPSGroupBoxLayout->addWidget(colorButton);    
    EPSGroupBoxLayout->addWidget(BWButton);    
    EPSWidgetGroupBox->setLayout(EPSGroupBoxLayout);

#endif
    colorButton->setChecked( true );

    //    EPSGroupBoxLayout->addWidget(transparencyEPS);    
    globalVLayout->addWidget(EPSWidgetGroupBox);

  }

  if(nomFich.endsWith(".tif") ||
     nomFich.endsWith(".tiff") ||
     nomFich.endsWith(".jpg") ||
     nomFich.endsWith(".jpeg") ||
     nomFich.endsWith(".png") ||
     nomFich.endsWith(".xpm")) {

    QGroupBox *transparencyGroupBox = new QGroupBox(tr("Transparency"),this);
    QVBoxLayout *transparencyGroupBoxLayout = new QVBoxLayout(transparencyGroupBox);

    boxTransparency = new QCheckBox("Save transparency",transparencyGroupBox);
    boxTransparency->setChecked( false );
    //    boxTransparency->setEnabled(false);

    transparencyGroupBoxLayout->addWidget(boxTransparency);    
#if QT_VERSION >= 0x040000
    transparencyGroupBox->setLayout(transparencyGroupBoxLayout);
#endif
    globalVLayout->addWidget(transparencyGroupBox);

  }

  // size box
  QWidget* modifyAndRatioWidget = new QWidget();

  QHBoxLayout *modifyAndRatioLayout = new QHBoxLayout(modifyAndRatioWidget);

  QWidget * sizeWidgetGroupBox; // widget containing group button
  QButtonGroup * sizeButtonGroupBox; // group button 
  QLayout *sizeGroupBoxLayout;
#if QT_VERSION < 0x040000
  sizeButtonGroupBox = new QButtonGroup ( 2,Qt::Vertical, tr("Size"),this);

  original = new QRadioButton("Original",sizeButtonGroupBox);
  modify = new QRadioButton("Modify",sizeButtonGroupBox);

  sizeButtonGroupBox->insert(original);
  sizeButtonGroupBox->insert(modify);
  sizeButtonGroupBox->setExclusive(true);
  sizeWidgetGroupBox = sizeButtonGroupBox;
  sizeGroupBoxLayout = sizeWidgetGroupBox->layout();

#else
  
  sizeWidgetGroupBox = new QGroupBox(tr("Size"));
  sizeGroupBoxLayout = new QVBoxLayout(sizeWidgetGroupBox);
  sizeButtonGroupBox = new QButtonGroup();

  original = new QRadioButton("Original");
  modify = new QRadioButton("Modify");

  sizeButtonGroupBox->addButton(modify);
  sizeButtonGroupBox->addButton(original);
  sizeButtonGroupBox->setExclusive(true);

  sizeGroupBoxLayout->addWidget(modify);    
  sizeGroupBoxLayout->addWidget(original);    
  
  sizeWidgetGroupBox->setLayout(sizeGroupBoxLayout);
#endif
  original->setChecked( true );


  ratioCheckBox = new QCheckBox( "Keep ratio",modifyAndRatioWidget);
  ratioCheckBox->setChecked( true );

  modifyAndRatioLayout->addWidget(modify);
  modifyAndRatioLayout->addWidget(ratioCheckBox);
#if QT_VERSION >= 0x040000
  modifyAndRatioWidget->setLayout(modifyAndRatioLayout);
#endif
#if QT_VERSION < 0x040000
  sizeGroupBoxLayout->add(modifyAndRatioWidget);
#else
  sizeGroupBoxLayout->addWidget(modifyAndRatioWidget);
#endif
  if (modify->isChecked()) {
    ratioCheckBox->show();
  } else {
    ratioCheckBox->hide();
  }

#if QT_VERSION < 0x040000
  connect( sizeButtonGroupBox, SIGNAL( clicked(int) ), this, SLOT( changeSizeBox()) );
#else
  connect( sizeButtonGroupBox, SIGNAL( buttonClicked(int) ), this, SLOT( changeSizeBox()) );
#endif

  // height
  heightWidget = new QWidget();

  QHBoxLayout *heightLineLayout = new QHBoxLayout(heightWidget);

  QString tmp;
 
  heightLineLayout->addWidget(new QLabel("Height",heightWidget));
  height = new QLineEdit(tmp.setNum(originalHeight),heightWidget);
  height->setMaxLength(5);
#if QT_VERSION < 0x040000
  heightLineLayout->add(height);
#else
  heightLineLayout->addWidget(height);
#endif
#if QT_VERSION >= 0x040000
  heightWidget->setLayout(heightLineLayout);
#endif
#if QT_VERSION < 0x040000
  sizeGroupBoxLayout->add(heightWidget);
#else
  sizeGroupBoxLayout->addWidget(heightWidget);
#endif
  connect( height, SIGNAL( textChanged ( const QString& ) ), this, SLOT( textHeightChanged(const QString &) ) );


  // width
  widthWidget = new QWidget();

  QHBoxLayout *widthLineLayout = new QHBoxLayout(widthWidget);

#if QT_VERSION < 0x040000
  widthLineLayout->add(new QLabel("Width ",widthWidget));
#else
  widthLineLayout->addWidget(new QLabel("Width ",widthWidget));
#endif
  width = new QLineEdit(tmp.setNum(originalWidth),widthWidget);
  width->setMaxLength(5);
#if QT_VERSION < 0x040000
  widthLineLayout->add(width);
#else
  widthLineLayout->addWidget(width);
#endif
#if QT_VERSION >= 0x040000
  widthWidget->setLayout(widthLineLayout);
#endif
#if QT_VERSION < 0x040000
  sizeGroupBoxLayout->add(widthWidget);
#else
  sizeGroupBoxLayout->addWidget(widthWidget);
#endif
  connect( width, SIGNAL( textChanged ( const QString& ) ), this, SLOT( textWidthChanged(const QString &) ) );

#if QT_VERSION >= 0x040000
  sizeWidgetGroupBox->setLayout(sizeGroupBoxLayout);
#endif
  globalVLayout->addWidget(sizeWidgetGroupBox);

  heightWidget->hide();
  widthWidget->hide();

  // button ok/cancel box

  QGroupBox *buttonGroupBox = new QGroupBox(this);

  QHBoxLayout *buttonGroupBoxLayout = new QHBoxLayout(buttonGroupBox);

  buttonOk = new QPushButton( tr( "&OK" ),buttonGroupBox );
  buttonOk->setAutoDefault( TRUE );
  buttonOk->setDefault( TRUE );
  buttonGroupBoxLayout->addWidget(buttonOk);

  buttonCancel = new QPushButton( tr( "&Cancel" ),buttonGroupBox );
  buttonCancel->setAutoDefault( TRUE );
  buttonGroupBoxLayout->addWidget(buttonCancel);

#if QT_VERSION >= 0x040000
  buttonGroupBox->setLayout(buttonGroupBoxLayout);
#endif
  globalVLayout->addWidget(buttonGroupBox);


#if QT_VERSION >= 0x040000
  setLayout(globalVLayout);
#endif

  // signals and slots connections
  connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
  connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
}



int G4OpenGLQtExportDialog::getSliderValue()
{
  if (!qualitySlider) return -1;
  return qualitySlider->value();
}

int G4OpenGLQtExportDialog::getHeight()
{
  if (!height) return -1;
  return height->text().toInt();
}

int G4OpenGLQtExportDialog::getWidth()
{
  if (!width) return -1;
  return width->text().toInt();
}

bool G4OpenGLQtExportDialog::getTransparency()
{
  if (!boxTransparency) return -1;
  return boxTransparency->isChecked();
}

int G4OpenGLQtExportDialog::getNbColor()
{
  // Black and white
  if (!colorButton->isChecked())
    return 1;
  // rgb color
  return 3;
}


void G4OpenGLQtExportDialog::changeSizeBox()
{
  if ( original->isChecked()) {
    heightWidget->hide();
    widthWidget->hide();
    ratioCheckBox->hide();
  } else {
    heightWidget->show();
    widthWidget->show();
    ratioCheckBox->show();
  }
}

void G4OpenGLQtExportDialog::textWidthChanged(
 const QString & s
 )
{
  if (ratioCheckBox->isChecked()){
    QString tmp;
    width->setText(tmp.setNum(s.toInt()*originalHeight/originalHeight));
  }
}

void G4OpenGLQtExportDialog::  textHeightChanged(
 const QString & s
)
{
  if (ratioCheckBox->isChecked()){
    QString tmp;
    width->setText(tmp.setNum(s.toInt()*originalWidth/originalWidth));
  }
} 

G4OpenGLQtExportDialog::~G4OpenGLQtExportDialog()
{
}


#endif
