//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4OpenGLQtMovieDialog.cc,v 1.6 2008/02/15 10:54:13 lgarnier Exp $
// GEANT4 tag $Name:  $
//
// 

#define GEANT4_QT_DEBUG
#ifdef G4VIS_BUILD_OPENGLQT_DRIVER

#include "G4OpenGLQtMovieDialog.hh"
#include "G4OpenGLQtViewer.hh"

// #include <qvariant.h>
#include <qpushbutton.h>
// #include <qcheckbox.h>
#include <qlabel.h>
// #include <qcombobox.h>
// #include <qslider.h>
#include <qlayout.h>
// #include <qgroupbox.h>
// #include <qradiobutton.h>
// #include <qimage.h>
#include <qlineedit.h>
#include <qfiledialog.h>
#include <qprocess.h>

// #include <qbuttongroup.h>

// +---------------------------------------+
// +        Path for encoder               +
// +  _______                              +
// + | select| ____________________        +
// +  -------                              +
// +                                       +
// + max number of frames  ________        +
// + ....                                  +
// +                                       +
// +     Label : X frames Saves/Encoding   +
// +         Cancel        Encode          +
// +---------------------------------------+

G4OpenGLQtMovieDialog::G4OpenGLQtMovieDialog(
 QWidget* parent
)
  : QDialog( parent ),
    fParent(parent)
{
  setModal(false);
#if QT_VERSION < 0x040000
  setCaption( tr( " Movie parameters" ));
#else
  setWindowTitle( tr( " Movie parameters" ));
#endif


  // global layout
  QVBoxLayout* globalVLayout = new QVBoxLayout(this);
  globalVLayout->setMargin(10);
  globalVLayout->setSpacing(10);
  
  QLabel *pathLabel = new QLabel("Select path for encoder :");

#if QT_VERSION < 0x040000
  globalVLayout->add(pathLabel);
#else
  globalVLayout->addWidget(pathLabel);
#endif



  // width
  QWidget *selectPathWidget = new QWidget(this);

  QHBoxLayout *selectPathLineLayout = new QHBoxLayout(selectPathWidget);


  fSelectPath = new QLineEdit("",selectPathWidget);
#if QT_VERSION < 0x040000
  selectPathLineLayout->add(fSelectPath);
#else
  selectPathLineLayout->addWidget(fSelectPath);
#endif

  QPushButton *pathButton = new QPushButton(tr("..."),selectPathWidget);

#if QT_VERSION < 0x040000
  selectPathLineLayout->add(pathButton);
#else
  selectPathLineLayout->addWidget(pathButton);
#endif

#if QT_VERSION >= 0x040000
  selectPathWidget->setLayout(selectPathLineLayout);
#endif
  connect( pathButton, SIGNAL( clicked( ) ), this, SLOT(selectPathAction() ) );

#if QT_VERSION < 0x040000
  globalVLayout->add(selectPathWidget);
#else
  globalVLayout->addWidget(selectPathWidget);
#endif

  fSelectPath->setText(((G4OpenGLQtViewer*)fParent)->getEncoderPath());

  QLabel *infoLabel = new QLabel("  Press SPACE to Start/Pause video recording \n  Press RETURN to Stop video recording");

#if QT_VERSION < 0x040000
  globalVLayout->add(infoLabel);
#else
  globalVLayout->addWidget(infoLabel);
#endif

  QWidget *buttonBox = new QWidget(this);

  QHBoxLayout *buttonBoxLayout = new QHBoxLayout(buttonBox);


  QPushButton * buttonEncode = new QPushButton( tr( "&Apply" ),buttonBox );
  buttonEncode->setAutoDefault( TRUE );
  buttonEncode->setDefault( TRUE );
  buttonBoxLayout->addWidget(buttonEncode);

  QPushButton *buttonCancel = new QPushButton( tr( "&Cancel" ),buttonBox );
  buttonCancel->setAutoDefault( TRUE );
  buttonBoxLayout->addWidget(buttonCancel);

#if QT_VERSION >= 0x040000
  buttonBox->setLayout(buttonBoxLayout);
#endif
  globalVLayout->addWidget(buttonBox);



#if QT_VERSION >= 0x040000
  setLayout(globalVLayout);
#endif

  // signals and slots connections
  connect( buttonEncode, SIGNAL( clicked() ), this, SLOT( accept() ) );
  connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
}



G4OpenGLQtMovieDialog::~G4OpenGLQtMovieDialog()
{
}

void G4OpenGLQtMovieDialog::selectPathAction()
{
  QString nomFich =  QFileDialog::getOpenFileName ( this,
                                                    "Select your encoder",
                                                    tr("Select your encoder ...")); 
  if (nomFich == "") {
    return;
  }
  fSelectPath->setText(nomFich);
}


#endif
