//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4OpenGLQtMovieDialog.cc,v 1.6 2008/02/15 10:54:13 lgarnier Exp $
// GEANT4 tag $Name:  $
//
// 

#define GEANT4_QT_DEBUG
#ifdef G4VIS_BUILD_OPENGLQT_DRIVER

#include "G4OpenGLQtMovieDialog.hh"
#include "G4OpenGLQtViewer.hh"

#include <qpushbutton.h>
#include <qpalette.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qfiledialog.h>
#include <qprocess.h>


// +---------------------------------------+
// +        Path for encoder               +
// +  _______                              +
// + | select| ____________________        +
// +  -------                              +
// +        Temp path                      +
// +  _______                              +
// + | select| ____________________        +
// +  -------                              +
// +                                       +
// + max number of frames  ________        +
// + ....                                  +
// +                                       +
// +     Label : X frames Saves/Encoding   +
// +         Cancel        Encode          +
// +---------------------------------------+

G4OpenGLQtMovieDialog::G4OpenGLQtMovieDialog(
 G4OpenGLQtViewer* parentViewer,
 QWidget* parentWidget
)
  : QDialog( parentWidget ),
    fParentViewer(parentViewer)
{
  setModal(false);
#if QT_VERSION < 0x040000
  setCaption( tr( " Movie parameters" ));
#else
  setWindowTitle( tr( " Movie parameters" ));
#endif


  // global layout
  QVBoxLayout* globalVLayout = new QVBoxLayout(this);
  globalVLayout->setMargin(10);
  globalVLayout->setSpacing(10);
  
  // Encoder group box
  QGroupBox *encoderGroupBox = new QGroupBox(tr("Encoder path"));		
  QVBoxLayout *encoderVGroupBoxLayout = new QVBoxLayout(encoderGroupBox);

  // Encoder Path 
  QWidget *encoderHBox = new QWidget(encoderGroupBox);
  QHBoxLayout *encoderHBoxLayout = new QHBoxLayout(encoderHBox);
  fEncoderPath = new QLineEdit("",encoderHBox);

  QPushButton *encoderButton = new QPushButton(tr("..."),encoderHBox);
  encoderButton->setMaximumWidth (30);

  fEncoderStatus = new QLabel(encoderGroupBox);
  fEncoderStatus->setText("");

#if QT_VERSION < 0x040000
  encoderHBoxLayout->add(fEncoderPath);
  encoderHBoxLayout->add(encoderButton);
  encoderVGroupBoxLayout->add(encoderHBox);
  encoderVGroupBoxLayout->add(fEncoderStatus);

  globalVLayout->add(encoderGroupBox);
#else
  encoderHBoxLayout->addWidget(fEncoderPath);
  encoderHBoxLayout->addWidget(encoderButton);
  encoderVGroupBoxLayout->addWidget(encoderHBox);
  encoderVGroupBoxLayout->addWidget(fEncoderStatus);

  encoderGroupBox->setLayout(encoderVGroupBoxLayout);
  globalVLayout->addWidget(encoderGroupBox);
#endif

  connect( encoderButton, SIGNAL( clicked( ) ), this, SLOT(selectEncoderPathAction() ) );

  fEncoderPath->setText(fParentViewer->getEncoderPath());


  // temp folder group box
  QGroupBox *tempFolderGroupBox = new QGroupBox(tr("Temporary folder path"));		
  QVBoxLayout *tempFolderVGroupBoxLayout = new QVBoxLayout(tempFolderGroupBox);

  // temp folder Path 
  QWidget *tempFolderHBox = new QWidget(tempFolderGroupBox);
  QHBoxLayout *tempFolderHBoxLayout = new QHBoxLayout(tempFolderHBox);

  fTempFolderPath = new QLineEdit("",tempFolderHBox);

  QPushButton *tempButton = new QPushButton(tr("..."),tempFolderHBox);
  tempButton->setMaximumWidth (30);

  fTempFolderStatus = new QLabel(tempFolderGroupBox);
  fTempFolderStatus->setText("");

#if QT_VERSION < 0x040000
  tempFolderHBoxLayout->add(fTempFolderPath);
  tempFolderHBoxLayout->add(tempButton);
  tempFolderVGroupBoxLayout->add(tempFolderHBox);
  tempFolderVGroupBoxLayout->add(fTempFolderStatus);

  globalVLayout->add(tempFolderGroupBox);
#else
  tempFolderHBoxLayout->addWidget(fTempFolderPath);
  tempFolderHBoxLayout->addWidget(tempButton);
  tempFolderVGroupBoxLayout->addWidget(tempFolderHBox);
  tempFolderVGroupBoxLayout->addWidget(fTempFolderStatus);

  tempFolderGroupBox->setLayout(tempFolderVGroupBoxLayout);
  globalVLayout->addWidget(tempFolderGroupBox);
#endif

  connect( tempButton, SIGNAL( clicked( ) ), this, SLOT(selectTempPathAction() ) );

  fTempFolderPath->setText(fParentViewer->getTempFolderPath());



  // save file group box
  QGroupBox *saveFileGroupBox = new QGroupBox(tr("Save as"));		
  QVBoxLayout *saveFileVGroupBoxLayout = new QVBoxLayout(saveFileGroupBox);

  // save file 
  QWidget *saveFileHBox = new QWidget(saveFileGroupBox);
  QHBoxLayout *saveFileHBoxLayout = new QHBoxLayout(saveFileHBox);

  fSaveFileName = new QLineEdit("",saveFileHBox);

  QPushButton *saveButton = new QPushButton(tr("..."),saveFileHBox);
  saveButton->setMaximumWidth (30);

  fSaveFileStatus = new QLabel(saveFileGroupBox);
  fSaveFileStatus->setText("");

#if QT_VERSION < 0x040000
  saveFileHBoxLayout->add(fSaveFileName);
  saveFileHBoxLayout->add(saveButton);
  saveFileVGroupBoxLayout->add(saveFileHBox);
  saveFileVGroupBoxLayout->add(fSaveFileStatus);

  globalVLayout->add(saveFileGroupBox);
#else
  saveFileHBoxLayout->addWidget(fSaveFileName);
  saveFileHBoxLayout->addWidget(saveButton);
  saveFileVGroupBoxLayout->addWidget(saveFileHBox);
  saveFileVGroupBoxLayout->addWidget(fSaveFileStatus);

  saveFileGroupBox->setLayout(saveFileVGroupBoxLayout);
  globalVLayout->addWidget(saveFileGroupBox);
#endif

  connect( saveButton, SIGNAL( clicked( ) ), this, SLOT(selectSaveFileNameAction() ) );



  // label

  QLabel *infoLabel = new QLabel("  Press SPACE to Start/Pause video recording \n  Press RETURN to Stop video recording");

  // global status
  QGroupBox *statusGroupBox = new QGroupBox(tr("Status"));
  QVBoxLayout *statusVGroupBoxLayout = new QVBoxLayout(statusGroupBox);
  fGlobalStatus = new QLabel(statusGroupBox);
  fGlobalStatus->setText("");

#if QT_VERSION < 0x040000
  statusVGroupBoxLayout->add(fGlobalStatus);

  globalVLayout->add(infoLabel);
  globalVLayout->add(statusGroupBox);
#else
  statusVGroupBoxLayout->addWidget(fGlobalStatus);

  statusGroupBox->setLayout(statusVGroupBoxLayout);
  globalVLayout->addWidget(infoLabel);
  globalVLayout->addWidget(statusGroupBox);
#endif

  // buttons
  QWidget *buttonBox = new QWidget(this);

  QHBoxLayout *buttonBoxLayout = new QHBoxLayout(buttonBox);

  QPushButton *buttonCancel = new QPushButton( tr( "&Cancel" ),buttonBox );
  buttonCancel->setAutoDefault( TRUE );
  buttonBoxLayout->addWidget(buttonCancel);

  QPushButton *buttonApply = new QPushButton( tr( "&Apply" ),buttonBox );
  buttonApply->setAutoDefault( TRUE );
  buttonApply->setDefault( TRUE );
  buttonBoxLayout->addWidget(buttonApply);

  QPushButton * buttonEncode = new QPushButton( tr( "&Encode" ),buttonBox );
  buttonEncode->setEnabled(false); 
  buttonEncode->setAutoDefault( TRUE );
  buttonBoxLayout->addWidget(buttonEncode);

#if QT_VERSION >= 0x040000
  buttonBox->setLayout(buttonBoxLayout);
#endif
  globalVLayout->addWidget(buttonBox);



#if QT_VERSION >= 0x040000
  setLayout(globalVLayout);
#endif

  // signals and slots connections
  connect( buttonApply, SIGNAL( clicked() ), this, SLOT( checkAllParameters() ) );
  connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
  connect( buttonEncode, SIGNAL( clicked() ), this, SLOT( encode() ) );
}



G4OpenGLQtMovieDialog::~G4OpenGLQtMovieDialog()
{
}

void G4OpenGLQtMovieDialog::selectEncoderPathAction()
{
  QString nomFich =  QFileDialog::getOpenFileName ( this,
                                                    "Select your encoder",
                                                    tr("Select your encoder ...")); 
  if (nomFich == "") {
    return;
  }
  checkEncoderParameters(nomFich);
 }

void G4OpenGLQtMovieDialog::selectTempPathAction()
{
  QString nomFich =  QFileDialog::getOpenFileName ( this,
                                                    "Select temporary folder",
                                                    tr("Select temporary folder ...")); 
  if (nomFich == "") {
    return;
  }
  checkTempFolderParameters(nomFich);
 }

void G4OpenGLQtMovieDialog::selectSaveFileNameAction()
{
  QString nomFich =  QFileDialog::getOpenFileName ( this,
                                                    "Select saved file",
                                                    tr("Select saved file ...")); 
  if (nomFich == "") {
    return;
  }
  checkSaveFileNameParameters(nomFich);
 }

void G4OpenGLQtMovieDialog::encode() {
}

/** Check all parameters
*/
void G4OpenGLQtMovieDialog::checkAllParameters() {
  checkEncoderParameters(fEncoderPath->text());
  checkTempFolderParameters(fTempFolderPath->text());
  checkSaveFileNameParameters(fSaveFileName->text());
}

	/**
 * If one of parameter is incorrect, put it in red and don't valid it
 * If valid, save it
 */
void G4OpenGLQtMovieDialog::checkEncoderParameters(QString param) {

  QPalette palette( fEncoderPath->palette() );

  QString temp = fParentViewer->setEncoderPath(param);
  fGlobalStatus->setText("");
    fEncoderStatus->setText(temp);
  if (temp != "") {
    palette.setColor( QPalette::Base, Qt::red);
    fGlobalStatus->setText("If no valid encode defined, screen \ncapture files will be saved in the\ntemp folder in ppm format.");
  } else {
    palette.setColor( QPalette::Base, Qt::white);
    fEncoderPath->setText(fParentViewer->getEncoderPath());
  }
  fEncoderPath->setPalette(palette);
}


/**
 * If one of parameter is incorrect, put it in red and don't valid it
 * If valid, save it
 */
void G4OpenGLQtMovieDialog::checkTempFolderParameters(QString param) {

  QPalette palette( fTempFolderPath->palette() );

  QString temp = fParentViewer->setTempFolderPath(param);
  fTempFolderStatus->setText(temp);
  if (temp != "") {
    palette.setColor( QPalette::Base, Qt::red);
  } else {
    palette.setColor( QPalette::Base, Qt::white);
    fTempFolderPath->setText(fParentViewer->getTempFolderPath());
  }
  fTempFolderPath->setPalette(palette);
}


/**
 * If one of parameter is incorrect, put it in red and don't valid it
 * If valid, save it
 */
void G4OpenGLQtMovieDialog::checkSaveFileNameParameters(QString param) {

  QPalette palette( fSaveFileName->palette() );

  QString temp = fParentViewer->setSaveFileName(param);
    fSaveFileStatus->setText(temp);
  if (temp != "") { 
    palette.setColor( QPalette::Base, Qt::red);
  } else {
    palette.setColor( QPalette::Base, Qt::white);
    fSaveFileName->setText(fParentViewer->getSaveFileName());
  }
  fSaveFileName->setPalette(palette);
}
#endif
