//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4OpenGLXViewerMessenger.hh,v 1.2 2006/11/01 11:22:26 allison Exp $
// GEANT4 tag $Name: geant4-08-02-patch-01 $

#ifdef G4VIS_BUILD_OPENGLX_DRIVER

#ifndef G4OPENGLXVIEWERMESSENGER_HH
#define G4OPENGLXVIEWERMESSENGER_HH

#include "G4UImessenger.hh"

#include "G4String.hh"

class G4OpenGLXViewer;
class G4UIdirectory;
class G4UIcmdWithoutParameter;

class G4OpenGLXViewerMessenger: public G4UImessenger {
public:
  static G4OpenGLXViewerMessenger* GetInstance();  // Singleton constructor.
  ~G4OpenGLXViewerMessenger();
  void SetNewValue (G4UIcommand*, G4String);

private:
  G4OpenGLXViewerMessenger();  // Private constructor.
  static G4OpenGLXViewerMessenger* fpInstance;
  G4UIdirectory* fpDirectory;
  G4UIcmdWithoutParameter* fpCommandPrintEPS;
};

#endif

#endif
