// %%%%%%%%%%%%
// gemc headers
// %%%%%%%%%%%%
#include "Clas12_HitProcess_MapRegister.h"
#include "BST_hitprocess.h"          
#include "FST_hitprocess.h"          
#include "CTOF_hitprocess.h"         
#include "CND_hitprocess.h"          
#include "DC_hitprocess.h"           
#include "OTOF_hitprocess.h"         
#include "raw_hitprocess.h"          
#include "MPHBaseClass.h"

map<string, MPHB_Factory> Clas12_HitProcess_Map()
{
 map<string, MPHB_Factory> Clas12Map;
 Clas12Map["BST"]     = &BST_HitProcess::createHitClass;
 Clas12Map["FST"]     = &FST_HitProcess::createHitClass;
 Clas12Map["CTOF"]    = &CTOF_HitProcess::createHitClass;
 Clas12Map["CND"]     = &CND_HitProcess::createHitClass;
 Clas12Map["DC"]      = &DC_HitProcess::createHitClass;
 Clas12Map["OTOF_1a"] = &OTOF_HitProcess::createHitClass;
 Clas12Map["OTOF_1b"] = &OTOF_HitProcess::createHitClass;
 Clas12Map["OTOF_2b"] = &OTOF_HitProcess::createHitClass;
 Clas12Map["IC"]      = &raw_HitProcess::createHitClass;
 Clas12Map["raw"]     = &raw_HitProcess::createHitClass;

 return Clas12Map;
}
