// %%%%%%%%%%
// G4 headers
// %%%%%%%%%%
#include "G4BaryonConstructor.hh"
#include "G4LeptonConstructor.hh"
#include "G4MesonConstructor.hh"
#include "G4IonConstructor.hh"

#include "G4PhotoElectricEffect.hh"
#include "G4ComptonScattering.hh"
#include "G4GammaConversion.hh"

#include "G4MultipleScattering.hh"
#include "G4eIonisation.hh"
#include "G4eBremsstrahlung.hh"
#include "G4eplusAnnihilation.hh"

#include "G4MuIonisation.hh"
#include "G4MuBremsstrahlung.hh"
#include "G4MuPairProduction.hh"
#include "G4MuonMinusCaptureAtRest.hh"

#include "G4SynchrotronRadiation.hh"

#include "G4hIonisation.hh"
#include "G4ProcessManager.hh"
#include "G4StepLimiter.hh"

// %%%%%%%%%%%%
// gemc headers
// %%%%%%%%%%%%
#include "EMPhysics.h"


EMPhysics::EMPhysics(gemc_opts Opt) : G4VPhysicsConstructor("EM Physics")
{
 gemcOpt = Opt;
}

EMPhysics::~EMPhysics(){}

void EMPhysics::ConstructParticle()
{
 G4Gamma::GammaDefinition();

  //  Construct all mesons
  G4MesonConstructor pMesonConstructor;
  pMesonConstructor.ConstructParticle();

  //  Construct all leptons
  G4LeptonConstructor pLeptonConstructor;
  pLeptonConstructor.ConstructParticle();

  //  Construct all baryons
  G4BaryonConstructor pBaryonConstructor;
  pBaryonConstructor.ConstructParticle();

  // Construct light ions (d, t, 3He, alpha, and generic ion)
  G4IonConstructor ionConstruct;
  ionConstruct.ConstructParticle();
}


// see  cosmicray_charging/src/LISAPhysicsList.cc for possible switch to low energy EM.

void EMPhysics::ConstructProcess()
{
 string hd_msg = gemcOpt.args["LOG_MSG"].args + " EM / mu- Capture Physics List: <<< ";
 double   VERB = gemcOpt.args["PHY_VERBOSITY"].arg ;
 cout << hd_msg << " Building ElectroMagnetic and Capture Processes " << endl;

 theParticleIterator->reset();
 while( (*theParticleIterator)() )
 {
    G4ParticleDefinition* particle = theParticleIterator->value();
    G4ProcessManager*     pmanager = particle->GetProcessManager();
    string                pname    = particle->GetParticleName();

    // Gamma Physics
    if (pname == "gamma")
    {
       if(VERB > 2) cout << hd_msg << " Gamma: Photoelectric Effect" << endl;
       pmanager->AddDiscreteProcess(new G4PhotoElectricEffect);
       if(VERB > 2) cout << hd_msg << " Gamma: Compton Scattering" << endl;
       pmanager->AddDiscreteProcess(new G4ComptonScattering);
       if(VERB > 2) cout << hd_msg << " Gamma: Pair Production" << endl;
       pmanager->AddDiscreteProcess(new G4GammaConversion);
    }

    // Electron Physics
    else if (pname == "e-")
    {
       if(VERB > 2) cout << hd_msg << " Electron: Multiple Scattering" << endl;
       pmanager->AddProcess(new G4MultipleScattering, -1, 1, 1);
       if(VERB > 2) cout << hd_msg << " Electron: Ionisation" << endl;
       pmanager->AddProcess(new G4eIonisation,        -1, 2, 2);
       if(VERB > 2) cout << hd_msg << " Electron: Bremsstrahlung" << endl;
       pmanager->AddProcess(new G4eBremsstrahlung,    -1, 3, 3);
//        if(VERB > 2) cout << hd_msg << " Electron: synchrotron radiation" << endl;
//        pmanager->AddDiscreteProcess(new G4SynchrotronRadiation);

    }
    // Positron Physics
    else if (pname == "e+")
    {
       if(VERB > 2) cout << hd_msg << " Positron: Multiple Scattering" << endl;
       pmanager->AddProcess(new G4MultipleScattering, -1,  1, 1);
       if(VERB > 2) cout << hd_msg << " Positron: Ionisation" << endl;
       pmanager->AddProcess(new G4eIonisation,        -1,  2, 2);
       if(VERB > 2) cout << hd_msg << " Positron: Bremsstrahlung" << endl;
       pmanager->AddProcess(new G4eBremsstrahlung,    -1,  3, 3);
       if(VERB > 2) cout << hd_msg << " Positron: e+ Annihilation" << endl;
       pmanager->AddProcess(new G4eplusAnnihilation,   0, -1, 4);
//        if(VERB > 2) cout << hd_msg << " Positron: synchrotron radiation" << endl;
//        pmanager->AddDiscreteProcess(new G4SynchrotronRadiation);

    }
    // Muons Physics
    else if(pname == "mu+" || pname == "mu-")
    {
       if(VERB > 2) cout << hd_msg << " " << pname << ": Multiple Scattering" << endl;
       pmanager->AddProcess(new G4MultipleScattering, -1, 1, 1);
       if(VERB > 2) cout << hd_msg << " " << pname << ": Ionisation" << endl;
       pmanager->AddProcess(new G4MuIonisation,       -1, 2, 2);
       if(VERB > 2) cout << hd_msg << " " << pname << ": Bremsstrahlung" << endl;
       pmanager->AddProcess(new G4MuBremsstrahlung,   -1, 3, 3);
       if(VERB > 2) cout << hd_msg << " " << pname << ": Pair Production" << endl;
       pmanager->AddProcess(new G4MuPairProduction,   -1, 4, 4);
       if(pname == "mu-")
       {
          if(VERB > 2) cout << hd_msg << " " << pname << ": Capture Process" << endl;
          pmanager->AddProcess(new G4MuonMinusCaptureAtRest(),0,-1,-1);
       }
    }
    // All other charged particles except geantino
    else if ((!particle->IsShortLived()) && (particle->GetPDGCharge() != 0.0) && (pname != "chargedgeantino"))
    {
       if(VERB > 2) cout << hd_msg << " Adding Multiple Scattering for " << pname << endl;
       pmanager->AddProcess(new G4MultipleScattering, -1, 1, 1);
       if(VERB > 2) cout << hd_msg << " Adding Ionisation for " << pname << endl;
       pmanager->AddProcess(new G4hIonisation,        -1, 2, 2);
    }

    // Adding Step Limiter 
//    if ((!particle->IsShortLived()) && (pname != "chargedgeantino"))
    if ((!particle->IsShortLived()) && (particle->GetPDGCharge() != 0.0) && (pname != "chargedgeantino"))
    {
       if(VERB > 2) cout << hd_msg << " Adding Step Limiter for " << pname << endl;
       pmanager->AddProcess(new G4StepLimiter,       -1,-1,3);
    }


  }

}



