











#ifndef MEventAction_H
#define MEventAction_H 1

// %%%%%%%%%%
// G4 headers
// %%%%%%%%%%
#include "G4UserEventAction.hh"

// %%%%%%%%%%%%%
// gemc headers
// %%%%%%%%%%%%%
#include "MOutputBaseClass.h"
#include "MBankdefs.h"
#include "MPHBaseClass.h"
#include "MSensitiveDetector.h"
#include "usage.h"


class MEventAction : public G4UserEventAction
{
 public:
   MEventAction(gemc_opts);                            
  ~MEventAction();                                     

   gemc_opts gemcOpt;                                  

   MOutputs                         *MOut;             
   map<string, MOutput_Factory>      *Out;             
   map<string, MSensitiveDetector*>  SeDe_Map;         
   map<string, MPHB_Factory>        *MProcessHit_Map;  
   map<string, MBank>               *MBank_Map;        

   int evtN;                                      

 public:
   void BeginOfEventAction(const G4Event*);            
   void EndOfEventAction(const G4Event*);              
   void SetEvtNumber(int N){evtN = N;}            

};

#endif




