// %%%%%%%%%%
// G4 headers
// %%%%%%%%%%
#include "G4VVisManager.hh"
#include "G4Circle.hh"
#include "G4VisAttributes.hh"

// %%%%%%%%%%%%%
// gemc headers
// %%%%%%%%%%%%%
#include "MHit.h"

MHit::MHit() : G4VHit() {;}
MHit::~MHit() {;}

void MHit::Draw()
{
 G4VVisManager* pVVisManager = G4VVisManager::GetConcreteInstance();
 if(pVVisManager)
 {
    G4Circle circle(pos[0]);
    circle.SetFillStyle(G4Circle::filled);
    G4Colour colour_touch (0.0, 0.0, 1.0);
    G4Colour colour_hit   (1.0, 0.0, 0.0);
    G4Colour colour_passby(0.0, 1.0, 0.0);

    // If the energy is above threshold, red circle.
    // If the energy is below threshold, blue smaller circle.
    // If no energy deposited, green smaller circle.
    if(edep[0] > minEdep)
    {
       circle.SetVisAttributes(G4VisAttributes(colour_hit));
       circle.SetScreenSize(5);
    }
    else if(edep[0] > 0 && edep[0] <= minEdep)
    {
      circle.SetVisAttributes(G4VisAttributes(colour_touch));
      circle.SetScreenSize(4);
    }
    else if(edep[0] == 0)
    {
      circle.SetVisAttributes(G4VisAttributes(colour_passby));
      circle.SetScreenSize(4);
    }

    pVVisManager->Draw(circle);
 }
}

int MHit::mc_number_scheme(string pid)
{
 if(pid=="e-")            return 11;
 if(pid=="e+")            return -11;
 if(pid=="gamma")         return 22;
 if(pid=="neutron")       return 2112;
 if(pid=="proton")        return 2212;
 if(pid=="kaon+")         return 321;
 if(pid=="kaon-")         return -321;
 if(pid=="kaon0")         return 311;
 if(pid=="kaon0L")        return 130;
 if(pid=="pi+")           return 211;
 if(pid=="pi-")           return -211;
 if(pid=="p0")            return 111;
 if(pid=="opticalphoton") return -22;
 else return 0;
}
