







#ifndef MOUTBASECLASS_H
#define MOUTBASECLASS_H 1

// %%%%%%%%%%%%%
// gemc headers
// %%%%%%%%%%%%%
#include "MBankdefs.h"
#include "MPHBaseClass.h"
#include "usage.h"

// %%%%
// EVIO
// %%%%
//#include "evioUtil.hxx"
//using namespace evio;


class MGeneratedParticle
{
 public:
   MGeneratedParticle(){;}
  ~MGeneratedParticle(){;}

   G4ThreeVector vertex;
   G4ThreeVector momentum;
   int PID;
};



class MOutputs
{
 public:
    MOutputs(gemc_opts);
   ~MOutputs();

   gemc_opts gemcOpt;
   string outType;
   string outFile;

   ofstream        *txtoutput;
   //   evioFileChannel *pchan;
};

class MOutputBaseClass
{
 public:
   virtual void ProcessOutput(int, PH_output, MOutputs*, MBank)              = 0;  
   virtual void SetBankHeader(int, string, MOutputs*)                        = 0;  
   virtual void SetOutpHeader(int, MOutputs*)                                = 0;  
   virtual void RecordAndClear(MOutputs*, MBank)                             = 0;  
   virtual void WriteGenerated(MOutputs*, vector<MGeneratedParticle>)        = 0;  
   virtual void WriteEvent(MOutputs*)                                        = 0;  
   string outputType;
};

typedef MOutputBaseClass *(*MOutput_Factory)();                            

MOutputBaseClass *GetMOutputClass (map<string, MOutput_Factory>, string);  


#endif
