#ifndef MPrimaryGeneratorAction_h
#define MPrimaryGeneratorAction_h 1

// %%%%%%%%%%
// G4 headers
// %%%%%%%%%%
#include "G4VUserPrimaryGeneratorAction.hh"
#include "G4ParticleGun.hh"
#include "G4Event.hh"

// %%%%%%%%%%%%%
// gemc headers
// %%%%%%%%%%%%%
#include "usage.h"

// %%%%%%%%%%%%%%%%
// Class definition
// %%%%%%%%%%%%%%%%
class MPrimaryGeneratorAction : public G4VUserPrimaryGeneratorAction
{
 public:
   MPrimaryGeneratorAction(gemc_opts);
  ~MPrimaryGeneratorAction();

 public:
   void GeneratePrimaries(G4Event* anEvent);
   gemc_opts gemcOpt;
   double GEN_VERBOSITY;

 private:
   string input_gen;                 
   string hd_msg;                    
   G4ParticleTable* particleTable;   

   // Primary Beam
   G4ParticleDefinition *Particle;   
   double mom,   dmom,    Mom;       
   double theta, dtheta,  Theta;     
   double phi,   dphi,    Phi;       
   double vx, vy, vz;                
   double dvx, dvy, dvz;             
   double Vx, Vy, Vz;                
   G4ThreeVector beam_dir;           
   G4ThreeVector beam_vrt;           

   // Generators Input Files
   ifstream  gif;                    
   string    gformat;                
   string    gfilename;              

   // Luminosity Beam
   G4ParticleDefinition *L_Particle; 
   double L_Mom;                     
   double L_Theta;                   
   double L_Phi;                     
   double L_vx, L_vy, L_vz;          
   int NP;                           
   double TWINDOW;                   
   double TBUNCH;                    
   G4ThreeVector L_beam_dir;         
   G4ThreeVector L_beam_vrt;         

   G4ParticleGun* particleGun;
   void setBeam(gemc_opts);

};

#endif


