




#ifndef MSensitiveDetector_H
#define MSensitiveDetector_H 1

// %%%%%%%%%%
// G4 headers
// %%%%%%%%%%
#include "G4VSensitiveDetector.hh"
#include "G4Step.hh"
#include "G4HCofThisEvent.hh"
#include "G4TouchableHistory.hh"

// %%%%%%%%%%%%%
// gemc headers
// %%%%%%%%%%%%%
#include "detector.h"
#include "MHit.h"
#include "MPHBaseClass.h"

// %%%%%%%%%%%
// C++ headers
// %%%%%%%%%%%
#include <iostream>
#include <string>
#include <set>
using namespace std;


class SDId
{
 public:
   int id;                        
   vector<string> IDnames;        
   vector<int>    IDmaxs;         
   vector<int>    IDshifts;       
   double         minEnergy;      
   double         TimeWindow;     
   double         ProdThreshold;  
   double         MaxStep;        
};

class MTrackInfo
{
 public:
   string pid;
   G4ThreeVector v;
};

class MSensitiveDetector : public G4VSensitiveDetector
{

 public:
   MSensitiveDetector(G4String, gemc_opts);                     
   virtual ~MSensitiveDetector();

   virtual void Initialize(G4HCofThisEvent*);                   
   virtual G4bool ProcessHits(G4Step*, G4TouchableHistory*);    
   virtual void EndOfEvent(G4HCofThisEvent*);                   

   G4String HCname;                                             
   map<string, detector>          *Hall_Map;                    
   map<string, MPHB_Factory>      *MProcessHit_Map;             
   set<vector<identifier> >        Id_Set;                      
   map<int, MTrackInfo>            Tr_Map;                      

   gemc_opts gemcOpt;                                           
   SDId      SDID;                                              

 private:
   MHitCollection *hitCollection;                               
   int             HCID;                                        
   double minEnergy;

 public:
   vector<identifier> GetDetectorIdentifier(string name) {return (*Hall_Map)[name].identity;} 
   string GetDetectorHitType(string name)                {return (*Hall_Map)[name].hitType;}  
   int get_bit_compressed_id(vector<identifier>);                                             
   MHitCollection* GetMHitCollection()                   {return hitCollection;}              
   MHit* find_existing_hit(vector<identifier>);                                               
};

SDId get_SDId(string, gemc_opts);   

#endif










