



#ifndef MagneticField_H
#define MagneticField_H 1

// %%%%%%%%%%
// G4 headers
// %%%%%%%%%%
#include "G4FieldManager.hh"
#include "G4MagneticField.hh"


// %%%%%%%%%%%%%
// gemc headers
// %%%%%%%%%%%%%
#include "usage.h"

// %%%%%%%%%%%
// C++ headers
// %%%%%%%%%%%
#include <sstream>
using namespace std;

class MappedField : public G4MagneticField
{
 gemc_opts gemcOpt;                
 double table_start[3];
 double cell_size[3];
 double mapOrigin[3];

 string hd_msg;
 int MGN_VERBOSITY;

 public:
   MappedField();
  ~MappedField();

 // %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  
 // Constructor for phi-symmetric field in cylindrical coordinates
 // Arguments:
 // Options
 // Number of Tranverse Points,  Number of Longitudinal Points
 // Lower and Upper limits of the Tranverse Coordinates
 // Lower and Upper limits of the Longitudinal Coordinates
 // Map Filename
 // Map Origin
 // String of Units
 // %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 MappedField(gemc_opts, int, int, double Tlimits[2], double Llimits[2], string, double origin[3], string units[5]);

 // %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 // Constructor for phi-segmented field in cylindrical coordinates. Field is in cartesian coordinates.
 // The map is assumed to cover half the segment
 // Arguments:
 // Options
 // Number of Transverse Points, Number of Azimuthal Points, Number of Longitudinal Points
 // Lower and Upper limits of the Tranverse Coordinates
 // Lower and Upper limits of the Azimuthal Coordinates
 // Lower and Upper limits of the Longitudinal Coordinates
 // Map Filename
 // Map Origin
 // String of Units
 // %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 MappedField(gemc_opts, int, int, int, double Tlimits[2], double Llimits[2], double Zlimits[2], string, double origin[3], string units[5]);





 void GetFieldValue( const double x[3], double *Bfield) const;
 double segm_phi_span;  
 int    nsegments;      

 private:

   // 3D Cartesian Maps
   vector< vector < vector <double> > > B3DCartX ;
   vector< vector < vector <double> > > B3DCartY ;
   vector< vector < vector <double> > > B3DCartZ ;

   // 2D Cylindrical Maps - phi-symmetric, need only transverse and longitudinal (z) component
   vector< vector <double> > B2DCylT ;
   vector< vector <double> > B2DCylL ;

   // 3D Cylindrical Coordinates, Cartesian field Maps - phi-segmented
   vector< vector < vector <double> > > B3DCylX ;
   vector< vector < vector <double> > > B3DCylY ;
   vector< vector < vector <double> > > B3DCylZ ;
};


class MagneticField
{
 public:
   MagneticField(){;}
  ~MagneticField(){;}

 public:
   gemc_opts gemcOpt;                
   string    name;                   
   string    type;                   
   string    magnitude;              
   string    swim_method;            
   string    description;            

   MappedField *mappedfield;         

 private:
   G4FieldManager *MFM;              

 public: 
   G4FieldManager* get_MFM(){return MFM;}  
   void init_MFM(){MFM = NULL;}            
   void create_MFM();                      

};

map<string, MagneticField> get_magnetic_Fields(gemc_opts); 


#endif
